/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.voip.Packet;
import javaforce.voip.SIP;
import javaforce.voip.Transport;

public class TransportTCPClient
implements Transport {
    protected boolean connected = false;
    protected Socket socket;
    protected OutputStream os;
    protected InputStream is;
    protected InetAddress host;
    protected int port;
    private boolean error;
    private byte[] extra = null;

    @Override
    public String getName() {
        return "TCP";
    }

    @Override
    public boolean open(String localhost, int localport) {
        try {
            this.socket = new Socket();
            this.socket.setSoLinger(true, 0);
            this.socket.bind(new InetSocketAddress(localhost, localport));
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        return true;
    }

    @Override
    public boolean close() {
        this.connected = false;
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        return true;
    }

    @Override
    public boolean send(byte[] data, int off, int len, InetAddress host, int port) {
        try {
            if (!this.connected) {
                this.connect(host, port);
            }
            this.os.write(data, off, len);
            this.os.flush();
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        return true;
    }

    private int detectLength(byte[] data, int off, int len) {
        for (int a = 0; a < len - 3; ++a) {
            if (data[off + a + 0] != 13 || data[off + a + 1] != 10 || data[off + a + 2] != 13 || data[off + a + 3] != 10) continue;
            return a + 4;
        }
        return -1;
    }

    @Override
    public boolean receive(Packet packet) {
        try {
            int plen;
            if (this.is == null) {
                packet.length = 0;
                JF.sleep(100);
                return false;
            }
            if (this.extra != null) {
                System.arraycopy(this.extra, 0, packet.data, 0, this.extra.length);
                packet.length = this.extra.length;
                this.extra = null;
            } else {
                int read = this.is.read(packet.data);
                if (read == -1) {
                    throw new Exception();
                }
                packet.length = read;
            }
            do {
                if ((plen = this.detectLength(packet.data, 0, packet.length)) != -1) continue;
                int read = this.is.read(packet.data, packet.length, packet.data.length - packet.length);
                if (read == -1) {
                    throw new Exception();
                }
                packet.length += read;
            } while (plen == -1);
            int tlen = plen;
            String[] msg = new String(packet.data, 0, plen).split("\r\n");
            String clenstr = SIP.getHeader("Content-Length:", msg);
            if (clenstr == null) {
                SIP.getHeader("l:", msg);
            }
            if (clenstr != null) {
                int clen = JF.atoi(clenstr);
                tlen += clen;
            }
            while (packet.length < tlen) {
                int read = this.is.read(packet.data, packet.length, packet.data.length - packet.length);
                if (read == -1) {
                    throw new Exception();
                }
                packet.length += read;
            }
            if (packet.length > tlen) {
                this.extra = new byte[packet.length - tlen];
                System.arraycopy(packet.data, tlen, this.extra, 0, packet.length - tlen);
                packet.length = tlen;
            }
            packet.host = this.host.getHostAddress();
            packet.port = this.port;
        }
        catch (Exception e) {
            this.error = true;
            if (this.connected) {
                JFLog.log(e);
            }
            return false;
        }
        return true;
    }

    protected void connect(InetAddress host, int port) throws Exception {
        this.host = host;
        this.port = port;
        this.socket.connect(new InetSocketAddress(host, port), 5000);
        this.os = this.socket.getOutputStream();
        this.is = this.socket.getInputStream();
        this.connected = true;
    }

    @Override
    public boolean error() {
        return this.error;
    }
}

