/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.voip.Packet;
import javaforce.voip.SIP;
import javaforce.voip.Transport;

public class TransportTCPServer
implements Transport {
    protected ServerSocket ss;
    private HashMap<String, Socket> clients = new HashMap();
    private Object clientsLock = new Object();
    private boolean active;
    private boolean error;
    private static final int mtu = 1460;
    private ArrayList<Packet> packets = new ArrayList();
    private Object packetsLock = new Object();

    @Override
    public String getName() {
        return "TCP";
    }

    @Override
    public boolean open(String localhost, int localport) {
        try {
            this.ss = new ServerSocket(localport);
            this.active = true;
            new WorkerAccepter().start();
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        return true;
    }

    @Override
    public boolean close() {
        this.active = false;
        try {
            if (this.ss != null) {
                this.ss.close();
                this.ss = null;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(byte[] data, int off, int len, InetAddress host, int port) {
        Socket socket;
        String id = host.toString() + ":" + port;
        Object object = this.clientsLock;
        synchronized (object) {
            socket = this.clients.get(id);
        }
        try {
            if (socket == null) {
                socket = this.connect(host, port, id);
            }
            OutputStream os = socket.getOutputStream();
            os.write(data, off, len);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean receive(Packet packet) {
        while (true) {
            Object object = this.packetsLock;
            synchronized (object) {
                if (this.packets.size() == 0) {
                    try {
                        this.packetsLock.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.packets.size() != 0) {
                    Packet tmp = this.packets.remove(0);
                    System.arraycopy(tmp.data, 0, packet.data, 0, 1460);
                    packet.host = tmp.host;
                    packet.length = tmp.length;
                    packet.port = tmp.port;
                    return true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket connect(InetAddress host, int port, String id) throws Exception {
        Socket socket = new Socket(host, port);
        Object object = this.clientsLock;
        synchronized (object) {
            this.clients.put(id, socket);
        }
        return socket;
    }

    @Override
    public boolean error() {
        return this.error;
    }

    protected class WorkerAccepter
    extends Thread {
        protected WorkerAccepter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (TransportTCPServer.this.active) {
                try {
                    Socket socket = TransportTCPServer.this.ss.accept();
                    InetAddress host = socket.getInetAddress();
                    int port = socket.getPort();
                    String id = host.toString() + ":" + port;
                    Object object = TransportTCPServer.this.clientsLock;
                    synchronized (object) {
                        TransportTCPServer.this.clients.put(id, socket);
                    }
                    new WorkerReader(socket, id, host, port).start();
                }
                catch (Exception e) {
                    JFLog.log(e);
                }
            }
        }
    }

    private class WorkerReader
    extends Thread {
        private Socket socket;
        private String id;
        private InputStream is;
        private InetAddress host;
        private int port;
        private byte[] extra = null;

        public WorkerReader(Socket socket, String id, InetAddress host, int port) {
            this.socket = socket;
            this.id = id;
            this.host = host;
            this.port = port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.process();
            Object object = TransportTCPServer.this.clientsLock;
            synchronized (object) {
                TransportTCPServer.this.clients.remove(this.id);
            }
        }

        private int detectLength(byte[] data, int off, int len) {
            for (int a = 0; a < len - 3; ++a) {
                if (data[off + a + 0] != 13 || data[off + a + 1] != 10 || data[off + a + 2] != 13 || data[off + a + 3] != 10) continue;
                return a + 4;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() {
            try {
                this.is = this.socket.getInputStream();
            }
            catch (Exception e) {
                JFLog.log(e);
                return;
            }
            while (TransportTCPServer.this.active) {
                try {
                    int plen;
                    byte[] data = new byte[1460];
                    Packet packet = new Packet();
                    packet.data = data;
                    if (this.extra != null) {
                        System.arraycopy(this.extra, 0, packet.data, 0, this.extra.length);
                        packet.length = this.extra.length;
                        this.extra = null;
                    } else {
                        int read = this.is.read(packet.data);
                        if (read == -1) {
                            throw new Exception();
                        }
                        packet.length = read;
                    }
                    do {
                        if ((plen = this.detectLength(packet.data, 0, packet.length)) != -1) continue;
                        int read = this.is.read(packet.data, packet.length, packet.data.length - packet.length);
                        if (read == -1) {
                            throw new Exception();
                        }
                        packet.length += read;
                    } while (plen == -1);
                    int tlen = plen;
                    String[] msg = new String(packet.data, 0, plen).split("\r\n");
                    String clenstr = SIP.getHeader("Content-Length:", msg);
                    if (clenstr == null) {
                        SIP.getHeader("l:", msg);
                    }
                    if (clenstr != null) {
                        int clen = JF.atoi(clenstr);
                        tlen += clen;
                    }
                    while (packet.length < tlen) {
                        int read = this.is.read(packet.data, packet.length, packet.data.length - packet.length);
                        if (read == -1) {
                            throw new Exception();
                        }
                        packet.length += read;
                    }
                    if (packet.length > tlen) {
                        this.extra = new byte[packet.length - tlen];
                        System.arraycopy(packet.data, tlen, this.extra, 0, packet.length - tlen);
                        packet.length = tlen;
                    }
                    packet.host = this.host.getHostAddress();
                    packet.port = this.port;
                    Object object = TransportTCPServer.this.packetsLock;
                    synchronized (object) {
                        TransportTCPServer.this.packets.add(packet);
                        TransportTCPServer.this.packetsLock.notify();
                    }
                }
                catch (Exception e) {
                    TransportTCPServer.this.error = true;
                    JFLog.log(e);
                }
            }
        }
    }
}

