/*
 * Decompiled with CFR 0.152.
 */
package javaforce.gl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javaforce.JFLog;
import javaforce.gl.GL;
import javaforce.gl.Model;
import javaforce.gl.Object3;
import javaforce.gl.Texture;
import javaforce.gl.UVMap;
import javaforce.gl.model.GL_3DS;
import javaforce.gl.model.GL_BLEND;
import javaforce.gl.model.GL_JF3D;

public class Scene {
    private static final boolean DEBUG = false;
    private boolean needinittex = true;
    ArrayList<Model> ml;
    HashMap<String, Texture> tl;
    HashMap<String, Model> mtl;
    private ArrayList<Integer> freeglidlist;
    Texture blankTexture;
    public boolean inited = false;
    public String texturePath;
    public int fragShader;
    public int vertexShader;
    public int program;
    public int vpa;
    public int[] tca = new int[2];
    public int uUVMaps;
    public int mpu;
    public int mmu;
    public int mvu;

    public Scene() {
        this.freeglidlist = new ArrayList();
        this.reset();
        this.texturePath = "";
        this.blankTexture = new Texture(0);
        this.blankTexture.set(new int[]{-1}, 1, 1);
    }

    public void init(String vertex, String fragment) {
        GL.glFrontFace(2305);
        GL.glEnable(2884);
        GL.glEnable(2929);
        GL.glDepthFunc(515);
        GL.glEnable(3042);
        GL.glBlendFunc(770, 771);
        GL.glPixelStorei(3317, 1);
        GL.glEnable(3553);
        GL.glActiveTexture(33984);
        this.vertexShader = GL.glCreateShader(35633);
        GL.glShaderSource(this.vertexShader, 1, new String[]{vertex}, null);
        GL.glCompileShader(this.vertexShader);
        this.fragShader = GL.glCreateShader(35632);
        GL.glShaderSource(this.fragShader, 1, new String[]{fragment}, null);
        GL.glCompileShader(this.fragShader);
        this.program = GL.glCreateProgram();
        GL.glAttachShader(this.program, this.vertexShader);
        GL.glAttachShader(this.program, this.fragShader);
        GL.glLinkProgram(this.program);
        GL.glUseProgram(this.program);
        this.vpa = GL.glGetAttribLocation(this.program, "aVertexPosition");
        GL.glEnableVertexAttribArray(this.vpa);
        this.tca[0] = GL.glGetAttribLocation(this.program, "aTextureCoord1");
        GL.glEnableVertexAttribArray(this.tca[0]);
        int uSampler1 = GL.glGetUniformLocation(this.program, "uSampler1");
        GL.glUniform1i(uSampler1, 0);
        this.tca[1] = GL.glGetAttribLocation(this.program, "aTextureCoord2");
        GL.glEnableVertexAttribArray(this.tca[1]);
        int uSampler2 = GL.glGetUniformLocation(this.program, "uSampler2");
        GL.glUniform1i(uSampler2, 1);
        this.mpu = GL.glGetUniformLocation(this.program, "uPMatrix");
        this.mmu = GL.glGetUniformLocation(this.program, "uMMatrix");
        this.mvu = GL.glGetUniformLocation(this.program, "uVMatrix");
        this.uUVMaps = GL.glGetUniformLocation(this.program, "uUVMaps");
        this.initTextures();
        this.inited = true;
    }

    public void reset() {
        if (this.tl != null) {
            this.releaseTextures();
        }
        this.ml = new ArrayList();
        this.tl = new HashMap();
        this.mtl = new HashMap();
    }

    private void releaseTextures() {
        Set<String> keyset = this.tl.keySet();
        for (String texidx : keyset) {
            Texture tex = this.tl.get(texidx);
            if (tex.tid == -1) continue;
            this.releaseTexture(tex.tid);
            tex.tid = -1;
        }
    }

    private void releaseTexture(int glid) {
        this.freeglidlist.add(glid);
    }

    public boolean loadTextures() {
        boolean ret = true;
        int modCnt = this.ml.size();
        for (int a = 0; a < modCnt; ++a) {
            Model mod = this.ml.get(a);
            int objCnt = mod.ol.size();
            for (int b = 0; b < objCnt; ++b) {
                Object3 obj = mod.ol.get(b);
                int mapCnt = obj.maps.size();
                for (int m = 0; m < mapCnt; ++m) {
                    UVMap map = obj.maps.get(m);
                    if (map.texloaded) continue;
                    if (this.loadTexture(mod.getTexture(map.textureIndex), map.idx)) {
                        map.texloaded = true;
                        continue;
                    }
                    ret = false;
                }
            }
        }
        return ret;
    }

    private boolean loadTexture(String fn, int idx) {
        if (fn == null) {
            return false;
        }
        Texture tex = this.tl.get(fn);
        if (tex != null) {
            ++tex.refcnt;
            return true;
        }
        this.needinittex = true;
        tex = new Texture(idx);
        tex.name = fn;
        int extidx = fn.lastIndexOf(46);
        if (extidx == -1) {
            JFLog.log("Unsupported texture:" + fn);
            return false;
        }
        String ext = fn.substring(extidx);
        switch (ext.toLowerCase()) {
            case ".png": {
                if (tex.loadPNG(fn)) break;
                JFLog.log("Error:Failed to load texture:" + fn);
                return false;
            }
            case ".jpg": {
                if (tex.loadJPG(fn)) break;
                JFLog.log("Error:Failed to load texture:" + fn);
                return false;
            }
        }
        tex.refcnt = 1;
        this.tl.put(fn, tex);
        return true;
    }

    public boolean setTexture(String fn, int[] px, int w, int h, int idx) {
        Texture tex = this.tl.get(fn);
        if (tex == null) {
            tex = new Texture(idx);
            this.tl.put(fn, tex);
        } else {
            tex.loaded = false;
        }
        tex.set(px, w, h);
        this.needinittex = true;
        return false;
    }

    public boolean setTexture(String fn, Texture tex) {
        this.tl.put(fn, tex);
        this.needinittex = true;
        return false;
    }

    boolean initTextures() {
        if (!this.needinittex) {
            return true;
        }
        if (this.blankTexture.tid == -1) {
            this.initTexture(this.blankTexture);
        }
        if (this.freeglidlist.size() > 0) {
            this.uninitTextures();
        }
        Set<String> keyset = this.tl.keySet();
        for (String texidx : keyset) {
            if (this.initTexture(this.tl.get(texidx))) continue;
            return false;
        }
        this.needinittex = false;
        return true;
    }

    private boolean initTexture(Texture tex) {
        return tex.load();
    }

    private boolean uninitTextures() {
        while (this.freeglidlist.size() > 0) {
            this.uninitTexture(this.freeglidlist.get(0));
            this.freeglidlist.remove(0);
        }
        return true;
    }

    private boolean uninitTexture(int glid) {
        int[] id = new int[]{glid};
        GL.glDeleteTextures(1, id);
        return true;
    }

    public void releaseUnusedTextures() {
        Set<String> keyset = this.tl.keySet();
        for (String texidx : keyset) {
            if (this.tl.get((Object)texidx).refcnt != 0) continue;
            this.releaseTexture(this.tl.get((Object)texidx).tid);
        }
    }

    public void releaseModel(int idx) {
        Model mod = this.ml.get(idx);
        int size = mod.ol.size();
        for (int a = 0; a < size; ++a) {
            Object3 obj = mod.ol.get(a);
            for (int m = 0; m < obj.maps.size(); ++m) {
                UVMap map = obj.maps.get(m);
                --this.tl.get((Object)mod.getTexture((int)map.textureIndex)).refcnt;
            }
        }
        this.ml.remove(idx);
    }

    public int modelCount() {
        return this.ml.size();
    }

    public boolean addModel(Model mod) {
        return this.addModel(mod, 0);
    }

    public boolean addModel(Model mod, int idx) {
        if (mod == null) {
            return false;
        }
        this.ml.add(idx, mod);
        return true;
    }

    public int indexOfModel(Model mod) {
        return this.ml.indexOf(mod);
    }

    public void removeModel(int idx) {
        this.ml.remove(idx);
    }

    public void removeModel(Model mod) {
        this.ml.remove(mod);
    }

    public void nextFrame(int objidx) {
        this.ml.get(objidx).nextFrame();
    }

    public void setFrame(int objidx, int frame) {
        this.ml.get(objidx).setFrame(frame);
    }

    public void modelTranslate(int idx, float x, float y, float z) {
        this.ml.get(idx).translate(x, y, z);
    }

    public void modelRotate(int idx, float angle, float x, float y, float z) {
        this.ml.get(idx).rotate(angle, x, y, z);
    }

    public void modelScale(int idx, float x, float y, float z) {
        this.ml.get(idx).scale(x, y, z);
    }

    public Model load3DS(String fn) {
        Model mod = this.mtl.get(fn);
        if (mod != null) {
            ++mod.refcnt;
            return mod;
        }
        GL_3DS loader = new GL_3DS();
        mod = loader.load(fn);
        if (mod == null) {
            return null;
        }
        this.mtl.put(fn, mod);
        mod.refcnt = 1;
        mod = (Model)mod.clone();
        return mod;
    }

    public Model loadBlend(String fn) {
        Model mod = this.mtl.get(fn);
        if (mod != null) {
            ++mod.refcnt;
            return mod;
        }
        GL_BLEND loader = new GL_BLEND();
        mod = loader.load(fn);
        if (mod == null) {
            return null;
        }
        this.mtl.put(fn, mod);
        mod.refcnt = 1;
        mod = (Model)mod.clone();
        return mod;
    }

    public Model loadJF3D(String fn) {
        Model mod = this.mtl.get(fn);
        if (mod != null) {
            ++mod.refcnt;
            return mod;
        }
        GL_JF3D loader = new GL_JF3D();
        mod = loader.load(fn);
        if (mod == null) {
            return null;
        }
        this.mtl.put(fn, mod);
        mod.refcnt = 1;
        mod = (Model)mod.clone();
        return mod;
    }

    public Model cloneModel(String fn) {
        Model mod = this.mtl.get(fn);
        if (mod == null) {
            return null;
        }
        ++mod.refcnt;
        return (Model)mod.clone();
    }

    public void unloadModel(Model mod) {
        --mod.refcnt;
    }

    public void releaseModel() {
        Set<String> keyset = this.mtl.keySet();
        for (String idx : keyset) {
            Model mod = this.mtl.get(idx);
            if (mod.refcnt != 0) continue;
            this.mtl.remove(idx);
        }
    }
}

