/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javaforce.awt.JFAWT;
import javaforce.awt.JFImage;
import javaforce.awt.ViewLog;
import javaforce.jbus.JBusClient;
import javaforce.service.DNSServer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class DNSApp
extends JFrame {
    private JTextArea config;
    private JButton jButton1;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton save;
    public ViewLog viewer;
    public JBusClient busClient;

    public DNSApp() {
        this.initComponents();
        JFImage img = new JFImage();
        img.loadPNG(this.getClass().getResourceAsStream("/javaforce/icons/dns.png"));
        this.setIconImage(img.getImage());
        new Thread(){

            @Override
            public void run() {
                Random r = new Random();
                DNSApp.this.busClient = new JBusClient("net.sf.jfdns.client" + r.nextInt(), new JBusMethods());
                DNSApp.this.busClient.setPort(DNSServer.getBusPort());
                DNSApp.this.busClient.start();
                DNSApp.this.busClient.call("net.sf.jfdns", "getConfig", "\"" + DNSApp.this.busClient.pack + "\"");
            }
        }.start();
        JFAWT.centerWindow(this);
    }

    public void writeConfig() {
        this.busClient.call("net.sf.jfdns", "setConfig", JBusClient.quote(JBusClient.encodeString(this.config.getText())));
    }

    public void restart() {
        this.busClient.call("net.sf.jfdns", "restart", "");
    }

    private void initComponents() {
        this.save = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.config = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("DNS Server");
        this.save.setText("Save");
        this.save.setEnabled(false);
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DNSApp.this.saveActionPerformed(evt);
            }
        });
        this.config.setColumns(20);
        this.config.setRows(5);
        this.config.setText(" [ loading ... ]\n");
        this.config.setEnabled(false);
        this.jScrollPane1.setViewportView(this.config);
        this.jLabel1.setText("DNS Configuration:");
        this.jButton1.setText("View Log");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DNSApp.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 583, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.save)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 424, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.save).addComponent(this.jButton1)).addContainerGap()));
        this.pack();
    }

    private void saveActionPerformed(ActionEvent evt) {
        this.writeConfig();
        this.restart();
        JFAWT.showMessage("Notice", "Settings saved!");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.showViewLog();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DNSApp().setVisible(true);
            }
        });
    }

    public void showViewLog() {
        if (this.viewer == null || this.viewer.isClosed) {
            this.viewer = new ViewLog(DNSServer.getLogFile());
            this.viewer.setTitle("DNS Log");
        }
        this.viewer.setVisible(true);
        this.viewer.setExtendedState(0);
    }

    public class JBusMethods {
        public void getConfig(String cfg) {
            final String _cfg = cfg;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DNSApp.this.config.setText(JBusClient.decodeString(_cfg));
                    DNSApp.this.config.setEnabled(true);
                    DNSApp.this.save.setEnabled(true);
                }
            });
        }
    }
}

