/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.ShellProcess;
import javaforce.ShellProcessListener;
import javaforce.utils.BuildTools;

public class ExecGraalAgent
implements ShellProcessListener {
    private BuildTools tools;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("ExecGraalAgent : Runs project using Graal agentlib");
            System.out.println("  Usage : ExecGraalAgent buildfile");
            System.exit(1);
        }
        try {
            new ExecGraalAgent().run(args[0]);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void run(String buildfile) throws Exception {
        this.tools = new BuildTools();
        if (!this.tools.loadXML(buildfile)) {
            throw new Exception("error loading " + buildfile);
        }
        String app = this.tools.getProperty("app");
        Object cfg = this.tools.getProperty("cfg");
        if (((String)cfg).length() == 0) {
            cfg = app + ".cfg";
        }
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream((String)cfg);
        props.load(fis);
        fis.close();
        String classpath = props.getProperty("CLASSPATH");
        String mainclass = props.getProperty("MAINCLASS");
        new File("META-INF/native-image").mkdirs();
        ShellProcess sp = new ShellProcess();
        sp.addListener(this);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("java");
        cmd.add("-agentlib:native-image-agent=config-output-dir=META-INF/native-image");
        cmd.add("-cp");
        if (JF.isWindows()) {
            cmd.add(classpath);
        } else {
            cmd.add(classpath.replaceAll("[;]", ":"));
        }
        cmd.add(mainclass);
        sp.run(cmd.toArray(new String[0]), true);
    }

    @Override
    public void shellProcessOutput(String str) {
        System.out.print(str);
    }
}

