/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.net.InetAddress;
import java.util.HashMap;
import javaforce.HTTP;
import javaforce.JFLog;
import javaforce.STUN;
import javaforce.voip.RTP;
import javaforce.voip.RTSP;
import javaforce.voip.RTSPInterface;
import javaforce.voip.RTSPServerInterface;
import javaforce.voip.RTSPSession;
import javaforce.voip.TransportType;

public class RTSPServer
extends RTSP
implements RTSPInterface,
STUN.Listener {
    private RTSPServerInterface iface;
    private String localhost;
    private int localport;
    private static NAT nat = NAT.None;
    private static boolean useNATOnPrivateNetwork = false;
    private static String stunHost;
    private static String stunUser;
    private static String stunPass;
    private boolean use_qop = false;
    private static final String realm = "javaforce";
    public Object userobj;
    public int expires;
    private Object clientsLock = new Object();
    private HashMap<String, RTSPSession> clients = new HashMap();
    private STUN stun;
    private final Object stunLock = new Object();
    private volatile boolean stunWaiting = false;
    private volatile boolean stunResponse = false;

    public boolean init(int localport, RTSPServerInterface iface, TransportType type) {
        this.iface = iface;
        if (localport == -1) {
            localport = 554;
        }
        this.localport = localport;
        try {
            JFLog.log(this.log, "localhost = " + this.localhost);
            if (nat == NAT.STUN || nat == NAT.ICE) {
                this.stopSTUN();
            }
            return super.init(this.localhost, localport, this, true, type);
        }
        catch (Exception e) {
            if (this.stun != null) {
                this.stopSTUN();
            }
            JFLog.log(this.log, (Throwable)e);
            return false;
        }
    }

    @Override
    public void uninit() {
        super.uninit();
    }

    public static void setNAT(NAT nat, String host, String user, String pass) {
        RTSPServer.nat = nat;
        stunHost = host;
        stunUser = user;
        stunPass = pass;
    }

    public static void useNATOnPrivateNetwork(boolean state) {
        useNATOnPrivateNetwork = state;
    }

    public static boolean isPrivateNetwork(String ip) {
        if (ip.startsWith("192.168.")) {
            return true;
        }
        if (ip.startsWith("10.")) {
            return true;
        }
        if (ip.startsWith("169.254.")) {
            return true;
        }
        for (int a = 16; a <= 31; ++a) {
            if (!ip.startsWith("172." + a + ".")) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getlocalRTPhost(RTSPSession sess) {
        if (RTP.useTURN) {
            return RTP.getTurnIP();
        }
        return sess.localhost;
    }

    private boolean startSTUN() {
        this.stun = new STUN();
        return this.stun.start(this.localport, stunHost, stunUser, stunPass, this);
    }

    private void stopSTUN() {
        if (this.stun == null) {
            return;
        }
        this.stun.close();
        this.stun = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stunPublicIP(STUN stun, String ip, int port) {
        Object object = this.stunLock;
        synchronized (object) {
            if (this.stunWaiting) {
                this.stunResponse = true;
                this.stunLock.notify();
            }
        }
    }

    @Override
    public void turnAlloc(STUN stun, String ip, int port, byte[] token, int lifetime) {
    }

    @Override
    public void turnBind(STUN stun) {
    }

    @Override
    public void turnRefresh(STUN stun, int lifetime) {
    }

    @Override
    public void turnFailed(STUN stun) {
    }

    @Override
    public void turnData(STUN stun, byte[] data, int offset, int length, short channel) {
    }

    public boolean reply(RTSPSession sess, int code, String msg, String header) {
        JFLog.log(this.log, "issue reply : " + code + ":" + String.valueOf(sess));
        sess.reply = code;
        StringBuilder req = new StringBuilder();
        req.append("RTSP/1.0 " + code + " " + msg + "\r\n");
        req.append("Cseq: " + sess.cseq + "\r\n");
        req.append("User-Agent: " + useragent + "\r\n");
        if (sess.epass != null) {
            req.append(sess.epass);
        }
        if (sess.transport != null) {
            req.append(sess.transport);
        }
        if (sess.accept != null) {
            req.append("Accept: " + sess.accept + "\r\n");
        }
        if (header != null) {
            req.append(header);
        }
        if (sess.sdp != null) {
            String post = String.join((CharSequence)"\r\n", sess.sdp) + "\r\n";
            req.append("Content-Type: application/sdp\r\n");
            req.append("Content-Length: " + post.length() + "\r\n\r\n");
            req.append(post);
        } else if (sess.params != null) {
            String post = String.join((CharSequence)"\r\n", sess.params) + "\r\n";
            req.append("Content-Type: text/plain\r\n");
            req.append("Content-Length: " + post.length() + "\r\n\r\n");
            req.append(post);
        } else {
            req.append("Content-Length: 0\r\n\r\n");
        }
        return this.send(sess.remoteaddr, sess.remoteport, req.toString());
    }

    public boolean reply(RTSPSession sess, int reply, String msg) {
        return this.reply(sess, reply, msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RTSPSession getSession(String host, int port, String id) {
        RTSPSession sess;
        Object object = this.clientsLock;
        synchronized (object) {
            sess = this.clients.get(id);
            if (sess == null) {
                sess = new RTSPSession(this.localhost);
                sess.remotehost = host;
                sess.remoteport = port;
                this.clients.put(id, sess);
            }
        }
        return sess;
    }

    @Override
    public void onPacket(RTSP rtsp, String[] msg, String remoteip, int remoteport) {
        String id = remoteip + ":" + remoteport;
        try {
            RTSPSession sess = this.getSession(remoteip, remoteport, id);
            String cmd = null;
            if (remoteip.equals("127.0.0.1") && sess.localhost != null) {
                remoteip = sess.localhost;
            }
            sess.remotehost = remoteip;
            sess.remoteaddr = InetAddress.getByName(remoteip);
            sess.remoteport = remoteport;
            sess.remotecseq = this.getcseq(msg);
            String sid = RTSPServer.getHeader("Session:", msg);
            if (sid != null) {
                int idx = sid.indexOf(59);
                if (idx != -1) {
                    sid = sid.substring(0, idx);
                }
                sess.id = Long.valueOf(sid);
            }
            sess.headers = msg;
            int reply = this.getResponseType(msg);
            if (reply != -1) {
                JFLog.log(this.log, "nreply=" + reply + ":" + String.valueOf(sess));
            } else {
                cmd = this.getRequest(msg);
                sess.uri = this.getURI(msg);
                JFLog.log(this.log, "request=" + cmd + ":" + String.valueOf(sess));
            }
            block1 : switch (reply) {
                case -1: {
                    sess.cmd = cmd;
                    switch (cmd) {
                        case "OPTIONS": {
                            String auth = RTSPServer.getHeader("Authorization:", msg);
                            if (auth == null) {
                                sess.nonce = this.getnonce();
                                String challenge = "WWW-Authenticate: Digest algorithm=MD5, realm=\"javaforce\", nonce=\"" + sess.nonce + "\"";
                                if (this.use_qop) {
                                    challenge = challenge + ", qop=\"auth\"";
                                }
                                challenge = challenge + "\r\n";
                                this.reply(sess, 401, "REQ AUTH", challenge);
                                break block1;
                            }
                            if (!auth.regionMatches(true, 0, "digest ", 0, 7)) {
                                JFLog.log("invalid Authorization");
                                break block1;
                            }
                            String[] tags = auth.substring(7).replaceAll(" ", "").replaceAll("\"", "").split(",");
                            String res = RTSPServer.getHeader("response=", tags);
                            String nonce = RTSPServer.getHeader("nonce=", tags);
                            sess.user = RTSPServer.getHeader("username=", tags);
                            JFLog.log("user=" + sess.user);
                            if (nonce == null || sess.nonce == null || !sess.nonce.equals(nonce) || sess.user == null) {
                                sess.nonce = this.getnonce();
                                String challenge = "WWW-Authenticate: Digest algorithm=MD5, realm=\"javaforce\", nonce=\"" + sess.nonce + "\"";
                                if (this.use_qop) {
                                    challenge = challenge + ", qop=\"auth\"";
                                }
                                challenge = challenge + "\r\n";
                                this.reply(sess, 401, "REQ AUTH", challenge);
                                break block1;
                            }
                            String test = this.getResponse(sess.user, this.iface.getPassword(sess.user), realm, sess.cmd, RTSPServer.getHeader("uri=", tags), sess.nonce, RTSPServer.getHeader("qop=", tags), RTSPServer.getHeader("nc=", tags), RTSPServer.getHeader("cnonce=", tags));
                            sess.nonce = null;
                            if (!res.equalsIgnoreCase(test)) {
                                this.reply(sess, 403, "BAD PASSWORD", null);
                                break block1;
                            }
                            sess.auth = true;
                            this.iface.onOptions(this, sess);
                            break block1;
                        }
                        case "DESCRIBE": {
                            if (!sess.auth) {
                                JFLog.log("!auth");
                                break block1;
                            }
                            this.iface.onDescribe(this, sess);
                            break block1;
                        }
                        case "SETUP": {
                            if (!sess.auth) {
                                JFLog.log("!auth");
                                break block1;
                            }
                            String transport = RTSPServer.getHeader("Transport:", msg);
                            String[] tags = transport.split(";");
                            String client_port = RTSPServer.getHeader("client_port=", tags);
                            String[] ports = client_port.split("[-]");
                            sess.channel.stream.port = Integer.valueOf(ports[0]);
                            this.iface.onSetup(this, sess);
                            break block1;
                        }
                        case "PLAY": {
                            if (!sess.auth) {
                                JFLog.log("!auth");
                                break block1;
                            }
                            this.iface.onPlay(this, sess);
                            break block1;
                        }
                        case "TEARDOWN": {
                            if (!sess.auth) {
                                JFLog.log("!auth");
                                break block1;
                            }
                            this.iface.onTeardown(this, sess);
                            break block1;
                        }
                        case "GET_PARAMETER": {
                            this.iface.onGetParameter(this, sess, HTTP.getContent(msg));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            JFLog.log(this.log, (Throwable)e);
        }
    }

    @Override
    public void onConnect(RTSP rtsp, String remoteip, int remoteport) {
        String id = remoteip + ":" + remoteport;
        this.iface.onConnect(this, this.getSession(remoteip, remoteport, id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDisconnect(RTSP rtsp, String remoteip, int remoteport) {
        String id = remoteip + ":" + remoteport;
        this.iface.onDisconnect(this, this.getSession(remoteip, remoteport, id));
        Object object = this.clientsLock;
        synchronized (object) {
            this.clients.remove(id);
        }
    }

    public static enum NAT {
        None,
        STUN,
        TURN,
        ICE;

    }
}

