/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.Block;
import javaforce.webui.Component;
import javaforce.webui.Label;
import javaforce.webui.ScrollPanel;
import javaforce.webui.TreeModel;
import javaforce.webui.TreeNode;
import javaforce.webui.event.Click;
import javaforce.webui.event.MouseEvent;
import javaforce.webui.event.TreeEventClick;

public class Tree
extends ScrollPanel
implements Click {
    private TreeModel model;
    private TreeEventClick handler;

    public Tree() {
        this.removeClass("column");
        this.addClass("tree");
        this.model = new TreeModel(new TreeNode());
    }

    public Tree(TreeModel model) {
        this.removeClass("column");
        this.addClass("tree");
        this.model = model;
    }

    @Override
    public String html() {
        if (this.model.changed) {
            this.model.changed = false;
            this.rebuild();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<div" + this.getAttrs() + "'>");
        sb.append(this.innerhtml());
        sb.append("</div>");
        return sb.toString();
    }

    public String innerhtml() {
        StringBuilder sb = new StringBuilder();
        int cnt = this.count();
        for (int a = 0; a < cnt; ++a) {
            sb.append(this.get(a).html());
        }
        return sb.toString();
    }

    public void setRootNode(TreeNode newRoot) {
        this.model.setRoot(newRoot);
        this.rebuild();
        this.sendEvent("sethtml", new String[]{"html=" + this.innerhtml()});
    }

    public TreeNode getRootNode() {
        return this.model.getRoot();
    }

    private void buildNode(TreeNode node, int offset) {
        Block row = new Block();
        row.setClass("treerow");
        this.add(row);
        row.setProperty("node", node);
        row.addClickListener(this);
        for (int a = 0; a < offset; ++a) {
            Block b = new Block();
            b.setClass("treeindex");
            row.add(b);
        }
        if (node.hasChildren() && !node.leaf) {
            b = new Block();
            if (node.opened) {
                b.setClass("treeopened");
                row.add(b);
            } else {
                b.setClass("treeclosed");
                row.add(b);
            }
            b.addEvent("onclick", "onClick(event," + row.id + ");");
            b.addClickListener(this);
            row.setProperty("open_close", b);
        } else {
            b = new Block();
            b.setClass("treeleaf");
            row.add(b);
        }
        Label l = new Label(node.toString());
        l.setClass("treelabel");
        l.addEvent("onclick", "onClick(event," + row.id + ");");
        l.addClickListener(this);
        row.add(l);
        int cnt = node.getChildCount();
        ++offset;
        for (int a = 0; a < cnt; ++a) {
            this.buildNode(node.getChildAt(a), offset);
        }
    }

    private void rebuild() {
        this.removeAll();
        this.buildNode(this.model.getRoot(), 0);
    }

    public void addEventHandler(TreeEventClick handler) {
        this.handler = handler;
    }

    private Block getRow(TreeNode node) {
        int cnt = this.count();
        for (int a = 0; a < cnt; ++a) {
            Block row = (Block)this.get(a);
            if (row.getProperty("node") != node) continue;
            return row;
        }
        return null;
    }

    private void setNodeVisible(TreeNode node, boolean state) {
        Block row = this.getRow(node);
        row.setVisible(state);
        int cnt = node.getChildCount();
        for (int a = 0; a < cnt; ++a) {
            this.setNodeVisible(node.getChildAt(a), state);
        }
    }

    private void setNodeChildrenVisible(TreeNode node, boolean state) {
        int cnt = node.getChildCount();
        for (int a = 0; a < cnt; ++a) {
            this.setNodeVisible(node.getChildAt(a), state);
        }
        Block row = this.getRow(node);
        Block oc = (Block)row.getProperty("open_close");
        oc.setClass(state ? "treeopened" : "treeclosed");
    }

    @Override
    public void onClick(MouseEvent e, Component c) {
        TreeNode node = (TreeNode)c.getProperty("node");
        if (node == null) {
            return;
        }
        if (!node.hasChildren() || node.leaf) {
            if (this.handler != null) {
                this.handler.nodeClick(node);
            }
        } else {
            node.opened = !node.opened;
            this.setNodeChildrenVisible(node, node.opened);
        }
    }
}

