/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Random;
import java.util.zip.CRC32;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.MD5;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class STUN {
    private DatagramSocket ds;
    private InetAddress addr;
    private int StunPort = 3478;
    private static final short BINDING_REQUEST = 1;
    private static final short ALLOCATE_REQUEST = 3;
    private static final short REFRESH_REQUEST = 4;
    private static final short BIND_REQUEST = 9;
    private static final short BINDING_RESPONSE = 257;
    private static final short ALLOCATE_RESPONSE = 259;
    private static final short REFRESH_RESPONSE = 260;
    private static final short BIND_RESPONSE = 265;
    private static final short MAPPED_ADDRESS = 1;
    private static final short CHANGE_REQUEST = 3;
    private static final short USERNAME = 6;
    private static final short MESSAGE_INTEGRITY = 8;
    private static final short ERROR_CODE = 9;
    private static final short CHANNEL_NUMBER = 12;
    private static final short LIFETIME = 13;
    private static final short XOR_PEER_ADDRESS = 18;
    private static final short REALM = 20;
    private static final short NONCE = 21;
    private static final short XOR_RELAY_ADDRESS = 22;
    private static final short DATA_INDICATION = 23;
    private static final short EVEN_PORT = 24;
    private static final short TRANSPORT_TYPE = 25;
    private static final short XOR_MAPPED_ADDRESS = 32;
    private static final short RESERVATION_TOKEN = 34;
    private long id1;
    private long id2;
    private Listener listener;
    private boolean active = true;
    private String user;
    private String pass;
    private boolean sentAuth = false;
    private String realm;
    private String nonce;
    private boolean evenPort;
    private byte[] token;
    private byte[] fulldata;
    private ByteBuffer fulldatabb;
    private int relayPort = -1;
    private String relayIP = null;
    private int lifetime = -1;
    private short lastRequest = (short)-1;

    public boolean start(int localport, String host, String user, String pass, Listener listener) {
        this.listener = listener;
        this.user = user;
        this.pass = pass;
        try {
            int idx = host.indexOf(":");
            if (idx != -1) {
                this.StunPort = JF.atoi(host.substring(idx + 1));
                host = host.substring(0, idx);
            }
            this.addr = InetAddress.getByName(host);
            this.ds = localport == -1 ? new DatagramSocket() : new DatagramSocket(localport);
            new Worker(this).start();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public int getLocalPort() {
        return this.ds.getLocalPort();
    }

    public String getLocalAddr() {
        return this.ds.getLocalAddress().getHostAddress();
    }

    public void close() {
        this.active = false;
        if (this.ds == null) {
            return;
        }
        try {
            this.ds.close();
            this.ds = null;
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private void genID() {
        Random r = new Random();
        this.id1 = 554869826L;
        this.id1 <<= 32;
        this.id1 += (long)Math.abs(r.nextInt());
        this.id2 = r.nextLong();
    }

    public void requestPublicIP() {
        this.requestPublicIP(false, false);
    }

    public void requestPublicIP(boolean change_ip, boolean change_port) {
        try {
            this.lastRequest = 1;
            int packetSize = 28;
            byte[] request = new byte[packetSize];
            DatagramPacket dp = new DatagramPacket(request, packetSize);
            ByteBuffer bb = ByteBuffer.wrap(request);
            bb.order(ByteOrder.BIG_ENDIAN);
            int offset = 0;
            bb.putShort(offset, (short)1);
            bb.putShort(offset += 2, (short)8);
            this.genID();
            bb.putLong(offset += 2, this.id1);
            bb.putLong(offset += 8, this.id2);
            bb.putShort(offset += 8, (short)3);
            bb.putShort(offset += 2, (short)4);
            bb.putInt(offset += 2, (change_ip ? 4 : 0) + (change_port ? 2 : 0));
            offset += 4;
            dp.setAddress(this.addr);
            dp.setPort(this.StunPort);
            this.ds.send(dp);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void requestAlloc(boolean evenPort, byte[] token) {
        this.evenPort = evenPort;
        this.token = token;
        try {
            int strlen;
            this.lastRequest = (short)3;
            byte[] request = new byte[1024];
            ByteBuffer bb = ByteBuffer.wrap(request);
            bb.order(ByteOrder.BIG_ENDIAN);
            int offset = 0;
            bb.putShort(offset, (short)3);
            int lengthOffset = offset += 2;
            bb.putShort(offset, (short)0);
            this.genID();
            bb.putLong(offset += 2, this.id1);
            bb.putLong(offset += 8, this.id2);
            offset += 8;
            if (evenPort) {
                bb.putShort(offset, (short)24);
                bb.putShort(offset += 2, (short)1);
                bb.put(offset += 2, (byte)-128);
                ++offset;
                offset += 3;
            }
            bb.putShort(offset, (short)25);
            bb.putShort(offset += 2, (short)4);
            bb.put(offset += 2, (byte)17);
            ++offset;
            offset += 3;
            if (this.realm != null && this.nonce != null) {
                strlen = this.user.length();
                bb.putShort(offset, (short)6);
                bb.putShort(offset += 2, (short)strlen);
                System.arraycopy(this.user.getBytes(), 0, request, offset += 2, strlen);
                if (((offset += strlen) & 3) > 0) {
                    offset += 4 - (offset & 3);
                }
            }
            if (this.realm != null) {
                strlen = this.realm.length();
                bb.putShort(offset, (short)20);
                bb.putShort(offset += 2, (short)strlen);
                System.arraycopy(this.realm.getBytes(), 0, request, offset += 2, strlen);
                if (((offset += strlen) & 3) > 0) {
                    offset += 4 - (offset & 3);
                }
            }
            if (this.nonce != null) {
                strlen = this.nonce.length();
                bb.putShort(offset, (short)21);
                bb.putShort(offset += 2, (short)strlen);
                System.arraycopy(this.nonce.getBytes(), 0, request, offset += 2, strlen);
                if (((offset += strlen) & 3) > 0) {
                    offset += 4 - (offset & 3);
                }
            }
            if (token != null) {
                strlen = token.length;
                bb.putShort(offset, (short)34);
                bb.putShort(offset += 2, (short)strlen);
                System.arraycopy(token, 0, request, offset += 2, strlen);
                if (((offset += strlen) & 3) > 0) {
                    offset += 4 - (offset & 3);
                }
            }
            if (this.realm != null && this.nonce != null) {
                bb.putShort(lengthOffset, (short)(offset - 20 + 24));
                byte[] id = STUN.calcMsgIntegrity(request, offset, STUN.calcKey(this.user, this.realm, this.pass));
                int strlen2 = id.length;
                bb.putShort(offset, (short)8);
                bb.putShort(offset += 2, (short)strlen2);
                System.arraycopy(id, 0, request, offset += 2, strlen2);
                if (((offset += strlen2) & 3) > 0) {
                    offset += 4 - (offset & 3);
                }
            }
            bb.putShort(lengthOffset, (short)(offset - 20));
            DatagramPacket dp = new DatagramPacket(request, offset);
            dp.setAddress(this.addr);
            dp.setPort(this.StunPort);
            this.ds.send(dp);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void requestBind(short channel, String host, int port) {
        try {
            int strlen;
            this.lastRequest = (short)9;
            byte[] hostaddr = InetAddress.getByName(host).getAddress();
            byte[] request = new byte[1024];
            ByteBuffer bb = ByteBuffer.wrap(request);
            bb.order(ByteOrder.BIG_ENDIAN);
            int offset = 0;
            bb.putShort(offset, (short)9);
            int lengthOffset = offset += 2;
            bb.putShort(offset, (short)0);
            this.genID();
            bb.putLong(offset += 2, this.id1);
            bb.putLong(offset += 8, this.id2);
            offset += 8;
            if (this.realm != null && this.nonce != null) {
                strlen = this.user.length();
                bb.putShort(offset, (short)6);
                bb.putShort(offset += 2, (short)strlen);
                System.arraycopy(this.user.getBytes(), 0, request, offset += 2, strlen);
                if (((offset += strlen) & 3) > 0) {
                    offset += 4 - (offset & 3);
                }
            }
            if (this.realm != null) {
                strlen = this.realm.length();
                bb.putShort(offset, (short)20);
                bb.putShort(offset += 2, (short)strlen);
                System.arraycopy(this.realm.getBytes(), 0, request, offset += 2, strlen);
                if (((offset += strlen) & 3) > 0) {
                    offset += 4 - (offset & 3);
                }
            }
            if (this.nonce != null) {
                strlen = this.nonce.length();
                bb.putShort(offset, (short)21);
                bb.putShort(offset += 2, (short)strlen);
                System.arraycopy(this.nonce.getBytes(), 0, request, offset += 2, strlen);
                if (((offset += strlen) & 3) > 0) {
                    offset += 4 - (offset & 3);
                }
            }
            bb.putShort(offset, (short)12);
            bb.putShort(offset += 2, (short)4);
            bb.putShort(offset += 2, channel);
            offset += 2;
            bb.putShort(offset += 2, (short)18);
            bb.putShort(offset += 2, (short)8);
            offset += 2;
            bb.put(++offset, (byte)1);
            bb.putShort(++offset, (short)(port ^ bb.getShort(4)));
            offset += 2;
            for (int a = 0; a < 4; ++a) {
                request[offset++] = (byte)(hostaddr[a] ^ request[4 + a]);
            }
            if (this.realm != null && this.nonce != null) {
                bb.putShort(lengthOffset, (short)(offset - 20 + 24));
                byte[] id = STUN.calcMsgIntegrity(request, offset, STUN.calcKey(this.user, this.realm, this.pass));
                int strlen2 = id.length;
                bb.putShort(offset, (short)8);
                bb.putShort(offset += 2, (short)strlen2);
                System.arraycopy(id, 0, request, offset += 2, strlen2);
                if (((offset += strlen2) & 3) > 0) {
                    offset += 4 - (offset & 3);
                }
            }
            bb.putShort(lengthOffset, (short)(offset - 20));
            DatagramPacket dp = new DatagramPacket(request, offset);
            dp.setAddress(this.addr);
            dp.setPort(this.StunPort);
            this.ds.send(dp);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void requestRefresh(int seconds) {
        try {
            int strlen;
            this.lastRequest = (short)4;
            byte[] request = new byte[1024];
            ByteBuffer bb = ByteBuffer.wrap(request);
            bb.order(ByteOrder.BIG_ENDIAN);
            int offset = 0;
            bb.putShort(offset, (short)4);
            int lengthOffset = offset += 2;
            bb.putShort(offset, (short)0);
            this.genID();
            bb.putLong(offset += 2, this.id1);
            bb.putLong(offset += 8, this.id2);
            offset += 8;
            if (this.realm != null && this.nonce != null) {
                strlen = this.user.length();
                bb.putShort(offset, (short)6);
                bb.putShort(offset += 2, (short)strlen);
                System.arraycopy(this.user.getBytes(), 0, request, offset += 2, strlen);
                if (((offset += strlen) & 3) > 0) {
                    offset += 4 - (offset & 3);
                }
            }
            if (this.realm != null) {
                strlen = this.realm.length();
                bb.putShort(offset, (short)20);
                bb.putShort(offset += 2, (short)strlen);
                System.arraycopy(this.realm.getBytes(), 0, request, offset += 2, strlen);
                if (((offset += strlen) & 3) > 0) {
                    offset += 4 - (offset & 3);
                }
            }
            if (this.nonce != null) {
                strlen = this.nonce.length();
                bb.putShort(offset, (short)21);
                bb.putShort(offset += 2, (short)strlen);
                System.arraycopy(this.nonce.getBytes(), 0, request, offset += 2, strlen);
                if (((offset += strlen) & 3) > 0) {
                    offset += 4 - (offset & 3);
                }
            }
            bb.putShort(offset, (short)13);
            bb.putShort(offset += 2, (short)4);
            bb.putInt(offset += 2, seconds);
            offset += 4;
            if (this.realm != null && this.nonce != null) {
                bb.putShort(lengthOffset, (short)(offset - 20 + 24));
                byte[] id = STUN.calcMsgIntegrity(request, offset, STUN.calcKey(this.user, this.realm, this.pass));
                int strlen2 = id.length;
                bb.putShort(offset, (short)8);
                bb.putShort(offset += 2, (short)strlen2);
                System.arraycopy(id, 0, request, offset += 2, strlen2);
                if (((offset += strlen2) & 3) > 0) {
                    offset += 4 - (offset & 3);
                }
            }
            bb.putShort(lengthOffset, (short)(offset - 20));
            DatagramPacket dp = new DatagramPacket(request, offset);
            dp.setAddress(this.addr);
            dp.setPort(this.StunPort);
            this.ds.send(dp);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public String getIP() {
        return this.relayIP;
    }

    public int getPort() {
        return this.relayPort;
    }

    public void sendData(short channel, byte[] data, int offset, int length) {
        if (this.fulldata == null || this.fulldata.length != length + 4) {
            this.fulldata = new byte[length + 4];
            this.fulldatabb = ByteBuffer.wrap(this.fulldata);
            this.fulldatabb.order(ByteOrder.BIG_ENDIAN);
        }
        this.fulldatabb.putShort(0, channel);
        this.fulldatabb.putShort(2, (short)length);
        System.arraycopy(data, offset, this.fulldata, 4, length);
        DatagramPacket dp = new DatagramPacket(this.fulldata, length + 4);
        try {
            dp.setAddress(this.addr);
            dp.setPort(this.StunPort);
            this.ds.send(dp);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static byte[] calcKey(String pass) {
        return pass.getBytes();
    }

    public static byte[] calcKey(String user, String realm, String pass) {
        String msg = user + ":" + realm + ":" + pass;
        MD5 md5 = new MD5();
        md5.init();
        md5.add(msg.getBytes(), 0, msg.length());
        return md5.done();
    }

    public static byte[] calcMsgIntegrity(byte[] data, int length, byte[] key) {
        try {
            SecretKeySpec ks = new SecretKeySpec(key, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(ks);
            return mac.doFinal(Arrays.copyOfRange(data, 0, length));
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static int calcFingerprint(byte[] data, int length) {
        CRC32 crc = new CRC32();
        crc.update(data, 0, length);
        return (int)crc.getValue() ^ 0x5354554E;
    }

    public static NAT doTest(int port, String host1, String host2) {
        return new Test().run(port, host1, host2);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Desc: Determine your Firewall NAT type.");
            System.out.println("Usage: javaforce.STUN port server1 [server2]");
            System.out.println("Two servers are recommended to detect Symmetric router.");
        } else {
            int port = Integer.valueOf(args[0]);
            String s1 = args[1];
            String s2 = args.length > 2 ? args[2] : null;
            System.out.println("Result=" + new Test().run(port, s1, s2));
        }
    }

    public static interface Listener {
        public void stunPublicIP(STUN var1, String var2, int var3);

        public void turnAlloc(STUN var1, String var2, int var3, byte[] var4, int var5);

        public void turnBind(STUN var1);

        public void turnRefresh(STUN var1, int var2);

        public void turnFailed(STUN var1);

        public void turnData(STUN var1, byte[] var2, int var3, int var4, short var5);
    }

    private static class Worker
    extends Thread {
        private STUN stun;

        public Worker(STUN stun) {
            this.stun = stun;
        }

        @Override
        public void run() {
            byte[] response = new byte[1500];
            ByteBuffer bb = ByteBuffer.wrap(response);
            bb.order(ByteOrder.BIG_ENDIAN);
            while (this.stun.active) {
                try {
                    boolean resendAuth = false;
                    DatagramPacket dp = new DatagramPacket(response, 1500);
                    this.stun.ds.receive(dp);
                    int packetLength = dp.getLength();
                    int offset = 0;
                    short code = bb.getShort(0);
                    if (code >= 16384) {
                        this.stun.listener.turnData(this.stun, response, 4, bb.getShort(2), code);
                        continue;
                    }
                    if (code == 265) {
                        this.stun.listener.turnBind(this.stun);
                    }
                    if (code == 23) continue;
                    short length = bb.getShort(offset += 2);
                    if (length + 20 != packetLength) {
                        throw new Exception("STUN:bad packet:incorrect length");
                    }
                    long _id1 = bb.getLong(offset += 2);
                    long _id2 = bb.getLong(offset += 8);
                    offset += 8;
                    if (this.stun.id1 != _id1 || this.stun.id2 != _id2) {
                        throw new Exception("STUN:bad packet:id mismatch");
                    }
                    while (offset < packetLength) {
                        short attr = bb.getShort(offset);
                        length = bb.getShort(offset += 2);
                        offset += 2;
                        block1 : switch (attr) {
                            case 1: {
                                int port = bb.getShort(offset + 2) & 0xFFFF;
                                int[] ip = new int[4];
                                for (int a = 0; a < 4; ++a) {
                                    ip[a] = response[offset + 4 + a] & 0xFF;
                                }
                                if (code != 257) break;
                                this.stun.listener.stunPublicIP(this.stun, String.format("%d.%d.%d.%d", ip[0], ip[1], ip[2], ip[3]), port);
                                break;
                            }
                            case 32: {
                                int port = (bb.getShort(offset + 2) ^ bb.getShort(4)) & 0xFFFF;
                                int[] ip = new int[4];
                                for (int a = 0; a < 4; ++a) {
                                    ip[a] = (response[offset + 4 + a] ^ response[4 + a]) & 0xFF;
                                }
                                if (code != 257) break;
                                this.stun.listener.stunPublicIP(this.stun, String.format("%d.%d.%d.%d", ip[0], ip[1], ip[2], ip[3]), port);
                                break;
                            }
                            case 20: {
                                this.stun.realm = new String(response, offset, (int)length);
                                JFLog.log("STUN:realm=" + this.stun.realm);
                                break;
                            }
                            case 21: {
                                this.stun.nonce = new String(response, offset, (int)length);
                                JFLog.log("STUN:nonce=" + this.stun.nonce);
                                break;
                            }
                            case 9: {
                                short errcode = bb.getShort(offset + 2);
                                switch (errcode) {
                                    case 1025: {
                                        if (this.stun.sentAuth) {
                                            this.stun.listener.turnFailed(this.stun);
                                            JFLog.log("STUN:Error:" + Integer.toString(errcode, 16) + " (Bad Auth)");
                                            break block1;
                                        }
                                        resendAuth = true;
                                        break block1;
                                    }
                                }
                                JFLog.log("STUN:Error:" + Integer.toString(errcode, 16));
                                break;
                            }
                            case 22: {
                                this.stun.relayPort = (bb.getShort(offset + 2) ^ bb.getShort(4)) & 0xFFFF;
                                int[] ip = new int[4];
                                for (int a = 0; a < 4; ++a) {
                                    ip[a] = (response[offset + 4 + a] ^ response[4 + a]) & 0xFF;
                                }
                                this.stun.relayIP = String.format("%d.%d.%d.%d", ip[0], ip[1], ip[2], ip[3]);
                                if (!this.stun.relayIP.equals("0.0.0.0")) break;
                                byte[] ip4 = this.stun.addr.getAddress();
                                this.stun.relayIP = String.format("%d.%d.%d.%d", ip4[0], ip4[1], ip4[2], ip4[3]);
                                break;
                            }
                            case 34: {
                                this.stun.token = new byte[length];
                                System.arraycopy(response, offset, this.stun.token, 0, length);
                                break;
                            }
                            case 13: {
                                this.stun.lifetime = bb.getInt(offset);
                            }
                        }
                        offset += length;
                        if ((length & 3) <= 0) continue;
                        offset += 4 - (length & 3);
                    }
                    if (resendAuth && this.stun.lastRequest == 3) {
                        this.stun.sentAuth = true;
                        this.stun.requestAlloc(this.stun.evenPort, this.stun.token);
                    }
                    if (code == 259) {
                        this.stun.listener.turnAlloc(this.stun, this.stun.relayIP, this.stun.relayPort, this.stun.token, this.stun.lifetime);
                        this.stun.token = null;
                    }
                    if (code != 260) continue;
                    this.stun.listener.turnRefresh(this.stun, this.stun.lifetime);
                }
                catch (Exception e) {
                    if (!this.stun.active) continue;
                    JFLog.log(e);
                }
            }
        }
    }

    public static class Test
    implements Listener {
        private volatile String ip;
        private volatile int port;
        private volatile boolean ok;

        public NAT run(int localport, String host1, String host2) {
            boolean t1b;
            boolean t3;
            boolean t2;
            boolean t1;
            STUN stun = new STUN();
            stun.start(localport, host1, null, null, this);
            this.ok = false;
            stun.requestPublicIP(false, false);
            JF.sleep(1000);
            if (!this.ok) {
                t1 = false;
                JFLog.log("STUN:Test I:Failed");
            } else {
                t1 = true;
                JFLog.log("STUN:Test I:IP=" + this.ip + ":" + this.port);
            }
            this.ok = false;
            stun.requestPublicIP(true, true);
            JF.sleep(1000);
            if (!this.ok) {
                t2 = false;
                JFLog.log("STUN:Test II:Failed");
            } else {
                t2 = true;
                JFLog.log("STUN:Test II:IP=" + this.ip + ":" + this.port);
            }
            this.ok = false;
            stun.requestPublicIP(false, true);
            JF.sleep(1000);
            if (!this.ok) {
                t3 = false;
                JFLog.log("STUN:Test III:Failed");
            } else {
                t3 = true;
                JFLog.log("STUN:Test III:IP=" + this.ip + ":" + this.port);
            }
            String localIP = stun.getLocalAddr();
            stun.close();
            String ip1 = this.ip;
            int port1 = this.port;
            if (host2 != null) {
                stun = new STUN();
                stun.start(localport, host2, null, null, this);
                this.ok = false;
                stun.requestPublicIP(false, false);
                JF.sleep(1000);
                if (!this.ok) {
                    t1b = false;
                    JFLog.log("STUN:Test I(Server #2):Failed");
                } else {
                    t1b = true;
                    JFLog.log("STUN:Test I(Server #2):IP=" + this.ip + ":" + this.port);
                }
                stun.close();
            } else {
                t1b = false;
            }
            JFLog.log("STUN:Tests Complete");
            if (!t1) {
                return NAT.Unknown;
            }
            if (localIP.equals(ip1)) {
                if (t2) {
                    return NAT.None;
                }
                return NAT.SymmetricFirewall;
            }
            if (t2) {
                return NAT.FullCone;
            }
            if (t1b) {
                if (!ip1.equals(this.ip) || port1 != this.port) {
                    return NAT.SymmetricNAT;
                }
            } else {
                JFLog.log("STUN:Test:Warning:2nd STUN server failed or skipped, Symmetric NAT test undetermined.");
            }
            if (t3) {
                return NAT.RestrictedCone;
            }
            return NAT.RestrictedPort;
        }

        @Override
        public void stunPublicIP(STUN stun, String ip, int port) {
            this.ip = ip;
            this.port = port;
            this.ok = true;
        }

        @Override
        public void turnAlloc(STUN stun, String ip, int port, byte[] token, int lifetime) {
        }

        @Override
        public void turnBind(STUN stun) {
        }

        @Override
        public void turnRefresh(STUN stun, int lifetime) {
        }

        @Override
        public void turnFailed(STUN stun) {
        }

        @Override
        public void turnData(STUN stun, byte[] data, int offset, int length, short channel) {
        }
    }

    public static enum NAT {
        Unknown,
        None,
        FullCone,
        RestrictedCone,
        RestrictedPort,
        SymmetricFirewall,
        SymmetricNAT;

    }
}

