/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ansi.client;

import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import javaforce.JF;
import javaforce.ansi.client.Buffer;
import javaforce.ansi.client.BufferViewer;
import javaforce.awt.JFAWT;
import javax.swing.JFileChooser;

public class Script {
    private String[] script;
    private int pos = 0;
    private int chpos = 0;
    private boolean waiting = false;
    private int waitsiz = 0;
    private char[] buf;
    private int buflen = 0;
    private String waitstr = null;

    private Script() {
    }

    private void nextLine() {
        ++this.pos;
        this.chpos = 0;
    }

    public void input(char ch, Buffer buffer) {
        if (!this.waiting) {
            return;
        }
        if (this.buflen == this.waitsiz) {
            for (int a = 0; a < this.buflen - 1; ++a) {
                this.buf[a] = this.buf[a + 1];
            }
            this.buf[this.buflen - 1] = ch;
        } else {
            this.buf[this.buflen++] = ch;
        }
        if (this.buflen != this.waitsiz) {
            return;
        }
        if (this.waitstr.equalsIgnoreCase(new String(this.buf))) {
            this.waiting = false;
            this.process(buffer);
        }
    }

    public static Script load(BufferViewer buffer) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setCurrentDirectory(new File(JF.getCurrentPath()));
        if (chooser.showOpenDialog(buffer) != 0) {
            return null;
        }
        Script ret = new Script();
        try {
            FileInputStream fis = new FileInputStream(chooser.getSelectedFile().getAbsolutePath());
            int fs = fis.available();
            if (fs < 1) {
                return null;
            }
            byte[] data = new byte[fs];
            if (fis.read(data) != fs) {
                throw new Exception();
            }
            String str = new String(data);
            str = str.replaceAll("\r", "");
            ret.script = str.split("\n");
        }
        catch (Exception e) {
            JFAWT.showError("File Error", "Unable to open script file");
            return null;
        }
        if (ret.process(buffer.buffer)) {
            return null;
        }
        return ret;
    }

    private boolean isWS(char ch) {
        if (ch == ' ') {
            return true;
        }
        return ch == '\t';
    }

    private String nextToken() {
        Object ret = "";
        boolean quote = false;
        if (this.pos >= this.script.length) {
            return "";
        }
        if (this.chpos >= this.script[this.pos].length()) {
            ++this.pos;
            this.chpos = 0;
        }
        if (this.pos >= this.script.length) {
            return "";
        }
        try {
            while (this.isWS(this.script[this.pos].charAt(this.chpos))) {
                ++this.chpos;
                if (this.chpos >= this.script[this.pos].length()) {
                    ++this.pos;
                    this.chpos = 0;
                }
                if (this.pos < this.script.length) continue;
                return "";
            }
            while (true) {
                char ch = this.script[this.pos].charAt(this.chpos++);
                if (!quote) {
                    if (ch == '#') {
                        throw new Exception();
                    }
                    if (this.isWS(ch)) {
                        return ret;
                    }
                    if (ch == '\"') {
                        quote = true;
                        continue;
                    }
                }
                if (ch == '\"') {
                    return ret;
                }
                ret = (String)ret + ch;
            }
        }
        catch (Exception e) {
            ++this.pos;
            this.chpos = 0;
            return ret;
        }
    }

    public synchronized boolean process(Buffer buffer) {
        String cmd = "";
        String arg = "";
        if (this.waiting) {
            return false;
        }
        if (this.pos >= this.script.length) {
            return true;
        }
        while (true) {
            cmd = "";
            while (cmd.length() == 0) {
                if (this.pos >= this.script.length) {
                    return true;
                }
                cmd = this.nextToken();
            }
            arg = "";
            while (arg.length() == 0) {
                if (this.pos >= this.script.length) {
                    return true;
                }
                arg = this.nextToken();
            }
            if (cmd.equalsIgnoreCase("type")) {
                buffer.output(arg.toCharArray());
                continue;
            }
            if (cmd.equalsIgnoreCase("wait")) {
                this.waitstr = arg;
                this.waitsiz = this.waitstr.length();
                this.buf = new char[this.waitsiz];
                this.buflen = 0;
                this.waiting = true;
                return false;
            }
            if (cmd.equalsIgnoreCase("sleep")) {
                JF.sleep(JF.atoi(arg) * 1000);
            }
            if (!cmd.equalsIgnoreCase("hitkey")) continue;
            try {
                KeyEvent ke = new KeyEvent(buffer.viewer, 0, 0L, 0, 0, ' ');
                Class<?> c = ke.getClass();
                Field f = c.getField(arg);
                int keyCode = f.getInt(ke);
                switch (keyCode) {
                    default: 
                }
                buffer.output(new char[]{(char)keyCode});
                continue;
            }
            catch (Exception e) {
                JFAWT.showError("Bad Script", "HitKey : " + arg);
                continue;
            }
            break;
        }
    }
}

