/*
 * Decompiled with CFR 0.152.
 */
package javaforce.linux;

import java.util.HashMap;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.awt.JFImage;
import javaforce.utils.OpenFile;

public class IconCache {
    private static HashMap<String, JFImage> icons = new HashMap();
    private static String prefix;
    private static HashMap<String, String> mimes;

    public static JFImage loadIcon(String iconName) {
        JFImage icon = icons.get(iconName);
        if (icon != null) {
            return icon;
        }
        icon = new JFImage();
        if (iconName.startsWith("jffile-")) {
            icon.loadPNG(icon.getClass().getClassLoader().getResourceAsStream(iconName + ".png"));
            icons.put(iconName, icon);
            return icon;
        }
        if (prefix != null && iconName.startsWith(prefix)) {
            icon.loadPNG(icon.getClass().getClassLoader().getResourceAsStream(iconName + ".png"));
            icons.put(iconName, icon);
            return icon;
        }
        if (iconName.endsWith(".xpm") && icon.loadXPM(iconName)) {
            icons.put(iconName, icon);
            return icon;
        }
        if (icon.loadPNG(iconName)) {
            icons.put(iconName, icon);
            return icon;
        }
        if (icon.loadPNG("/usr/share/icons/hicolor/48x48/apps/" + iconName + ".png")) {
            icons.put(iconName, icon);
            return icon;
        }
        if (icon.loadPNG("/usr/share/pixmaps/" + iconName + ".png")) {
            icons.put(iconName, icon);
            return icon;
        }
        if (icon.loadPNG("/usr/share/app-install/icons/" + iconName + ".png")) {
            icons.put(iconName, icon);
            return icon;
        }
        if (icon.loadPNG(JF.getUserPath() + "/.local/share/icons/hicolor/48x48/apps/" + iconName + ".png")) {
            icons.put(iconName, icon);
            return icon;
        }
        if (icon.loadPNG(JF.getUserPath() + "/.local/share/icons/hicolor/32x32/apps/" + iconName + ".png")) {
            icons.put(iconName, icon);
            return icon;
        }
        if (icon.loadPNG(JF.getUserPath() + "/.local/share/icons/hicolor/16x16/apps/" + iconName + ".png")) {
            icons.put(iconName, icon);
            return icon;
        }
        if (icon.loadXPM("/usr/share/pixmaps/" + iconName + ".xpm")) {
            icons.put(iconName, icon);
            return icon;
        }
        if (icon.loadSVG("/usr/share/icons/hicolor/scalable/apps/" + iconName + ".svg", 64, 64)) {
            icons.put(iconName, icon);
            return icon;
        }
        JFLog.log("icon not found:" + iconName);
        icon.loadPNG(icon.getClass().getClassLoader().getResourceAsStream("jffile-404-icon.png"));
        return icon;
    }

    public static JFImage scaleIcon(JFImage image, int x, int y) {
        if (image.getWidth() == x && image.getHeight() == y) {
            return image;
        }
        JFImage scale = new JFImage(x, y);
        scale.fill(0, 0, x, y, 0, true);
        scale.getGraphics().drawImage(image.getImage(), 0, 0, x, y, 0, 0, image.getWidth(), image.getHeight(), null);
        return scale;
    }

    public static String findIcon(String fn) {
        int idx = fn.lastIndexOf("/");
        if (idx != -1) {
            fn = fn.substring(idx + 1);
        }
        if ((idx = fn.lastIndexOf(".")) == -1) {
            return "jffile-file";
        }
        String ext = fn.substring(idx + 1);
        String icon = mimes.get(ext);
        if (icon != null) {
            return icon;
        }
        try {
            if (JF.isWindows()) {
                icon = "jffile-file";
            } else {
                String mime = OpenFile.getMimeType(ext);
                icon = OpenFile.getIcon(mime, "open");
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        if (icon == null) {
            icon = "jffile-file";
        }
        mimes.put(ext, icon);
        return icon;
    }

    public static void setPrefix(String prefix) {
        IconCache.prefix = prefix;
    }

    static {
        mimes = new HashMap();
    }
}

