/*
 * Decompiled with CFR 0.152.
 */
package javaforce.net;

import java.net.InetAddress;
import javaforce.JFLog;
import javaforce.net.IP4;

public class Subnet4 {
    private IP4 ip = new IP4();
    private IP4 mask = new IP4();

    public boolean setIP(String str) {
        return this.ip.setIP(str);
    }

    public boolean setIP(InetAddress addr) {
        return this.setIP(addr.getHostAddress());
    }

    public boolean setMask(String str) {
        if (!this.mask.setIP(str)) {
            return false;
        }
        this.maskIP();
        return true;
    }

    public boolean setMask(InetAddress addr) {
        return this.setMask(addr.getHostAddress());
    }

    public boolean matches(IP4 in) {
        for (int a = 0; a < 4; ++a) {
            short o = (short)(in.ip[a] & this.mask.ip[a]);
            if (o == this.ip.ip[a]) continue;
            return false;
        }
        return true;
    }

    private void maskIP() {
        for (int a = 0; a < 4; ++a) {
            int n = a;
            this.ip.ip[n] = (byte)(this.ip.ip[n] & this.mask.ip[a]);
        }
    }

    public String toString() {
        return this.ip.toString() + "/" + this.mask.toString();
    }

    public static void test(Subnet4 net, String ip) {
        IP4 ip4 = new IP4();
        ip4.setIP(ip);
        JFLog.log(net.matches(ip4) + ":" + ip);
    }

    public static void main(String[] args) {
        Subnet4 net = new Subnet4();
        net.setIP("192.168.1.0");
        net.setMask("255.255.255.0");
        Subnet4.test(net, "192.168.1.5");
        Subnet4.test(net, "192.168.5.5");
    }
}

