/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.io.FileInputStream;
import javaforce.JFLog;
import javaforce.XML;

public class BuildTools {
    private XML xml;
    private BuildTools versions;
    private String file;
    private boolean debug = false;

    public boolean loadXML(String xmlfile) {
        this.file = xmlfile;
        this.xml = new XML();
        try {
            this.xml.read(new FileInputStream(xmlfile));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return false;
        }
    }

    public String getTag(String name) {
        XML.XMLTag tag = this.xml.getTag(new String[]{"project", name});
        if (tag == null) {
            return "";
        }
        return tag.content;
    }

    public String getProperty(String name) {
        int cnt = this.xml.root.getChildCount();
        for (int a = 0; a < cnt; ++a) {
            XML.XMLTag tag = this.xml.root.getChildAt(a);
            if (!tag.name.equals("property")) continue;
            int attrs = tag.attrs.size();
            String attrName = null;
            String attrValue = null;
            for (int b = 0; b < attrs; ++b) {
                XML.XMLAttr attr = tag.attrs.get(b);
                if (attr.name.equals("name")) {
                    attrName = attr.value;
                }
                if (attr.name.equals("value")) {
                    attrValue = attr.value;
                }
                if (!attr.name.equals("location")) continue;
                attrValue = attr.value;
            }
            if (attrName == null || !attrName.equals(name)) continue;
            if (attrValue.equals("${javaforce-version}")) {
                attrValue = this.getVersion("javaforce-version");
            }
            return attrValue;
        }
        if (this.debug) {
            JFLog.log("error:property not found:" + name + ":file=" + this.file);
        }
        return "";
    }

    public String getVersion(String name) {
        String home = this.getProperty("home");
        if (this.versions == null) {
            this.versions = new BuildTools();
            this.versions.loadXML(home + "/versions.xml");
        }
        return this.versions.getProperty(name);
    }

    public static void chmod_x(String file) {
        new File(file).setExecutable(true);
    }
}

