package javaforce;

/** Class Loader from a ClassPath.
 *
 * You could use URLClassLoader with file://... but this is easier.
 *
 * see https://github.com/openjdk/jdk/blob/master/src/java.base/share/classes/jdk/internal/loader/BuiltinClassLoader.java
 * see https://github.com/apache/tomcat/blob/main/java/org/apache/catalina/loader/WebappClassLoaderBase.java
 *
 * @author pquiring
 */

import java.io.*;
import java.net.*;
import java.util.*;
import java.util.zip.*;

public class JFClassLoader extends ClassLoader {
  private static class Folder {

  };
  private static class FileFolder extends Folder {

  };
  private static class JarFolder extends Folder {

  };
  private ArrayList<Folder> cp_folders = new ArrayList<>();
  private HashMap<String, Folder> cp_files = new HashMap<>();

  /** Build a Class Loader from the classpath.
   *
   * classpath may include directories and jar files.
   *
   */
  public JFClassLoader(String[] classpath) {
    File[] files = new File[classpath.length];
    int idx = 0;
    for(String cp : classpath) {
      files[idx++] = new File(cp);
    }
    init(files);
  }

  /** Build a Class Loader from the classpath.
   *
   * classpath may include directories and jar files.
   *
   */
  public JFClassLoader(File[] classpath) {
    init(classpath);
  }

  private void init(File[] classpath) {
    for(File file : classpath) {
      if (!file.exists()) {
        JFLog.log("Error:ClassPath element not found:" + file.getAbsolutePath());
        continue;
      }
      if (file.isDirectory()) {
        FileFolder folder = new FileFolder();
        cp_folders.add(folder);
        doFileFolder(file, folder);
        continue;
      }
      if (file.getName().endsWith(".jar")) {
        JarFolder folder = new JarFolder();
        cp_folders.add(folder);
        doJarFolder(file, folder);
        continue;
      }
    }
  }

  private void doFileFolder(File folder, Folder entry) {
    try {
      File[] files = folder.listFiles();
      for(File file : files) {
        if (file.isDirectory()) {
          doFileFolder(file, entry);
        } else {
          cp_files.put(file.getAbsoluteFile().toString(), entry);
        }
      }
    } catch (Exception e) {
      JFLog.log(e);
    }
  }

  private void doJarFolder(File jar, Folder entry) {
    try {
      ZipInputStream zis = new ZipInputStream(new FileInputStream(jar));
      ZipEntry ze;
      while ((ze = zis.getNextEntry()) != null) {
        String name = ze.getName();
        if (ze.isDirectory()) {
          continue;
        }
        cp_files.put(name, entry);
      }
      zis.close();
    } catch (Exception e) {
      JFLog.log(e);
    }
  }

  public Class findClass(String name) {
    byte[] b = loadClassData(name);
    return defineClass(name, b, 0, b.length);
  }

  public Class<?> findClass(String module_name, String name) {
    byte[] b = loadClassData(name);
    return defineClass(name, b, 0, b.length);
  }

  private byte[] loadClassData(String name) {
    // load the class data from the connection
    return null;  //TODO
  }

  public URL findResource(final String name) {
    return null;
  }

  public Enumeration<URL> findResources(String name) throws IOException {
    return null;
  }

  public URL getResource(String name) {
    return null;
  }

  public Enumeration<URL> getResources(String name) throws IOException {
    return null;
  }

  public InputStream getResourceAsStream(String name) {
    return null;
  }

  public Class<?> loadClass(String name) throws ClassNotFoundException {
    return null;
  }

  public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
    return null;
  }
}
