/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javaforce.JFLog;

public class JFClassLoader
extends ClassLoader {
    private ArrayList<Folder> cp_folders = new ArrayList();
    private HashMap<String, Folder> cp_files = new HashMap();

    public JFClassLoader(String[] classpath) {
        File[] files = new File[classpath.length];
        int idx = 0;
        for (String cp : classpath) {
            files[idx++] = new File(cp);
        }
        this.init(files);
    }

    public JFClassLoader(File[] classpath) {
        this.init(classpath);
    }

    private void init(File[] classpath) {
        for (File file : classpath) {
            Folder folder;
            if (!file.exists()) {
                JFLog.log("Error:ClassPath element not found:" + file.getAbsolutePath());
                continue;
            }
            if (file.isDirectory()) {
                folder = new FileFolder();
                this.cp_folders.add(folder);
                this.doFileFolder(file, folder);
                continue;
            }
            if (!file.getName().endsWith(".jar")) continue;
            folder = new JarFolder();
            this.cp_folders.add(folder);
            this.doJarFolder(file, folder);
        }
    }

    private void doFileFolder(File folder, Folder entry) {
        try {
            File[] files;
            for (File file : files = folder.listFiles()) {
                if (file.isDirectory()) {
                    this.doFileFolder(file, entry);
                    continue;
                }
                this.cp_files.put(file.getAbsoluteFile().toString(), entry);
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private void doJarFolder(File jar, Folder entry) {
        try {
            ZipEntry ze;
            ZipInputStream zis = new ZipInputStream(new FileInputStream(jar));
            while ((ze = zis.getNextEntry()) != null) {
                String name = ze.getName();
                if (ze.isDirectory()) continue;
                this.cp_files.put(name, entry);
            }
            zis.close();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public Class findClass(String name) {
        byte[] b = this.loadClassData(name);
        return this.defineClass(name, b, 0, b.length);
    }

    @Override
    public Class<?> findClass(String module_name, String name) {
        byte[] b = this.loadClassData(name);
        return this.defineClass(name, b, 0, b.length);
    }

    private byte[] loadClassData(String name) {
        return null;
    }

    @Override
    public URL findResource(String name) {
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return null;
    }

    @Override
    public URL getResource(String name) {
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return null;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return null;
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return null;
    }

    private static class FileFolder
    extends Folder {
        private FileFolder() {
        }
    }

    private static class Folder {
        private Folder() {
        }
    }

    private static class JarFolder
    extends Folder {
        private JarFolder() {
        }
    }
}

