/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt.security;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Enumeration;
import javaforce.JFLog;
import javaforce.KeyMgmt;
import javaforce.awt.JFAWT;
import javaforce.awt.ViewLog;
import javaforce.awt.security.GenKeyPair;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;

public class KeyMgr
extends JDialog {
    private KeyMgmt keys;
    private DefaultTableModel model;
    private String root = "root";
    private static boolean debug = false;
    private JToolBar bar1;
    private JToolBar bar2;
    private JToolBar bar3;
    private JToolBar bar4;
    private JToolBar bar5;
    private JButton details;
    private JButton export_crt;
    private JButton export_key;
    private JButton export_ks;
    private JButton gen_client;
    private JButton gen_csr;
    private JButton gen_root;
    private JButton import_key;
    private JButton import_ks;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton4;
    private JScrollPane jScrollPane2;
    private JButton reload;
    private JButton rename_alias;
    private JButton signcsr;
    private JTable table;
    private JButton validate;

    public KeyMgr(KeyMgmt keys) {
        super((Frame)null, true);
        this.keys = keys;
        this.initComponents();
        this.init();
    }

    public KeyMgr(String keystore, String password) {
        super((Frame)null, true);
        this.keys = new KeyMgmt();
        this.keys.setFile(keystore);
        this.keys.setKeyStorePass(password);
        this.keys.open();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.model = (DefaultTableModel)this.table.getModel();
        this.reload();
        JFAWT.centerWindow(this);
        this.bar1.setFloatable(false);
        this.bar2.setFloatable(false);
        this.bar3.setFloatable(false);
        this.bar4.setFloatable(false);
        this.bar5.setFloatable(false);
    }

    public void setRootAlias(String alias) {
        this.root = alias;
    }

    private void initComponents() {
        this.jButton4 = new JButton();
        this.bar1 = new JToolBar();
        this.gen_root = new JButton();
        this.gen_client = new JButton();
        this.details = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.table = new JTable();
        this.bar4 = new JToolBar();
        this.export_ks = new JButton();
        this.jButton2 = new JButton();
        this.export_key = new JButton();
        this.export_crt = new JButton();
        this.bar5 = new JToolBar();
        this.import_ks = new JButton();
        this.import_key = new JButton();
        this.bar3 = new JToolBar();
        this.gen_csr = new JButton();
        this.signcsr = new JButton();
        this.bar2 = new JToolBar();
        this.rename_alias = new JButton();
        this.validate = new JButton();
        this.jButton1 = new JButton();
        this.reload = new JButton();
        this.jButton4.setText("jButton4");
        this.setDefaultCloseOperation(2);
        this.setTitle("Key Manager");
        this.bar1.setBorderPainted(false);
        this.bar1.setFocusable(false);
        this.gen_root.setText("Generate Root KeyPair");
        this.gen_root.setFocusable(false);
        this.gen_root.setHorizontalTextPosition(0);
        this.gen_root.setVerticalTextPosition(3);
        this.gen_root.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyMgr.this.gen_rootActionPerformed(evt);
            }
        });
        this.bar1.add(this.gen_root);
        this.gen_client.setText("Generate Client KeyPair");
        this.gen_client.setFocusable(false);
        this.gen_client.setHorizontalTextPosition(0);
        this.gen_client.setVerticalTextPosition(3);
        this.gen_client.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyMgr.this.gen_clientActionPerformed(evt);
            }
        });
        this.bar1.add(this.gen_client);
        this.details.setText("View Details");
        this.details.setFocusable(false);
        this.details.setHorizontalTextPosition(0);
        this.details.setVerticalTextPosition(3);
        this.details.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyMgr.this.detailsActionPerformed(evt);
            }
        });
        this.bar1.add(this.details);
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Alias", "PrivateKey", "PublicCert"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane2.setViewportView(this.table);
        this.bar4.setBorderPainted(false);
        this.bar4.setFocusable(false);
        this.export_ks.setText("Export KeyStore");
        this.export_ks.setFocusable(false);
        this.export_ks.setHorizontalTextPosition(0);
        this.export_ks.setVerticalTextPosition(3);
        this.export_ks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyMgr.this.export_ksActionPerformed(evt);
            }
        });
        this.bar4.add(this.export_ks);
        this.jButton2.setText("Export Key/Cert to KeyStore");
        this.jButton2.setFocusable(false);
        this.jButton2.setHorizontalTextPosition(0);
        this.jButton2.setVerticalTextPosition(3);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyMgr.this.jButton2ActionPerformed(evt);
            }
        });
        this.bar4.add(this.jButton2);
        this.export_key.setText("Export Key");
        this.export_key.setFocusable(false);
        this.export_key.setHorizontalTextPosition(0);
        this.export_key.setVerticalTextPosition(3);
        this.export_key.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyMgr.this.export_keyActionPerformed(evt);
            }
        });
        this.bar4.add(this.export_key);
        this.export_crt.setText("Export Cert");
        this.export_crt.setFocusable(false);
        this.export_crt.setHorizontalTextPosition(0);
        this.export_crt.setVerticalTextPosition(3);
        this.export_crt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyMgr.this.export_crtActionPerformed(evt);
            }
        });
        this.bar4.add(this.export_crt);
        this.bar5.setBorderPainted(false);
        this.bar5.setFocusable(false);
        this.import_ks.setText("Import KeyStore");
        this.import_ks.setFocusable(false);
        this.import_ks.setHorizontalTextPosition(0);
        this.import_ks.setVerticalTextPosition(3);
        this.import_ks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyMgr.this.import_ksActionPerformed(evt);
            }
        });
        this.bar5.add(this.import_ks);
        this.import_key.setText("Import Key/Cert");
        this.import_key.setFocusable(false);
        this.import_key.setHorizontalTextPosition(0);
        this.import_key.setVerticalTextPosition(3);
        this.import_key.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyMgr.this.import_keyActionPerformed(evt);
            }
        });
        this.bar5.add(this.import_key);
        this.bar3.setBorderPainted(false);
        this.bar3.setFocusable(false);
        this.gen_csr.setText("Generate Cert Sign Request");
        this.gen_csr.setFocusable(false);
        this.gen_csr.setHorizontalTextPosition(0);
        this.gen_csr.setVerticalTextPosition(3);
        this.gen_csr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyMgr.this.gen_csrActionPerformed(evt);
            }
        });
        this.bar3.add(this.gen_csr);
        this.signcsr.setText("Sign Request");
        this.signcsr.setFocusable(false);
        this.signcsr.setHorizontalTextPosition(0);
        this.signcsr.setVerticalTextPosition(3);
        this.signcsr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyMgr.this.signcsrActionPerformed(evt);
            }
        });
        this.bar3.add(this.signcsr);
        this.bar2.setBorderPainted(false);
        this.bar2.setFocusable(false);
        this.rename_alias.setText("Rename Alias");
        this.rename_alias.setFocusable(false);
        this.rename_alias.setHorizontalTextPosition(0);
        this.rename_alias.setVerticalTextPosition(3);
        this.rename_alias.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyMgr.this.rename_aliasActionPerformed(evt);
            }
        });
        this.bar2.add(this.rename_alias);
        this.validate.setText("Verify");
        this.validate.setFocusable(false);
        this.validate.setHorizontalTextPosition(0);
        this.validate.setVerticalTextPosition(3);
        this.validate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyMgr.this.validateActionPerformed(evt);
            }
        });
        this.bar2.add(this.validate);
        this.jButton1.setText("Delete");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyMgr.this.jButton1ActionPerformed(evt);
            }
        });
        this.bar2.add(this.jButton1);
        this.reload.setText("Reload");
        this.reload.setFocusable(false);
        this.reload.setHorizontalTextPosition(0);
        this.reload.setVerticalTextPosition(3);
        this.reload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyMgr.this.reloadActionPerformed(evt);
            }
        });
        this.bar2.add(this.reload);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bar2, -1, -1, Short.MAX_VALUE).addComponent(this.bar4, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -1, 391, Short.MAX_VALUE).addComponent(this.bar1, GroupLayout.Alignment.TRAILING, -1, 391, Short.MAX_VALUE).addComponent(this.bar5, -1, -1, Short.MAX_VALUE).addComponent(this.bar3, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.bar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bar2, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bar3, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bar4, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bar5, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 343, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void gen_rootActionPerformed(ActionEvent evt) {
        this.do_gen(true);
    }

    private void gen_clientActionPerformed(ActionEvent evt) {
        this.do_gen(false);
    }

    private void reloadActionPerformed(ActionEvent evt) {
        this.reload();
    }

    private void rename_aliasActionPerformed(ActionEvent evt) {
        this.rename();
    }

    private void validateActionPerformed(ActionEvent evt) {
        this.verify();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.delete();
    }

    private void gen_csrActionPerformed(ActionEvent evt) {
        this.gen_csr();
    }

    private void signcsrActionPerformed(ActionEvent evt) {
        this.sign_csr();
    }

    private void export_ksActionPerformed(ActionEvent evt) {
        this.export_ks();
    }

    private void import_ksActionPerformed(ActionEvent evt) {
        this.import_ks();
    }

    private void export_keyActionPerformed(ActionEvent evt) {
        this.export_key();
    }

    private void export_crtActionPerformed(ActionEvent evt) {
        this.export_crt();
    }

    private void import_keyActionPerformed(ActionEvent evt) {
        this.import_key();
    }

    private void detailsActionPerformed(ActionEvent evt) {
        this.details();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.export_alias();
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            KeyMgr.usage();
            return;
        }
        switch (args[0]) {
            case "open": {
                KeyMgr dialog = new KeyMgr(args[1], args[2]);
                dialog.setVisible(true);
                break;
            }
            case "create": {
                KeyMgmt keys = new KeyMgmt(args[1], args[2]);
                keys.create();
                KeyMgr dialog = new KeyMgr(keys);
                dialog.setVisible(true);
                break;
            }
        }
        System.exit(0);
    }

    private static void usage() {
        JFLog.log("JFKeyMgr");
        JFLog.log("usage : open keystore.ks password");
        JFLog.log("usage : create keystore.ks password");
    }

    private void reload() {
        this.keys.open();
        KeyStore ks = this.keys.getKeyStore();
        char[] pwd = this.keys.getKeyStorePass().toCharArray();
        this.model.setRowCount(0);
        try {
            int cnt = 0;
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate crt = ks.getCertificate(alias);
                Key key = ks.getKey(alias, pwd);
                this.model.addRow(new String[]{alias, key.toString(), crt.toString()});
                ++cnt;
            }
            if (debug) {
                JFLog.log("Aliases found:" + cnt);
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        this.table.revalidate();
        this.repaint();
    }

    private void do_gen(boolean gen_root) {
        if (this.keys.contains(this.root) && !JFAWT.showConfirm("Replace root keys", "Replacing root keys will invalidate all client keys!\r\nAre you sure?")) {
            return;
        }
        GenKeyPair dialog = new GenKeyPair(null, true, this.keys, gen_root);
        dialog.setRootAlias(this.root);
        dialog.setVisible(true);
        this.reload();
    }

    private void rename() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        String alias = (String)this.model.getValueAt(row, 0);
        String newalias = JFAWT.getString("New Alias Name", alias);
        if (newalias == null || newalias.equals(alias)) {
            return;
        }
        KeyStore.Entry entry = this.keys.getEntry(alias);
        if (debug) {
            JFLog.log("entry=" + entry);
        }
        this.keys.deleteEntry(alias);
        this.keys.setEntry(newalias, entry);
        this.keys.save();
        this.reload();
    }

    private void verify() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        String alias = (String)this.model.getValueAt(row, 0);
        if (alias == null || alias.equals(this.root)) {
            return;
        }
        this.keys.setRootAlias(this.root);
        if (this.keys.verify(alias)) {
            JFAWT.showMessage("Verify", "Key is verified!");
        } else {
            JFAWT.showMessage("Verify", "Key is NOT verified!");
        }
    }

    private void delete() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        String alias = (String)this.model.getValueAt(row, 0);
        if (alias == null) {
            return;
        }
        this.keys.deleteEntry(alias);
        this.keys.save();
        this.reload();
    }

    public void gen_csr() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        String alias = (String)this.model.getValueAt(row, 0);
        if (alias == null) {
            return;
        }
        String csr = JFAWT.getSaveFile(alias + ".csr");
        this.keys.createCertSignRequest(alias, this.keys.getKeyStorePass(), csr);
        this.reload();
    }

    public void sign_csr() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        String alias = (String)this.model.getValueAt(row, 0);
        if (alias == null) {
            return;
        }
        String in_csr = JFAWT.getOpenFile(".");
        String out_crt = JFAWT.getSaveFile(alias + ".crt");
        this.keys.signRequest(alias, this.keys.getKeyStorePass(), in_csr, out_crt);
        this.reload();
    }

    public void export_ks() {
        String file = JFAWT.getSaveFile("export.ks");
        if (file == null) {
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            this.keys.save(fos);
            fos.close();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void import_ks() {
        String file = JFAWT.getOpenFile(".");
        if (file == null) {
            return;
        }
        String pass = JFAWT.getString("Enter password", "password");
        KeyMgmt newkeys = new KeyMgmt(file, pass);
        KeyStore newks = newkeys.getKeyStore();
        KeyStore ks = this.keys.getKeyStore();
        try {
            int cnt = 0;
            Enumeration<String> aliases = newks.aliases();
            KeyStore.PasswordProtection pp = new KeyStore.PasswordProtection(pass.toCharArray());
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                KeyStore.Entry entry = newks.getEntry(alias, pp);
                ks.setEntry(alias, entry, pp);
                ++cnt;
            }
            if (debug) {
                JFLog.log("Aliases found:" + cnt);
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        this.keys.save();
        this.reload();
    }

    public void export_key() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        String alias = (String)this.model.getValueAt(row, 0);
        if (alias == null) {
            return;
        }
        String file = JFAWT.getSaveFile(alias + ".key");
        if (file == null) {
            return;
        }
        String keypass = JFAWT.getString("Key Password", this.keys.getKeyStorePass());
        if (keypass == null) {
            return;
        }
        this.keys.exportKEY(alias, keypass, file);
    }

    public void export_crt() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        String alias = (String)this.model.getValueAt(row, 0);
        if (alias == null) {
            return;
        }
        String file = JFAWT.getSaveFile(alias + ".crt");
        if (file == null) {
            return;
        }
        this.keys.exportCRT(alias, file);
    }

    public void import_key() {
        String file_key = JFAWT.getOpenFile(".", new String[][]{{".key", "Key"}});
        if (file_key == null) {
            return;
        }
        String file_crt = JFAWT.getOpenFile(".", new String[][]{{".crt", "Certificate"}});
        if (file_crt == null) {
            return;
        }
        String alias = JFAWT.getString("Enter Alias", "alias+" + this.keys.getCount());
        if (alias == null) {
            return;
        }
        String pass = JFAWT.getString("Enter Key Pass", this.keys.getKeyStorePass());
        if (pass == null) {
            return;
        }
        try {
            FileInputStream keyStream = new FileInputStream(file_key);
            FileInputStream certStream = new FileInputStream(file_crt);
            this.keys.loadKEYandCRT(alias, keyStream, certStream, pass);
            keyStream.close();
            certStream.close();
            this.keys.save();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        this.reload();
    }

    public void details() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        String alias = (String)this.model.getValueAt(row, 0);
        if (alias == null) {
            return;
        }
        KeyStore ks = this.keys.getKeyStore();
        char[] pwd = this.keys.getKeyStorePass().toCharArray();
        try {
            StringBuilder txt = new StringBuilder();
            Certificate crt = ks.getCertificate(alias);
            Key key = ks.getKey(alias, pwd);
            txt.append(key.toString());
            txt.append(crt.toString());
            ViewLog log = new ViewLog(txt.toString().getBytes());
            log.setVisible(true);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void export_alias() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        String alias = (String)this.model.getValueAt(row, 0);
        if (alias == null) {
            return;
        }
        String file = JFAWT.getSaveFile("export.ks");
        if (file == null) {
            return;
        }
        try {
            KeyMgmt export = new KeyMgmt();
            export.setFile(file);
            export.setKeyStorePass(this.keys.getKeyStorePass());
            KeyStore.Entry entry = this.keys.getEntry(alias);
            export.setEntry(alias, entry);
            FileOutputStream fos = new FileOutputStream(file);
            export.save(fos);
            fos.close();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }
}

