/*
 * Decompiled with CFR 0.152.
 */
package javaforce.gl;

import javaforce.gl.GL;
import javaforce.gl.Matrix;
import javaforce.gl.Model;
import javaforce.gl.Object3;
import javaforce.gl.Scene;
import javaforce.gl.Texture;
import javaforce.gl.UVMap;

public class Render {
    private int iwx;
    private int iwy;
    private float dwx;
    private float dwy;
    private float ratio;
    private Scene scene;
    public Matrix m_camera;
    public Matrix m_model;
    public float fovy = 60.0f;
    public float zNear = 0.1f;
    public float zFar = 10000.0f;

    public void init(Scene scene, int width, int height) {
        this.scene = scene;
        this.resize(width, height);
        this.reset();
    }

    public void resize(int width, int height) {
        this.iwx = width;
        this.iwy = height;
        this.dwx = width;
        this.dwy = height;
        this.ratio = this.dwx / this.dwy;
    }

    public void reset() {
        this.m_camera = new Matrix();
        this.m_model = new Matrix();
    }

    public void setFOV(float fov) {
        this.fovy = fov;
    }

    public void setRenderDistance(float near, float far) {
        this.zNear = near;
        this.zFar = far;
    }

    public void render() {
        this.scene.initTextures();
        Matrix mat = new Matrix();
        GL.glViewport(0, 0, this.iwx, this.iwy);
        GL.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        GL.glClear(17664);
        int size_ml = this.scene.ml.size();
        mat.setIdentity();
        mat.perspective(this.fovy, this.ratio, this.zNear, this.zFar);
        GL.glUniformMatrix4fv(this.scene.mpu, 1, 0, mat.m);
        for (int a = 0; a < size_ml; ++a) {
            Model mod = this.scene.ml.get(a);
            if (!mod.visible) continue;
            mat.setIdentity();
            mat.mult4x4(this.m_camera);
            GL.glUniformMatrix4fv(this.scene.mvu, 1, 0, mat.m);
            int size_ol = mod.ol.size();
            for (int b = 0; b < size_ol; ++b) {
                Object3 obj = mod.ol.get(b);
                if (!obj.visible) continue;
                if (obj.needCopyBuffers) {
                    obj.copyBuffers();
                }
                mat.setIdentity();
                mat.mult4x4(this.m_model);
                mat.mult4x4(mod.m);
                mat.mult4x4(obj.m);
                GL.glUniformMatrix4fv(this.scene.mmu, 1, 0, mat.m);
                for (int m = 0; m < obj.maps.size(); ++m) {
                    UVMap map = obj.maps.get(m);
                    map.bindBuffers(this.scene);
                    Texture tex = null;
                    if (map.textureIndex != -1 && map.texloaded) {
                        tex = this.scene.tl.get(mod.getTexture(map.textureIndex));
                        if (tex != null && tex.loaded) {
                            tex.bind();
                        } else {
                            tex = null;
                        }
                    }
                    if (tex != null) continue;
                    System.out.println("GLRender:Warning:using blank texture, missing texture?");
                    this.scene.blankTexture.bind();
                }
                obj.bindBuffers(this.scene);
                obj.render(this.scene);
            }
        }
        GL.glFlush();
    }

    public void cameraReset() {
        this.m_camera.setIdentity();
    }

    public void cameraSet(float angle, float ax, float ay, float az, float tx, float ty, float tz) {
        this.m_camera.setAATranslate(angle, ax, ay, az, tx, ty, tz);
    }

    public void cameraRotate(float angle, float ax, float ay, float az) {
        this.m_camera.addRotate(angle, ax, ay, az);
    }

    public void cameraTranslate(float tx, float ty, float tz) {
        this.m_camera.addTranslate(tx, ty, tz);
    }

    public void modelReset() {
        this.m_model.setIdentity();
    }

    public void modelTranslate(float tx, float ty, float tz) {
        this.m_model.addTranslate(tx, ty, tz);
    }
}

