/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.util.Random;
import javaforce.BE;
import javaforce.awt.JFAWT;
import javaforce.awt.JFImage;
import javaforce.awt.ViewLog;
import javaforce.jbus.JBusClient;
import javaforce.service.DHCPServer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class DHCPApp
extends JFrame {
    private JTextArea config;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton save;
    private JButton viewLog;
    public ViewLog viewer;
    public JBusClient busClient;

    public DHCPApp() {
        this.initComponents();
        JFImage img = new JFImage();
        img.loadPNG(this.getClass().getResourceAsStream("/javaforce/icons/dhcp.png"));
        new Thread(){

            @Override
            public void run() {
                Random r = new Random();
                DHCPApp.this.busClient = new JBusClient("net.sf.jfdhcp.client" + r.nextInt(), new JBusMethods());
                DHCPApp.this.busClient.setPort(DHCPServer.getBusPort());
                DHCPApp.this.busClient.start();
                DHCPApp.this.busClient.call("net.sf.jfdhcp", "getConfig", "\"" + DHCPApp.this.busClient.pack + "\"");
            }
        }.start();
        JFAWT.centerWindow(this);
    }

    public void writeConfig() {
        this.busClient.call("net.sf.jfdhcp", "setConfig", JBusClient.quote(JBusClient.encodeString(this.config.getText())));
    }

    public void restart() {
        this.busClient.call("net.sf.jfdhcp", "restart", "");
    }

    private void initComponents() {
        this.save = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.config = new JTextArea();
        this.jLabel1 = new JLabel();
        this.viewLog = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("DHCP Server");
        this.save.setText("Save");
        this.save.setEnabled(false);
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DHCPApp.this.saveActionPerformed(evt);
            }
        });
        this.config.setColumns(20);
        this.config.setRows(5);
        this.config.setText(" [ loading ... ]");
        this.config.setEnabled(false);
        this.jScrollPane1.setViewportView(this.config);
        this.jLabel1.setText("DHCP Configuration:");
        this.viewLog.setText("View Log");
        this.viewLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DHCPApp.this.viewLogActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 583, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.viewLog).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.save)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 424, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.save).addComponent(this.viewLog)).addContainerGap()));
        this.pack();
    }

    private void saveActionPerformed(ActionEvent evt) {
        this.writeConfig();
        this.restart();
        JFAWT.showMessage("Notice", "Settings saved!");
    }

    private void viewLogActionPerformed(ActionEvent evt) {
        this.showViewLog();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DHCPApp().setVisible(true);
            }
        });
    }

    public void showViewLog() {
        if (this.viewer == null || this.viewer.isClosed) {
            this.viewer = new ViewLog(DHCPServer.getLogFile());
            this.viewer.setTitle("DHCP Log");
        }
        this.viewer.setVisible(true);
    }

    private void test() {
        try {
            DatagramSocket s = new DatagramSocket(68);
            byte[] d = new byte[242];
            d[0] = 1;
            d[1] = 1;
            d[2] = 6;
            d[3] = 0;
            BE.setuint16(d, 4, 305402420);
            BE.setuint16(d, 234, 305402420);
            d[238] = 53;
            d[239] = 1;
            d[240] = 1;
            d[241] = -1;
            DatagramPacket p = new DatagramPacket(d, d.length);
            p.setAddress(Inet4Address.getByName("255.255.255.255"));
            p.setPort(67);
            s.send(p);
            d = new byte[1024];
            p = new DatagramPacket(d, d.length);
            s.receive(p);
            JFAWT.showMessage("IP", DHCPServer.IP4toString(d, 16));
            s.close();
        }
        catch (Exception e) {
            JFAWT.showError("Error", e.toString());
        }
    }

    public class JBusMethods {
        public void getConfig(String cfg) {
            final String _cfg = cfg;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DHCPApp.this.config.setText(JBusClient.decodeString(_cfg));
                    DHCPApp.this.config.setEnabled(true);
                    DHCPApp.this.save.setEnabled(true);
                }
            });
        }
    }
}

