/*
 * Decompiled with CFR 0.152.
 */
package javaforce.net;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import javaforce.JF;
import javaforce.KeyMgmt;

public class WebRelay {
    private static String host;
    private static int port;
    private static boolean secure;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: WebRelay URL");
            System.exit(0);
        }
        String url = args[0];
        System.out.println("WebRelay to " + url);
        if (url.startsWith("https://")) {
            url = url.substring(8);
            port = 443;
            secure = true;
        } else if (url.startsWith("http://")) {
            url = url.substring(7);
            port = 80;
            secure = false;
        } else {
            System.out.println("Unknown protocol");
            System.exit(0);
        }
        JF.initHttps(KeyMgmt.getDefaultClient());
        int idx = url.indexOf(58);
        if (idx == -1) {
            host = url;
        } else {
            host = url.substring(0, idx);
            port = JF.atoi(url.substring(idx + 1));
        }
        try {
            ServerSocket ss = new ServerSocket(80);
            while (true) {
                System.out.println("Waiting for request");
                Socket s = ss.accept();
                Worker w = new Worker(s);
                w.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
    }

    static {
        port = 80;
    }

    private static class Worker
    extends Thread {
        private Socket s;
        private InputStream is;
        private OutputStream os;
        private Socket web;
        private InputStream webis;
        private OutputStream webos;
        private byte[] buf = new byte[1024];
        private int pos;
        private int len;
        private int avail;
        private String[] lns;
        private String encoding;

        public Worker(Socket s) {
            this.s = s;
        }

        @Override
        public void run() {
            try {
                this.is = this.s.getInputStream();
                this.os = this.s.getOutputStream();
                while (true) {
                    this.len = 0;
                    this.pos = 0;
                    this.avail = this.buf.length;
                    System.out.println("reading request headers");
                    do {
                        int read;
                        if (this.avail < 512) {
                            this.grow();
                        }
                        if ((read = this.is.read(this.buf, this.pos, this.avail)) == -1) break;
                        this.pos += read;
                        this.len += read;
                        this.avail -= read;
                        String req = new String(this.buf, 0, this.len);
                        this.lns = req.split("\r\n", -1);
                    } while (!this.lns[this.lns.length - 1].equals(""));
                    StringBuilder webreq = new StringBuilder();
                    for (String ln : this.lns) {
                        System.out.println("REQ:" + ln);
                        if (ln.contains("localhost")) {
                            ln = ln.replaceAll("localhost", host);
                        }
                        webreq.append(ln);
                        webreq.append("\r\n");
                    }
                    System.out.println("connecting to:" + host + ":" + port);
                    this.web = new Socket(host, port);
                    if (secure) {
                        System.out.println("securing connection");
                        this.web = JF.connectSSL(this.web, KeyMgmt.getDefaultClient());
                    }
                    this.webis = this.web.getInputStream();
                    this.webos = this.web.getOutputStream();
                    System.out.println("write to web:" + webreq.length());
                    byte[] webreqbin = webreq.toString().getBytes();
                    this.webos.write(webreqbin);
                    this.webos.flush();
                    this.len = 0;
                    this.pos = 0;
                    this.avail = this.buf.length;
                    System.out.println("reading web headers");
                    do {
                        int read;
                        if (this.avail < 512) {
                            this.grow();
                        }
                        if ((read = this.webis.read(this.buf, this.pos, this.avail)) == -1) break;
                        this.pos += read;
                        this.len += read;
                        this.avail -= read;
                        String req = new String(this.buf, 0, this.len);
                        this.lns = req.split("\r\n", -1);
                    } while (!this.lns[this.lns.length - 1].equals(""));
                    int contentLength = -1;
                    this.encoding = "";
                    block14: for (String ln : this.lns) {
                        System.out.println("WEB:" + ln);
                        int idx = ln.indexOf(58);
                        if (idx == -1) continue;
                        String key = ln.substring(0, idx).trim();
                        String value = ln.substring(idx + 1).trim();
                        String[] values = value.split(";", -1);
                        switch (key) {
                            case "Content-Length": {
                                contentLength = JF.atoi(values[0].trim());
                                continue block14;
                            }
                            case "Transfer-Encoding": {
                                this.encoding = value;
                            }
                        }
                    }
                    System.out.println("content-length=" + contentLength);
                    this.os.write(this.buf, 0, this.len);
                    if (this.encoding.contains("chunked")) {
                        System.out.println("TODO:chunked content");
                    }
                    if (contentLength <= 0) continue;
                    this.len = 0;
                    this.pos = 0;
                    this.avail = this.buf.length;
                    System.out.println("reading web content");
                    do {
                        int read;
                        if (this.avail < 512) {
                            this.grow();
                        }
                        if ((read = this.webis.read(this.buf, this.pos, this.avail)) == -1) break;
                        this.pos += read;
                        this.len += read;
                        this.avail -= read;
                    } while (this.len < contentLength);
                    System.out.println("OUT:" + new String(this.buf, 0, contentLength, "ISO-8859-1"));
                    System.out.println("OUT:" + Worker.hexToString(Arrays.copyOfRange(this.buf, 0, contentLength)));
                    this.os.write(this.buf, 0, contentLength);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }

        public void grow() {
            this.buf = Arrays.copyOf(this.buf, this.buf.length << 1);
            this.avail = this.buf.length - this.len;
        }

        public static String hexToString(byte[] hex) {
            StringBuilder str = new StringBuilder();
            for (int a = 0; a < hex.length; ++a) {
                if (a > 0) {
                    str.append(",");
                }
                str.append(String.format("%02x", hex[a] & 0xFF));
            }
            return str.toString();
        }
    }
}

