/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.utils.BuildTools;
import javaforce.utils.GenPkgInfo;

public class GenRPM {
    private BuildTools tools;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage:GenRPM build.xml");
            System.exit(1);
        }
        try {
            new GenRPM().run(args[0]);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void run(String buildfile) throws Exception {
        this.tools = new BuildTools();
        if (!this.tools.loadXML(buildfile)) {
            throw new Exception("error loading " + buildfile);
        }
        String files = "files.lst";
        if (new File("files-fedora.lst").exists()) {
            files = "files-fedora.lst";
        }
        if (!BuildTools.checkFiles(files)) {
            System.exit(1);
        }
        String arch = GenRPM.getArch();
        String archext = GenRPM.getArchExt();
        String app = this.tools.getProperty("app");
        Object apptype = this.tools.getProperty("apptype");
        String version = this.tools.getProperty("version");
        String home = this.tools.getProperty("home");
        switch (apptype) {
            case "client": 
            case "server": {
                apptype = "-" + (String)apptype;
                break;
            }
            default: {
                apptype = "";
            }
        }
        String out = app + (String)apptype + "-" + version + "-1." + archext + ".rpm";
        String data = "data.tar.bz2";
        String tmpdir = "/tmp/jfrpm.tmp";
        Runtime rt = Runtime.getRuntime();
        boolean debug = System.getenv("DEBUG") != null;
        try {
            GenPkgInfo.main(new String[]{"fedora", arch, files});
            JF.copyAllAppend(files, "rpm.spec");
            if (new File(data).exists()) {
                new File(data).delete();
            }
            rt.exec(new String[]{"tar", "cjf", data, "-T", files}).waitFor();
            if (new File(out).exists()) {
                new File(out).delete();
            }
            new File(tmpdir).mkdir();
            rt.exec(new String[]{"tar", "xjf", data, "-C", tmpdir}).waitFor();
            new File(data).delete();
            Process p = rt.exec(new String[]{"rpmbuild", "-bb", "rpm.spec", "--buildroot", tmpdir});
            p.waitFor();
            if (debug) {
                System.out.println(new String(JF.readAll(p.getInputStream())));
            }
            if (!debug) {
                JF.deletePathEx(tmpdir);
                new File("rpm.spec").delete();
            }
            rt.exec(new String[]{"mv", JF.getUserPath() + "/rpmbuild/RPMS/" + archext + "/" + out, "."}).waitFor();
            System.out.println(out + " created!");
            if (new File(home + "/repo/fedora/readme.txt").exists() && !JF.moveFile(out, home + "/repo/fedora/" + archext + "/" + out)) {
                throw new Exception("move failed");
            }
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static String getArch() {
        String arch = System.getenv("HOSTTYPE");
        if (arch == null && (arch = System.getProperty("os.arch")) == null) {
            JFLog.log("Error:Unable to detect CPU from env:HOSTTYPE or property:os.arch");
        }
        switch (arch) {
            case "amd64": {
                return "x86_64";
            }
            case "arm64": {
                return "aarch64";
            }
        }
        return arch;
    }

    public static String getArchExt() {
        return GenRPM.getArch();
    }
}

