/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.FileInputStream;
import javaforce.JF;
import javaforce.jni.WinNative;

public class WinPE {
    private static final int RT_ICON = 3;
    private static final int RT_GROUP_ICON = 14;
    private static final int RT_STRING = 6;
    private static final int RT_RCDATA = 10;
    private static final int RT_MANIFEST = 24;

    public static void usage() {
        System.out.println("WinPE : Add resources to Windows EXE PE files");
        System.out.println("Usage : WinPE exeFile file(s)");
        System.out.println("Supported : .ico .manifest .cfg");
        System.exit(0);
    }

    public static void main(String[] args) {
        if (!JF.isWindows()) {
            System.out.println("For windows only");
            return;
        }
        if (args == null || args.length < 2) {
            WinPE.usage();
        }
        String exeFile = args[0];
        for (int a = 1; a < args.length; ++a) {
            String file = args[a];
            if (file.endsWith(".ico")) {
                WinPE.addIcon(exeFile, file);
                continue;
            }
            if (file.endsWith(".manifest")) {
                WinPE.addManifest(exeFile, file);
                continue;
            }
            if (file.endsWith(".cfg")) {
                WinPE.addCfg(exeFile, file);
                continue;
            }
            System.out.println("Unsupported file:" + file);
        }
    }

    public static void addIcon(String exeFile, String icoFile) {
        try {
            FileInputStream fis = new FileInputStream(icoFile);
            byte[] ico = JF.readAll(fis);
            fis.close();
            long exe = WinNative.peBegin(exeFile);
            if (exe == 0L) {
                System.out.println("Unable to open:" + exeFile);
                return;
            }
            WinNative.peAddIcon(exe, ico);
            WinNative.peEnd(exe);
            System.out.println("Added:" + icoFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addManifest(String exeFile, String manifestFile) {
        try {
            FileInputStream fis = new FileInputStream(manifestFile);
            byte[] str = JF.readAll(fis);
            fis.close();
            long exe = WinNative.peBegin(exeFile);
            if (exe == 0L) {
                System.out.println("Unable to open:" + exeFile);
                return;
            }
            WinNative.peAddString(exe, 24, 1, str);
            WinNative.peEnd(exe);
            System.out.println("Added:" + manifestFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addCfg(String exeFile, String cfgFile) {
        try {
            FileInputStream fis = new FileInputStream(cfgFile);
            byte[] str = JF.readAll(fis);
            fis.close();
            long exe = WinNative.peBegin(exeFile);
            if (exe == 0L) {
                System.out.println("Unable to open:" + exeFile);
                return;
            }
            WinNative.peAddString(exe, 10, 1, str);
            WinNative.peEnd(exe);
            System.out.println("Added:" + cfgFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

