/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import javaforce.LE;

public class BE {
    public static int getuint8(byte[] data, int offset) {
        return data[offset] & 0xFF;
    }

    public static int getuint16(byte[] data, int offset) {
        int ret = (data[offset] & 0xFF) << 8;
        return ret += data[offset + 1] & 0xFF;
    }

    public static int getuint24(byte[] data, int offset) {
        int ret = (data[offset] & 0xFF) << 16;
        ret += (data[offset + 1] & 0xFF) << 8;
        return ret += data[offset + 2] & 0xFF;
    }

    public static int getuint32(byte[] data, int offset) {
        int ret = (data[offset] & 0xFF) << 24;
        ret += (data[offset + 1] & 0xFF) << 16;
        ret += (data[offset + 2] & 0xFF) << 8;
        return ret += data[offset + 3] & 0xFF;
    }

    public static long getuint64(byte[] data, int offset) {
        long ret = ((long)data[offset] & 0xFFL) << 56;
        ret += ((long)data[offset + 1] & 0xFFL) << 48;
        ret += ((long)data[offset + 2] & 0xFFL) << 40;
        ret += ((long)data[offset + 3] & 0xFFL) << 32;
        ret += ((long)data[offset + 4] & 0xFFL) << 24;
        ret += ((long)data[offset + 5] & 0xFFL) << 16;
        ret += ((long)data[offset + 6] & 0xFFL) << 8;
        return ret += (long)data[offset + 7] & 0xFFL;
    }

    public static void setuint8(byte[] data, int offset, int value) {
        data[offset + 0] = (byte)(value & 0xFF);
    }

    public static void setuint16(byte[] data, int offset, int value) {
        data[offset + 1] = (byte)(value & 0xFF);
        data[offset + 0] = (byte)((value >>= 8) & 0xFF);
    }

    public static void setuint24(byte[] data, int offset, int value) {
        data[offset + 2] = (byte)(value & 0xFF);
        data[offset + 1] = (byte)((value >>= 8) & 0xFF);
        data[offset + 0] = (byte)((value >>= 8) & 0xFF);
    }

    public static void setuint32(byte[] data, int offset, int value) {
        data[offset + 3] = (byte)(value & 0xFF);
        data[offset + 2] = (byte)((value >>= 8) & 0xFF);
        data[offset + 1] = (byte)((value >>= 8) & 0xFF);
        data[offset + 0] = (byte)((value >>= 8) & 0xFF);
    }

    public static void setuint64(byte[] data, int offset, long value) {
        data[offset + 7] = (byte)(value & 0xFFL);
        data[offset + 6] = (byte)((value >>= 8) & 0xFFL);
        data[offset + 5] = (byte)((value >>= 8) & 0xFFL);
        data[offset + 4] = (byte)((value >>= 8) & 0xFFL);
        data[offset + 3] = (byte)((value >>= 8) & 0xFFL);
        data[offset + 2] = (byte)((value >>= 8) & 0xFFL);
        data[offset + 1] = (byte)((value >>= 8) & 0xFFL);
        data[offset + 0] = (byte)((value >>= 8) & 0xFFL);
    }

    public static String getString(byte[] data, int offset, int len) {
        return LE.getString(data, offset, len);
    }

    public static void setString(byte[] data, int offset, int len, String str) {
        LE.setString(data, offset, len, str);
    }

    public static short[] byteArray2shortArray(byte[] in, short[] out) {
        int len = in.length / 2;
        if (out == null) {
            out = new short[len];
        }
        int p = 0;
        for (int a = 0; a < len; ++a) {
            short val = (short)(((short)in[p++] & 0xFF) << 8);
            out[a] = val = (short)(val + ((short)in[p++] & 0xFF));
        }
        return out;
    }

    public static int[] byteArray2intArray(byte[] in, int[] out) {
        int len = in.length / 4;
        if (out == null) {
            out = new int[len];
        }
        int p = 0;
        for (int a = 0; a < len; ++a) {
            int val = (in[p++] & 0xFF) << 24;
            val += (in[p++] & 0xFF) << 16;
            val += (in[p++] & 0xFF) << 8;
            out[a] = val += in[p++] & 0xFF;
        }
        return out;
    }

    public static byte[] shortArray2byteArray(short[] in, byte[] out) {
        int len = in.length;
        if (out == null) {
            out = new byte[len * 2];
        }
        int p = 0;
        for (int a = 0; a < len; ++a) {
            short val = in[a];
            out[p++] = (byte)((val & 0xFF00) >>> 8);
            out[p++] = (byte)(val & 0xFF);
        }
        return out;
    }

    public static byte[] intArray2byteArray(int[] in, byte[] out) {
        int len = in.length;
        if (out == null) {
            out = new byte[len * 4];
        }
        int p = 0;
        for (int a = 0; a < len; ++a) {
            int val = in[a];
            out[p++] = (byte)((val & 0xFF000000) >>> 8);
            out[p++] = (byte)((val & 0xFF0000) >> 8);
            out[p++] = (byte)((val & 0xFF00) >> 8);
            out[p++] = (byte)(val & 0xFF);
        }
        return out;
    }
}

