/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javaforce.MQTT;
import javaforce.MQTTEvents;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class MQTTViewer
extends JFrame
implements MQTTEvents {
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JTextArea msgs;
    private JTextField server;
    private JButton start;
    private JTextField topic;
    private MQTT client;
    private static String server_init;

    public MQTTViewer() {
        this.initComponents();
        if (server_init != null) {
            this.server.setText(server_init);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.server = new JTextField();
        this.jLabel2 = new JLabel();
        this.topic = new JTextField();
        this.start = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.msgs = new JTextArea();
        this.setDefaultCloseOperation(3);
        this.setTitle("MQTT Viewer");
        this.jLabel1.setText("Server");
        this.server.setText("127.0.0.1");
        this.jLabel2.setText("Topic");
        this.topic.setText("*");
        this.start.setText("Start");
        this.start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MQTTViewer.this.startActionPerformed(evt);
            }
        });
        this.msgs.setColumns(20);
        this.msgs.setRows(5);
        this.jScrollPane1.setViewportView(this.msgs);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 788, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.topic)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.server).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.start))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.server, -2, -1, -2).addComponent(this.start)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.topic, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 612, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void startActionPerformed(ActionEvent evt) {
        this.start();
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            server_init = args[0];
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MQTTViewer().setVisible(true);
            }
        });
    }

    @Override
    public boolean message(String topic, String msg) {
        String ln = topic + "=" + msg + "\r\n";
        this.msgs.setText(this.msgs.getText() + ln);
        return true;
    }

    public void start() {
        if (this.client == null) {
            this.start_new();
        } else {
            this.stop();
        }
    }

    public void start_new() {
        String _server = this.server.getText();
        String _topic = this.topic.getText();
        this.msgs.setText("Connecting to " + _server + "...");
        this.client = new MQTT();
        if (!this.client.connect(_server)) {
            this.msgs.setText("Connection failed!");
            this.client = null;
        }
        this.client.connect();
        this.msgs.setText("Connected to " + _server + "\r\n");
        this.client.setListener(this);
        this.client.subscribe(_topic);
        this.start.setText("Stop");
        this.server.setEditable(false);
        this.topic.setEditable(false);
    }

    public void stop() {
        this.client.disconnect();
        this.client = null;
        this.start.setText("Start");
        this.server.setEditable(true);
        this.topic.setEditable(true);
    }
}

