/*
 * Decompiled with CFR 0.152.
 */
package javaforce.gl.model;

import java.io.File;
import javaforce.JFLog;
import javaforce.gl.Model;
import javaforce.gl.model.GL_3DS;
import javaforce.gl.model.GL_BLEND;
import javaforce.gl.model.GL_JF3D;

public class Convert {
    public static void usage() {
        System.out.println("Desc : Convert");
        System.out.println("  Usage : infile outfile");
        System.out.println("  Usage : infolder outfolder");
        System.out.println("In formats: .3ds .blend");
        System.out.println("Out format: .jf3d");
        System.exit(0);
    }

    public static void main(String[] args) {
        if (args == null || args.length != 2) {
            Convert.usage();
        }
        String in = args[0];
        String out = args[1];
        File inf = new File(in);
        File outf = new File(out);
        if (inf.isDirectory() && inf.isDirectory()) {
            Convert.doFolder(in, out);
        } else {
            if (inf.isDirectory() || outf.isDirectory()) {
                Convert.usage();
            }
            Convert.doFile(in, out);
        }
    }

    private static void doFile(String in, String out) {
        File inf = new File(in);
        File outf = new File(out);
        if (outf.exists()) {
            long inTime = inf.lastModified();
            long outTime = outf.lastModified();
            if (outTime >= inTime) {
                System.out.println(out + " is up-to-date");
                return;
            }
        }
        Model model = null;
        if (in.toLowerCase().endsWith(".3ds")) {
            GL_3DS _3ds = new GL_3DS();
            model = _3ds.load(in);
        } else if (in.toLowerCase().endsWith(".blend")) {
            GL_BLEND blend = new GL_BLEND();
            model = blend.load(in);
        } else {
            Convert.usage();
        }
        if (model == null) {
            JFLog.log("ModelConvert:Error:Load mesh failed:" + in);
            return;
        }
        GL_JF3D jf3d = new GL_JF3D();
        jf3d.save(model, out);
        System.out.println("Converted " + in + " to " + out);
    }

    private static void doFolder(String in, String out) {
        File[] ins = new File(in).listFiles();
        for (int a = 0; a < ins.length; ++a) {
            File f = ins[a];
            if (f.isDirectory() || !f.getName().endsWith(".blend")) continue;
            String _in = f.getAbsolutePath();
            String fn = f.getName();
            String _out = out + "/" + fn.substring(0, fn.length() - 6) + ".jf3d";
            Convert.doFile(_in, _out);
        }
    }
}

