/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javaforce.BE;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.MQTTEvents;

public class MQTTServer
extends Thread {
    private static MQTTServer service;
    private boolean server_active;
    private Object lock = new Object();
    private HashMap<String, Topic> topics = new HashMap();
    private MQTTEvents events;
    private ServerSocket ss;
    private static int bufsiz;
    public static boolean debug;
    public static boolean debug_msg;
    public static final byte CMD_CONNECT = 1;
    public static final byte CMD_CONNECT_ACK = 2;
    public static final byte CMD_PUBLISH = 3;
    public static final byte CMD_PUBLISH_ACK = 4;
    public static final byte CMD_PUBLISH_REC = 5;
    public static final byte CMD_PUBLISH_REL = 6;
    public static final byte CMD_PUBLISH_CMP = 7;
    public static final byte CMD_SUBSCRIBE = 8;
    public static final byte CMD_SUBSCRIBE_ACK = 9;
    public static final byte CMD_UNSUBSCRIBE = 10;
    public static final byte CMD_UNSUBSCRIBE_ACK = 11;
    public static final byte CMD_PING = 12;
    public static final byte CMD_PONG = 13;
    public static final byte CMD_DISCONNECT = 14;
    public static final byte QOS_0 = 0;
    public static final byte QOS_1 = 1;
    public static final byte QOS_2 = 2;
    public static final byte QOS_3 = 3;
    public static final byte FLAG_CLEAN_START = 2;
    public static final byte FLAG_PASS = 64;
    public static final byte FLAG_USER = -128;
    public static Worker[] WorkerArrayType;

    public static void serviceStart(String[] args) {
        service = new MQTTServer();
        service.start();
        String[] stringArray = args;
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String arg;
            switch (arg = stringArray[i]) {
                case "debug": {
                    debug = true;
                    continue block8;
                }
                case "debug_msg": {
                    debug_msg = true;
                }
            }
        }
    }

    public static void serviceStop() {
        if (service != null) {
            service.cancel();
            service = null;
        }
    }

    public void setListener(MQTTEvents events) {
        this.events = events;
    }

    public void cancel() {
        this.server_active = false;
        if (this.ss != null) {
            try {
                this.ss.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ss = null;
        }
    }

    @Override
    public void run() {
        this.server_active = true;
        JFLog.append(JF.getLogPath() + "/jfmqtt.log", true);
        JFLog.log("MQTTServer starting on port 1883...");
        try {
            this.ss = new ServerSocket(1883);
            while (this.server_active) {
                Socket s = this.ss.accept();
                Worker worker = new Worker(s);
                worker.start();
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Topic getTopic(String name) {
        Object object = this.lock;
        synchronized (object) {
            Topic topic = this.topics.get(name);
            if (topic != null) {
                return topic;
            }
            topic = new Topic(name);
            this.topics.put(name, topic);
            return topic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Topic[] getTopics(String wc) {
        ArrayList<Topic> topics_sub = new ArrayList<Topic>();
        Object object = this.lock;
        synchronized (object) {
            for (Topic topic : this.topics.values().toArray(Topic.TopicArrayType)) {
                if (!topic.matches(wc)) continue;
                topics_sub.add(topic);
            }
        }
        return topics_sub.toArray(Topic.TopicArrayType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubscribeAll(Worker worker) {
        Object object = this.lock;
        synchronized (object) {
            Topic[] alltopics;
            for (Topic topic : alltopics = this.topics.values().toArray(Topic.TopicArrayType)) {
                topic.unsubscribe(worker);
            }
        }
    }

    private int getLength(byte[] data, int pos, int length) {
        int next;
        int multi = 1;
        int value = 0;
        do {
            if (pos >= length) {
                return -1;
            }
            next = data[pos++] & 0xFF;
            value += (next & 0x7F) * multi;
            multi *= 128;
        } while (next >= 128);
        return value;
    }

    private int getStringLength(byte[] data, int topicPosition) {
        return BE.getuint16(data, topicPosition);
    }

    private short getPacketID(byte[] data, int idPosition) {
        return (short)BE.getuint16(data, idPosition);
    }

    private void setPacketLength(byte[] packet) {
        int value = packet.length - 2;
        int pos = 1;
        do {
            byte ebyte = (byte)(value % 128);
            if ((value /= 128) > 0) {
                ebyte = (byte)(ebyte | 0x80);
            }
            packet[pos++] = ebyte;
        } while (value > 0);
    }

    private void setPacketID(byte[] data, int offset, short id) {
        BE.setuint16(data, offset, id);
    }

    private int getLengthBytes(int length) {
        if (length <= 127) {
            return 1;
        }
        if (length <= 1023) {
            return 2;
        }
        if (length <= 0x1FFFFF) {
            return 3;
        }
        if (length <= 0xFFFFFFF) {
            return 4;
        }
        return -1;
    }

    static {
        bufsiz = 4096;
        debug = false;
        debug_msg = false;
        WorkerArrayType = new Worker[0];
    }

    private class Worker
    extends Thread {
        public Socket s;
        public InputStream is;
        public OutputStream os;
        public String ip;
        public boolean active = true;

        public Worker(Socket s) {
            this.s = s;
        }

        @Override
        public void run() {
            try {
                this.is = this.s.getInputStream();
                this.os = this.s.getOutputStream();
                this.ip = this.s.getInetAddress().getHostAddress();
                if (debug) {
                    JFLog.log("connect:" + this.ip);
                }
                byte[] buf = new byte[bufsiz];
                block5: while (MQTTServer.this.server_active && this.active) {
                    int totalRead = 0;
                    int packetLength = -1;
                    int totalLength = -1;
                    Arrays.fill(buf, (byte)0);
                    while (MQTTServer.this.server_active && this.active) {
                        int read = packetLength == -1 ? this.is.read(buf, totalRead, 1) : this.is.read(buf, totalRead, totalLength - totalRead);
                        if (debug) {
                            JFLog.log("read=" + read);
                        }
                        if (read == -1) {
                            throw new Exception("bad read");
                        }
                        if ((totalRead += read) < 2) continue;
                        if (packetLength == -1 && (packetLength = MQTTServer.this.getLength(buf, 1, totalRead)) != -1) {
                            totalLength = 1 + MQTTServer.this.getLengthBytes(packetLength) + packetLength;
                            if (debug) {
                                JFLog.log("totalLength=" + totalLength);
                            }
                        }
                        if (packetLength == -1 || totalRead < totalLength) continue;
                        try {
                            this.process(buf, totalLength, packetLength);
                        }
                        catch (Exception e) {
                            JFLog.log(e);
                        }
                        continue block5;
                    }
                }
            }
            catch (SocketException buf) {
            }
            catch (Exception e) {
                JFLog.log(e);
            }
            MQTTServer.this.unsubscribeAll(this);
            if (debug) {
                JFLog.log("disconnect:" + this.ip);
            }
        }

        private void process(byte[] packet, int totalLength, int packetLength) throws Exception {
            byte[] reply = null;
            byte cmd = (byte)((packet[0] & 0xF0) >> 4);
            short id = 0;
            int pos = 1;
            if (debug) {
                JFLog.log("cmd=" + cmd);
            }
            switch (cmd) {
                case 1: {
                    reply = new byte[5];
                    reply[0] = 32;
                    MQTTServer.this.setPacketLength(reply);
                    break;
                }
                case 3: {
                    int props_length;
                    boolean retain;
                    boolean dup = (packet[0] & 8) != 0;
                    byte qos = (byte)((packet[0] & 6) >> 1);
                    boolean bl = retain = (packet[0] & 1) != 0;
                    if (qos == 3) {
                        throw new Exception("malformed packet");
                    }
                    pos = 1 + MQTTServer.this.getLengthBytes(packetLength);
                    int topicLength = MQTTServer.this.getStringLength(packet, pos);
                    if (debug) {
                        JFLog.log("topic=" + pos + "/" + topicLength);
                    }
                    String topic_name = new String(packet, pos += 2, topicLength);
                    pos += topicLength;
                    if (qos > 0) {
                        id = MQTTServer.this.getPacketID(packet, pos);
                        if (debug) {
                            JFLog.log("id=" + id);
                        }
                        pos += 2;
                    }
                    if ((props_length = MQTTServer.this.getLength(packet, pos, totalLength)) == -1) {
                        throw new Exception("malformed packet");
                    }
                    int props_length_bytes = MQTTServer.this.getLengthBytes(props_length);
                    pos += props_length_bytes;
                    if (props_length > 0) {
                        pos += props_length_bytes;
                    }
                    int msgLength = totalLength - pos;
                    if (debug) {
                        JFLog.log("msg=" + pos + "/" + msgLength);
                    }
                    String msg = new String(packet, pos, msgLength);
                    if (debug_msg) {
                        JFLog.log("PUBLISH:" + this.ip + ":" + topic_name + ":" + msg + "!");
                    }
                    Topic topic = MQTTServer.this.getTopic(topic_name);
                    topic.publish(packet, totalLength, retain);
                    switch (qos) {
                        case 1: {
                            reply = new byte[4];
                            reply[0] = 64;
                            MQTTServer.this.setPacketLength(reply);
                            MQTTServer.this.setPacketID(reply, 2, id);
                            break;
                        }
                        case 2: {
                            reply = new byte[4];
                            reply[0] = 80;
                            MQTTServer.this.setPacketLength(reply);
                            MQTTServer.this.setPacketID(reply, 2, id);
                        }
                    }
                    if (MQTTServer.this.events == null) break;
                    MQTTServer.this.events.message(topic_name, msg);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    reply = new byte[4];
                    reply[0] = 112;
                    MQTTServer.this.setPacketLength(reply);
                    id = MQTTServer.this.getPacketID(packet, 2);
                    MQTTServer.this.setPacketID(reply, 2, id);
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    pos = 1 + MQTTServer.this.getLengthBytes(packetLength);
                    id = MQTTServer.this.getPacketID(packet, pos);
                    if (debug) {
                        JFLog.log("id=" + id);
                    }
                    int props_length = MQTTServer.this.getLength(packet, pos += 2, totalLength);
                    int props_length_bytes = MQTTServer.this.getLengthBytes(props_length);
                    pos += props_length_bytes;
                    if (props_length > 0) {
                        pos += props_length_bytes;
                    }
                    while (pos < totalLength) {
                        int topicLength = MQTTServer.this.getStringLength(packet, pos);
                        if (debug) {
                            JFLog.log("topic=" + pos + "/" + topicLength);
                        }
                        String topic_name = new String(packet, pos += 2, topicLength);
                        pos += topicLength;
                        if (JF.isWildcard(topic_name)) {
                            Topic[] topics;
                            for (Topic topic : topics = MQTTServer.this.getTopics(topic_name)) {
                                topic.subscribe(this);
                            }
                        } else {
                            Topic topic = MQTTServer.this.getTopic(topic_name);
                            topic.subscribe(this);
                        }
                        if (debug_msg) {
                            JFLog.log("SUBSCRIBE:" + this.ip + ":" + topic_name);
                        }
                        ++pos;
                    }
                    reply = new byte[5];
                    reply[0] = -112;
                    MQTTServer.this.setPacketLength(reply);
                    MQTTServer.this.setPacketID(reply, 2, id);
                    break;
                }
                case 10: {
                    pos = 1 + MQTTServer.this.getLengthBytes(packetLength);
                    id = MQTTServer.this.getPacketID(packet, pos);
                    if (debug) {
                        JFLog.log("id=" + id);
                    }
                    pos += 2;
                    while (pos < totalLength) {
                        int topicLength = MQTTServer.this.getStringLength(packet, pos);
                        pos += 2;
                        if (debug) {
                            JFLog.log("topic=" + pos + "/" + topicLength);
                        }
                        String topic_name = new String(packet, pos, topicLength);
                        pos += topicLength;
                        Topic topic = MQTTServer.this.getTopic(topic_name);
                        topic.unsubscribe(this);
                        if (!debug_msg) continue;
                        JFLog.log("UNSUB:" + this.ip + ":" + topic_name);
                    }
                    reply = new byte[5];
                    reply[0] = -80;
                    MQTTServer.this.setPacketLength(reply);
                    MQTTServer.this.setPacketID(reply, 2, id);
                    break;
                }
                case 12: {
                    reply = new byte[2];
                    reply[0] = -48;
                    if (!debug_msg) break;
                    JFLog.log("PING:" + this.ip);
                    break;
                }
                case 14: {
                    MQTTServer.this.unsubscribeAll(this);
                    this.active = false;
                }
            }
            if (reply != null) {
                this.send(reply);
            }
        }

        private void send(byte[] reply) throws Exception {
            this.os.write(reply);
        }

        public void publish(byte[] pkt, int length) throws Exception {
            this.os.write(pkt, 0, length);
        }
    }

    private static class Topic {
        private String name;
        private byte[] pkt;
        private int pkt_length;
        private ArrayList<Worker> subs = new ArrayList();
        private Object lock = new Object();
        public static Topic[] TopicArrayType = new Topic[0];

        public Topic(String name) {
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void publish(byte[] pkt, int length, boolean retain) {
            pkt[0] = (byte)(pkt[0] & 0xF6);
            if (retain) {
                this.pkt = (byte[])pkt.clone();
                this.pkt_length = length;
            }
            Object object = this.lock;
            synchronized (object) {
                for (Worker sub : this.subs.toArray(WorkerArrayType)) {
                    try {
                        sub.publish(pkt, length);
                    }
                    catch (Exception e) {
                        this.unsubscribe(sub);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscribe(Worker worker) {
            Object object = this.lock;
            synchronized (object) {
                this.subs.add(worker);
            }
            if (this.pkt != null) {
                try {
                    worker.publish(this.pkt, this.pkt_length);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unsubscribe(Worker worker) {
            Object object = this.lock;
            synchronized (object) {
                this.subs.remove(worker);
            }
        }

        public boolean matches(String wc) {
            return JF.wildcardCompare(this.name, wc, false);
        }
    }
}

