/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.RandomAccessFile;
import java.util.Random;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.media.AudioInput;
import javaforce.media.MediaCoder;
import javaforce.media.MediaDecoder;
import javaforce.media.MediaEncoder;
import javaforce.media.MediaIO;

public class TestMedia
implements MediaIO {
    public static int encoder_seconds = 4;
    public static String encoder_audio_src = "random";
    public RandomAccessFile raf;
    public long size;

    public static void usage() {
        System.out.println("TestMedia encoder | decoder");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            TestMedia.usage();
        }
        block16: for (int a = 0; a < args.length; ++a) {
            int idx = args[a].indexOf(61);
            if (idx != -1) {
                String key = args[a].substring(0, idx);
                String value = args[a].substring(idx + 1);
                switch (key) {
                    case "seconds": {
                        encoder_seconds = Integer.valueOf(value);
                        break;
                    }
                    case "audiosrc": {
                        encoder_audio_src = value;
                    }
                }
                continue;
            }
            switch (args[a]) {
                case "decoder": {
                    TestMedia.decoder();
                    continue block16;
                }
                case "encoder": {
                    TestMedia.encoder(true);
                    continue block16;
                }
                default: {
                    TestMedia.usage();
                }
            }
        }
    }

    public static void decoder() {
        TestMedia.encoder(false);
        while (true) {
            TestMedia media = new TestMedia();
            MediaDecoder decoder = new MediaDecoder();
            media.open("test-0.mp4");
            decoder.start(media, 640, 480, 2, 44100, true);
            boolean eof = false;
            int pkts = 0;
            block6: do {
                int type = decoder.read();
                ++pkts;
                switch (type) {
                    case 2: {
                        int[] px = decoder.getVideo();
                        if (px == null) continue block6;
                        System.out.println("video=" + px.length);
                        break;
                    }
                    case 1: {
                        short[] sams = decoder.getAudio();
                        if (sams == null) continue block6;
                        System.out.println("audio=" + sams.length);
                        break;
                    }
                    case -1: {
                        eof = true;
                    }
                }
            } while (!eof);
            System.out.println("packets=" + pkts);
            decoder.stop();
            media.close();
        }
    }

    public static void random(int[] px) {
        Random r = new Random();
        int len = px.length;
        for (int a = 0; a < len; ++a) {
            px[a] = r.nextInt() | 0xFF000000;
        }
    }

    public static void random(short[] sams) {
        Random r = new Random();
        int len = sams.length;
        for (int a = 0; a < len; ++a) {
            sams[a] = (short)(r.nextInt(65536) - 32768);
        }
    }

    public static void encoder(boolean loop) {
        TestMedia media = new TestMedia();
        int[] px = new int[307200];
        short[] sams = new short[7350];
        int i = 0;
        do {
            media.size = 0L;
            MediaEncoder encoder = new MediaEncoder();
            AudioInput input = new AudioInput();
            media.create(i++);
            if (i == 10) {
                i = 0;
            }
            encoder.start(media, 640, 480, 24, 2, 44100, "mp4", true, true);
            int frame_size = encoder.getAudioFramesize() * 2;
            JFLog.log("frame_size=" + frame_size);
            if (encoder_audio_src.equals("mic")) {
                input.start(2, 44100, 16, frame_size, "<default>");
            }
            System.out.println("Audio Frame Size=" + encoder.getAudioFramesize());
            for (int a = 0; a < 24 * encoder_seconds; ++a) {
                TestMedia.random(px);
                if (encoder_audio_src.equals("mic")) {
                    while (!input.read(sams)) {
                        JF.sleep(50);
                    }
                } else {
                    TestMedia.random(sams);
                }
                encoder.addVideo(px);
                encoder.addAudio(sams);
            }
            encoder.stop();
            media.close();
            if (encoder_audio_src.equals("mic")) {
                input.stop();
            }
            System.out.println("size=" + media.size);
            System.gc();
        } while (loop);
    }

    public void create(int i) {
        try {
            this.raf = new RandomAccessFile("test-" + i + ".mp4", "rw");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open(String filename) {
        try {
            this.raf = new RandomAccessFile(filename, "rw");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.raf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.raf = null;
    }

    @Override
    public int read(MediaCoder coder, byte[] data) {
        try {
            return this.raf.read(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public int write(MediaCoder coder, byte[] data) {
        try {
            this.size += (long)data.length;
            this.raf.write(data);
            return data.length;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public long seek(MediaCoder coder, long pos, int type) {
        try {
            switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    pos += this.raf.getFilePointer();
                    break;
                }
                case 2: {
                    pos += this.raf.length();
                }
            }
            this.raf.seek(pos);
            return pos;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

