package javaforce.utils;

/** Zip utility.
 *
 * @author pquiring
 */

import java.io.*;
import java.nio.file.Files;
import java.util.*;
import java.util.zip.*;

import javaforce.*;

public class Zip {
  public static void main(String[] args) {
    new Zip().run(args);
  }

  private String command;
  private String zip;
  private ArrayList<String> files = new ArrayList<>();

  private FileInputStream fis;
  private ZipInputStream zis;

  private FileOutputStream fos;
  private ZipOutputStream zos;

  public void run(String[] args) {
    for(int a=0;a<args.length;a++) {
      String arg = args[a];
      if (arg.startsWith("-")) {
        //option
      } else if (command == null) {
        command = arg;
      } else if (zip == null) {
        zip = arg;
      } else {
        files.add(arg);
      }
    }
    if (command == null || zip == null || files.size() == 0) {
      usage();
      System.exit(2);
    }
    try {
      switch (command) {
        case "a":
          add();
          break;
        case "e":
          extract();
          break;
        case "d":
          delete();
          break;
      }
    } catch (Exception e) {
      JFLog.log(e);
    }
  }

  public void usage() {
    System.out.println("Usage: jfzip command zip [options] <files...>");
    System.out.println("  command : a=add,e=extract,d=delete");
    System.out.println("  @file = files are listed in file");
  }

  private final int bufsiz = 64 * 1024;
  private byte[] buffer = new byte[bufsiz];

  private boolean addFile(String file) {
    ZipEntry entry = new ZipEntry(file);
    //TODO : setup entry fields
    try {
      zos.putNextEntry(entry);

      FileInputStream fis = new FileInputStream(file);
      long tocopy = file.length();
      long left = tocopy;
      while (left > 0) {
        int copy = (int)(left > bufsiz ? bufsiz : left);
        int read = fis.read(buffer, 0, copy);
        if (read == -1) throw new Exception("bad read");
        zos.write(buffer, 0, copy);
        left -= copy;
      }
      fis.close();
      zos.closeEntry();
      return true;
    } catch (Exception e) {
      JFLog.log(e);
      return false;
    }
  }

  private boolean add() throws Exception {
    if (new File(zip).exists()) {
      fis = new FileInputStream(zip);
      fos = new FileOutputStream(Files.createTempFile(zip, "-new").toFile());
      zis = new ZipInputStream(fis);
      zos = new ZipOutputStream(fos);
      //TODO : transfer existing files (unless they are to be replaced)
    } else {
      fos = new FileOutputStream(zip);
      zos = new ZipOutputStream(fos);
    }
    for(String file : files) {
      if (file.startsWith("@")) {
        //process list
        continue;
      }
      if (!addFile(file)) {
        return false;
      }
    }
    //TODO : delete old zip
    //TODO : rename new zip -> old zip
    return true;
  }

  private void extract() throws Exception  {
    //TODO
  }

  private void delete() throws Exception  {
    //TODO
  }
}
