/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import java.util.Random;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.awt.JFAWT;
import javaforce.awt.RFB;
import javaforce.awt.VNCJavaRobot;
import javaforce.awt.VNCRobot;
import javaforce.awt.VNCSessionServer;
import javaforce.jbus.JBusClient;
import javaforce.jbus.JBusServer;
import javaforce.jni.WinNative;
import javaforce.utils.WinService;

public class VNCServer {
    public static final String busPack = "net.sf.jfvnc";
    private Server server;
    private ServerSocket ss;
    private VNCSessionServer session_server;
    private JBusClient busClient;
    private boolean active;
    private boolean service_mode;
    private String pass;
    private static boolean debug = false;
    public static final boolean update_sid = false;
    private boolean[] keys = new boolean[256];
    private static VNCServer service;
    private static Config config;
    private static JBusServer busServer;

    private boolean start() {
        config = VNCServer.loadConfig();
        return this.start(VNCServer.config.password, VNCServer.config.port, true);
    }

    public boolean start(String pass) {
        return this.start(pass, 5900, false);
    }

    public boolean start(String pass, int port) {
        return this.start(pass, port, false);
    }

    private boolean start(String pass, int port, boolean service_mode) {
        if (this.active) {
            this.stop();
        }
        this.pass = RFB.checkPassword(pass);
        this.service_mode = service_mode;
        try {
            JFLog.log("VNCServer starting on port " + port + "...");
            this.active = true;
            this.ss = new ServerSocket(port);
            this.server = new Server();
            this.server.start();
            if (service_mode) {
                this.session_server = new VNCSessionServer();
                this.session_server.start();
            }
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public void stop() {
        this.active = false;
        try {
            if (this.ss != null) {
                this.ss.close();
                this.ss = null;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        if (this.session_server != null) {
            this.session_server.stop();
            this.session_server = null;
        }
        if (this.busClient != null) {
            this.busClient.close();
            this.busClient = null;
        }
    }

    private static Config loadConfig() {
        try {
            File file = new File(VNCServer.getConfigFile());
            FileInputStream fis = new FileInputStream(file);
            Properties props = new Properties();
            props.load(fis);
            fis.close();
            Config config = new Config(null);
            String password = props.getProperty("password");
            config.password = password != null ? RFB.checkPassword(password) : VNCServer.randomPassword();
            String port = props.getProperty("port");
            if (port != null) {
                config.port = JF.atoi(port);
                if (config.port < 0 || config.port > 65535) {
                    config.port = 5900;
                }
            }
            if (JF.isUnix()) {
                String display;
                String user = props.getProperty("user");
                if (user != null) {
                    config.user = user;
                }
                if ((display = props.getProperty("display")) != null) {
                    config.display = display;
                }
            }
            return config;
        }
        catch (FileNotFoundException e) {
            Config config = new Config(VNCServer.randomPassword());
            try {
                FileOutputStream fos = new FileOutputStream(VNCServer.getConfigFile());
                fos.write(config.toString().getBytes());
                fos.close();
            }
            catch (Exception e2) {
                JFLog.log(e2);
            }
            return config;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    private static String randomPassword() {
        byte[] cs = new byte[8];
        Random r = new Random();
        for (int a = 0; a < 8; ++a) {
            cs[a] = (byte)(r.nextInt(26) + 97);
        }
        return new String(cs);
    }

    private VNCRobot newSession() {
        if (debug) {
            JFLog.log("Starting new Session");
        }
        long token = -1L;
        if (JF.isWindows()) {
            if (debug) {
                JFLog.log("Session ID=" + WinNative.getSessionID());
            }
            token = WinNative.executeSession(System.getProperty("java.app.home") + "/jfvncsession.exe", new String[0]);
        } else {
            try {
                ProcessBuilder pb = new ProcessBuilder(new String[0]);
                pb.environment().put("DISPLAY", VNCServer.config.display);
                pb.environment().put("XAUTHORITY", "/home/" + this.getLinuxUser() + "/.Xauthority");
                pb.command(System.getProperty("java.app.home") + "/jfvncsession");
                pb.start();
            }
            catch (Exception e) {
                JFLog.log(e);
                return null;
            }
        }
        VNCSessionServer.Client robot = this.session_server.getClient();
        if (JF.isWindows()) {
            robot.token = token;
            robot.sid = -1;
            while (robot.sid == -1) {
                robot.sid = WinNative.getSessionID();
                JF.sleep(100);
            }
        }
        if (debug) {
            JFLog.log("robot=" + String.valueOf(robot));
        }
        return robot;
    }

    private String getLinuxUser() {
        if (VNCServer.config.user != null) {
            return VNCServer.config.user;
        }
        File[] users = new File("/home").listFiles();
        if (users == null || users.length == 0) {
            return "null";
        }
        return users[0].getName();
    }

    public static void serviceStart(String[] args) {
        JFLog.init(VNCServer.getLogFile(), true);
        service = new VNCServer();
        service.start();
        if (JF.isWindows()) {
            busServer = new JBusServer(VNCServer.getBusPort());
            busServer.start();
            while (true) {
                if (JBusServer.ready) break;
                JF.sleep(10);
            }
        }
    }

    public static void serviceStop() {
        service.stop();
        if (busServer != null) {
            busServer.close();
            busServer = null;
        }
    }

    public static int getBusPort() {
        if (JF.isWindows()) {
            return 33015;
        }
        return 777;
    }

    public static String getLogFile() {
        return JF.getLogPath() + "/jfvnc.log";
    }

    public static String getConfigFile() {
        return JF.getConfigPath() + "/jfvnc.cfg";
    }

    private static String getServiceFile() {
        return System.getProperty("user.dir") + "\\jfvncsvc.exe";
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            String usage = "";
            usage = JF.isWindows() ? "Usage:\nVNCServer {password} [port]\nVNCServer -install | -remove | -start | -stop" : "Usage:\nVNCServer {password} [port]";
            JFAWT.showError("Usage", usage);
            System.exit(1);
        }
        if (args[0].startsWith("-")) {
            String exe;
            if (!JF.isWindows()) {
                JFAWT.showError("Error", "Not supported");
                System.exit(1);
            }
            if (!new File(exe = VNCServer.getServiceFile()).exists()) {
                JFAWT.showError("Error", "Unable to find jfvncsvc.exe");
                System.exit(1);
            }
            switch (args[0]) {
                case "-install": {
                    WinService.create("jfVNCServer", exe);
                    break;
                }
                case "-remove": {
                    WinService.delete("jfVNCServer");
                    break;
                }
                case "-start": {
                    WinService.start("jfVNCServer");
                    break;
                }
                case "-stop": {
                    WinService.stop("jfVNCServer");
                    break;
                }
                default: {
                    JFAWT.showError("Error", "Unknown option:" + args[0]);
                    System.exit(1);
                    break;
                }
            }
        } else {
            JFLog.init("jfvnccli.log", true);
            String password = args[0];
            int port = 5900;
            if (args.length > 1 && ((port = JF.atoi(args[1])) < 0 || port > 65535)) {
                port = 5900;
            }
            VNCServer server = new VNCServer();
            server.start(password, port);
        }
    }

    private static class Config {
        public String password;
        public int port = 5900;
        public String user;
        public String display = ":0";

        public Config(String password) {
            this.password = password;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("port=" + this.port + "\n");
            sb.append("password=" + this.password + "\n");
            if (this.user != null) {
                sb.append("user=" + this.user + "\n");
            } else {
                sb.append("#user=username  #linux account with X11 authorization\n");
            }
            sb.append("display=" + this.display + "  #linux display name\n");
            return sb.toString();
        }
    }

    private class Server
    extends Thread {
        private Server() {
        }

        @Override
        public void run() {
            VNCServer.this.busClient = new JBusClient(VNCServer.busPack, new JBusMethods());
            VNCServer.this.busClient.setPort(VNCServer.getBusPort());
            VNCServer.this.busClient.start();
            while (VNCServer.this.active) {
                try {
                    VNCRobot robot;
                    Socket s = VNCServer.this.ss.accept();
                    if (VNCServer.this.service_mode) {
                        robot = VNCServer.this.newSession();
                    } else {
                        GraphicsEnvironment gfx = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        robot = new VNCJavaRobot(gfx.getDefaultScreenDevice());
                    }
                    if (robot == null) {
                        s.close();
                        continue;
                    }
                    Client client = new Client(s, robot);
                    client.start();
                }
                catch (Exception e) {
                    JFLog.log(e);
                }
            }
        }
    }

    public static class JBusMethods {
        public void getConfig(String pack) {
            byte[] cfg = JF.readFile(VNCServer.getConfigFile());
            if (cfg == null) {
                cfg = new byte[]{};
            }
            String config = new String(cfg);
            VNCServer.service.busClient.call(pack, "getConfig", JBusClient.quote(JBusClient.encodeString(config)));
        }

        public void setConfig(String cfg) {
            try {
                FileOutputStream fos = new FileOutputStream(VNCServer.getConfigFile());
                fos.write(JBusClient.decodeString(cfg).getBytes());
                fos.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void restart() {
            service.stop();
            service = new VNCServer();
            service.start();
        }
    }

    private class Client
    extends Thread {
        private Socket s;
        private RFB rfb;
        private Object lock = new Object();
        private VNCRobot robot;
        private Rectangle size;
        private Updater updater;
        private boolean connected;
        private int buttons;
        private int pf = RFB.PF_BGR;

        public Client(Socket s, VNCRobot robot) {
            this.s = s;
            this.robot = robot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.connected = true;
            try {
                this.rfb = new RFB();
                this.rfb.connect(this.s);
                this.rfb.writeVersion(RFB.VERSION_3_8);
                float ver = this.rfb.readVersion();
                this.rfb.writeAuthTypes();
                byte type = this.rfb.readAuthType();
                if (type != 2) {
                    throw new Exception("Auth failed");
                }
                byte[] challenge = this.rfb.writeAuthChallenge();
                byte[] response = RFB.encodeResponse(challenge, VNCServer.this.pass.getBytes());
                byte[] reply = this.rfb.readAuthChallenge();
                for (int a = 0; a < 16; ++a) {
                    if (response[a] == reply[a]) continue;
                    this.rfb.writeAuthResult(false);
                    throw new Exception("Auth Failed");
                }
                this.rfb.writeAuthResult(true);
                this.size = this.robot.getScreenSize();
                this.rfb.writeServerInit(this.size.width, this.size.height);
                this.rfb.readClientInit();
                this.updater = new Updater();
                this.updater.start();
                block25: while (VNCServer.this.active && this.connected) {
                    this.connected = this.rfb.isConnected();
                    int cmd = this.rfb.readMessageType();
                    Object object = this.lock;
                    synchronized (object) {
                        if (!this.robot.active()) {
                            this.robot.close();
                            this.robot = VNCServer.this.newSession();
                        }
                    }
                    switch (cmd) {
                        case 3: {
                            RFB.Rectangle rect = this.rfb.readBufferUpdateRequest();
                            this.updater.refresh(rect);
                            break;
                        }
                        case 5: {
                            Object event = this.rfb.readMouseEvent();
                            try {
                                Object object2 = this.lock;
                                synchronized (object2) {
                                    this.robot.mouseMove(((RFB.RFBMouseEvent)event).x, ((RFB.RFBMouseEvent)event).y);
                                    int mask = 1;
                                    for (int a = 0; a < 3; mask <<= 1, ++a) {
                                        if ((this.buttons & mask) == (((RFB.RFBMouseEvent)event).buttons & mask)) continue;
                                        if ((((RFB.RFBMouseEvent)event).buttons & mask) == 0) {
                                            this.robot.mouseRelease(VNCRobot.convertMouseButtons(mask));
                                            continue;
                                        }
                                        this.robot.mousePress(VNCRobot.convertMouseButtons(mask));
                                    }
                                }
                            }
                            catch (Exception e) {
                                JFLog.log(e);
                            }
                            this.buttons = ((RFB.RFBMouseEvent)event).buttons;
                            break;
                        }
                        case 4: {
                            Object event = this.rfb.readKeyEvent();
                            if (debug) {
                                JFLog.log("KeyEvent:" + (((RFB.RFBKeyEvent)event).down ? "down" : "up"));
                                JFLog.log("old.key=0x" + Integer.toString(((RFB.RFBKeyEvent)event).code, 16));
                            }
                            int code = VNCRobot.convertRFBKeyCode(((RFB.RFBKeyEvent)event).code);
                            if (debug) {
                                JFLog.log("new.key=0x" + Integer.toString(code, 16));
                            }
                            try {
                                if (((RFB.RFBKeyEvent)event).down) {
                                    if (JF.isWindows()) {
                                        if (code > 0 && code < 256) {
                                            VNCServer.this.keys[code] = true;
                                        }
                                        boolean shift = VNCServer.this.keys[16];
                                        boolean ctrl = VNCServer.this.keys[17];
                                        boolean alt = VNCServer.this.keys[18];
                                        if (debug) {
                                            JFLog.log("shift=" + shift + ",ctrl=" + ctrl + ",alt=" + alt);
                                        }
                                        if (code == 127 && !shift && ctrl && alt) {
                                            if (debug) {
                                                JFLog.log("Simulating Ctrl+Alt+Del");
                                            }
                                            WinNative.simulateCtrlAltDel();
                                        }
                                    }
                                    if (code == -1) continue block25;
                                    Object shift = this.lock;
                                    synchronized (shift) {
                                        this.robot.keyPress(code);
                                        break;
                                    }
                                }
                                if (JF.isWindows() && code > 0 && code < 256) {
                                    VNCServer.this.keys[code] = false;
                                }
                                if (code == -1) continue block25;
                                Object shift = this.lock;
                                synchronized (shift) {
                                    this.robot.keyRelease(code);
                                }
                            }
                            catch (Exception e) {
                                JFLog.log(e);
                            }
                            continue block25;
                        }
                        case 2: {
                            int[] encodings = this.rfb.readEncodings();
                            if (encodings != null) break;
                            throw new Exception("invalid encodings");
                        }
                        case 0: {
                            RFB.PixelFormat rfb_pf = this.rfb.readPixelFormat();
                            this.pf = rfb_pf.getFormat();
                            break;
                        }
                        case 6: {
                            String text = this.rfb.readCutText();
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                JFLog.log(e);
                this.close();
            }
            Object object = this.lock;
            synchronized (object) {
                this.robot.close();
                return;
            }
        }

        public void close() {
            this.connected = false;
            try {
                this.s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private class Updater
        extends Thread {
            private boolean updater_active;
            private int[] img;
            private boolean refresh;
            private int sid;
            private static final int INF = 65536;

            private Updater() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.updater_active = true;
                this.refresh = true;
                try {
                    if (JF.isWindows()) {
                        this.sid = -1;
                        while (this.sid == -1) {
                            this.sid = WinNative.getSessionID();
                            JF.sleep(100);
                        }
                    }
                    while (this.updater_active && Client.this.connected) {
                        Object object;
                        int newsid;
                        if (!Client.this.rfb.haveEncodings()) {
                            JF.sleep(100);
                            continue;
                        }
                        if (JF.isWindows() && VNCServer.this.service_mode && (newsid = WinNative.getSessionID()) != -1 && newsid != this.sid) {
                            if (debug) {
                                JFLog.log("Session ID change detected, creating a new session.");
                            }
                            object = Client.this.lock;
                            synchronized (object) {
                                Client.this.robot.close();
                                Client.this.robot = null;
                                Client.this.robot = VNCServer.this.newSession();
                            }
                            this.sid = newsid;
                        }
                        Rectangle new_size = null;
                        object = Client.this.lock;
                        synchronized (object) {
                            new_size = Client.this.robot.getScreenSize();
                        }
                        if (new_size.width != Client.this.size.width || new_size.height != Client.this.size.height) {
                            Client.this.size = new_size;
                            Client.this.rfb.writeBufferUpdate(new RFB.Rectangle(new_size), -223);
                        }
                        if (this.refresh) {
                            object = Client.this.lock;
                            synchronized (object) {
                                this.img = Client.this.robot.getScreenCapture(Client.this.pf);
                            }
                            Client.this.rfb.setBuffer(this.img);
                            RFB.Rectangle rect = new RFB.Rectangle();
                            rect.width = Client.this.size.width;
                            rect.height = Client.this.size.height;
                            Client.this.rfb.writeBufferUpdate(rect, -1);
                            this.refresh = false;
                        } else {
                            int[] update;
                            Object object2 = Client.this.lock;
                            synchronized (object2) {
                                update = Client.this.robot.getScreenCapture(Client.this.pf);
                            }
                            boolean changed = false;
                            int x1 = 65536;
                            int x2 = -1;
                            int y1 = 65536;
                            int y2 = -1;
                            int x = 0;
                            int width = Client.this.size.width;
                            int y = 0;
                            int height = Client.this.size.height;
                            int idx = 0;
                            int[] ipx = this.img;
                            int[] upx = update;
                            for (y = 0; y < height; ++y) {
                                for (x = 0; x < width; ++x) {
                                    if (ipx[idx] != upx[idx]) {
                                        if (x1 > x) {
                                            x1 = x;
                                        }
                                        if (x2 < x) {
                                            x2 = x;
                                        }
                                        if (y1 > y) {
                                            y1 = y;
                                        }
                                        if (y2 < y) {
                                            y2 = y;
                                        }
                                        changed = true;
                                        ipx[idx] = upx[idx];
                                    }
                                    ++idx;
                                }
                            }
                            if (changed) {
                                Client.this.rfb.setBuffer(update);
                                RFB.Rectangle rect = new RFB.Rectangle();
                                rect.x = x1;
                                rect.y = y1;
                                rect.width = x2 - x1 + 1;
                                rect.height = y2 - y1 + 1;
                                Client.this.rfb.writeBufferUpdate(rect, -1);
                            }
                        }
                        JF.sleep(100);
                    }
                }
                catch (Exception e) {
                    JFLog.log(e);
                }
            }

            public void cancel() {
                this.updater_active = false;
                JF.sleep(250);
            }

            public void refresh(RFB.Rectangle rect) {
                this.refresh = true;
            }
        }
    }
}

