/*
 * Decompiled with CFR 0.152.
 */
package javaforce.gl.model;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.LE;
import javaforce.gl.Model;
import javaforce.gl.Object3;
import javaforce.gl.UVMap;
import javaforce.gl.model.Model_IO;

public class ModelJF3D
implements Model_IO {
    private byte[] data;
    private int datapos;
    private int skip;
    private static boolean debug = false;
    private static final int MAGIC = 1144211018;
    private static final int VERSION = 256;
    private static final int ID_MODEL = 65536;
    private static final int ID_OBJECT = 131072;
    private static final int ID_UVMAP = 196608;
    private Model model;
    private Object3 obj;
    private ByteArrayOutputStream baos;
    private byte[] tmp;

    public Model load(String filename) {
        try {
            FileInputStream is = new FileInputStream(filename);
            Model model = this.loadJF3D(is);
            ((InputStream)is).close();
            return model;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Model load(InputStream is) {
        try {
            return this.loadJF3D(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean eof() {
        return this.datapos >= this.data.length;
    }

    private int readuint16() {
        int uint16 = LE.getuint16(this.data, this.datapos);
        this.datapos += 2;
        this.skip -= 2;
        return uint16;
    }

    private int readuint32() {
        int uint32 = LE.getuint32(this.data, this.datapos);
        this.datapos += 4;
        this.skip -= 4;
        return uint32;
    }

    private float readfloat() {
        return Float.intBitsToFloat(this.readuint32());
    }

    private String readString() {
        Object ret = "";
        while (!this.eof()) {
            char ch = (char)this.data[this.datapos++];
            --this.skip;
            if (ch == '\u0000') break;
            ret = (String)ret + ch;
        }
        return ret;
    }

    private Model loadJF3D(InputStream is) throws Exception {
        this.datapos = 0;
        this.data = JF.readAll(is);
        int magic = this.readuint32();
        if (magic != 1144211018) {
            throw new Exception("GL_JF3D:Not JF3D file");
        }
        int version = this.readuint32();
        if (version < 256) {
            throw new Exception("GL_JF3D:Bad version");
        }
        while (!this.eof()) {
            int head_len;
            int head_id = this.readuint32();
            this.skip = head_len = this.readuint32();
            int head_ver = head_id & 0xFFFF;
            switch (head_id &= 0xFFFF0000) {
                case 65536: {
                    if (this.model != null) {
                        throw new Exception("GL_JF3D:Multiple Model chunks found");
                    }
                    this.model = new Model();
                    int fcnt = this.readuint32();
                    for (int a = 0; a < fcnt; ++a) {
                        String txt = this.readString();
                        this.model.textures.add(txt);
                        if (!debug) continue;
                        JFLog.log("JF3D:Texture=" + txt);
                    }
                    if (head_ver <= 0) break;
                    break;
                }
                case 131072: {
                    this.obj = new Object3();
                    this.model.addObject(this.obj);
                    this.obj.name = this.readString();
                    if (debug) {
                        JFLog.log("JF3D:Object=" + this.obj.name);
                    }
                    this.obj.type = this.readuint32();
                    this.obj.org.x = this.readfloat();
                    this.obj.org.y = this.readfloat();
                    this.obj.org.z = this.readfloat();
                    int vcnt = this.readuint32();
                    for (int v = 0; v < vcnt; ++v) {
                        float fx = this.readfloat();
                        float fy = this.readfloat();
                        float fz = this.readfloat();
                        this.obj.addVertex(new float[]{fx, fy, fz});
                        if (!debug) continue;
                        JFLog.log("JF3D:Vertex:" + fx + "," + fy + "," + fz);
                    }
                    int pcnt = this.readuint32();
                    switch (this.obj.type) {
                        case 4: {
                            pcnt *= 3;
                            break;
                        }
                        case 7: {
                            pcnt *= 4;
                            break;
                        }
                        default: {
                            JFLog.log("GL_JF3D:Error Unknown GL Type:" + this.obj.type);
                            return null;
                        }
                    }
                    for (int p = 0; p < pcnt; ++p) {
                        int pt = this.readuint32();
                        if (pt >= vcnt) {
                            JFLog.log("Error:Poly includes invalid vertex !!!");
                        }
                        if (debug) {
                            JFLog.log("JF3D:Poly:" + pt);
                        }
                        this.obj.addPoly(new int[]{pt});
                    }
                    break;
                }
                case 196608: {
                    UVMap map = this.obj.createUVMap();
                    map.name = this.readString();
                    map.textureIndex = this.readuint32();
                    int uvcnt = this.readuint32();
                    if (uvcnt != this.obj.getVertexCount()) {
                        JFLog.log("Warning:UVMAP size != vertex count");
                    }
                    for (int i = 0; i < uvcnt; ++i) {
                        float u = this.readfloat();
                        float v = this.readfloat();
                        map.addText(new float[]{u, v});
                        if (!debug) continue;
                        JFLog.log("JF3D:UV:" + u + "," + v);
                    }
                    break;
                }
            }
            if (this.skip <= 0) continue;
            this.datapos += this.skip;
        }
        return this.model;
    }

    public boolean save(Model model, String filename) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            this.saveJF3D(model, fos);
            fos.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean save(Model model, OutputStream os) {
        try {
            this.saveJF3D(model, os);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void writeString(String str) throws Exception {
        this.baos.write(str.getBytes());
        this.baos.write(0);
    }

    private void writeuint16(int val) {
        LE.setuint16(this.tmp, 0, val);
        this.baos.write(this.tmp, 0, 2);
    }

    private void writeuint32(int val) {
        LE.setuint32(this.tmp, 0, val);
        this.baos.write(this.tmp, 0, 4);
    }

    private void writefloat(float f) {
        this.writeuint32(Float.floatToIntBits(f));
    }

    private void saveJF3D(Model model, OutputStream os) throws Exception {
        int a;
        this.baos = new ByteArrayOutputStream();
        this.tmp = new byte[8];
        this.writeuint32(1144211018);
        this.writeuint32(256);
        this.writeuint32(65536);
        int size = 0;
        int tcnt = model.textures.size();
        for (a = 0; a < tcnt; ++a) {
            size += model.textures.get(a).length() + 1;
        }
        this.writeuint32(size);
        this.writeuint32(tcnt);
        for (a = 0; a < tcnt; ++a) {
            this.writeString(model.textures.get(a));
        }
        for (int o = 0; o < model.ol.size(); ++o) {
            Object3 obj = model.ol.get(o);
            this.writeuint32(131072);
            int vcnt = obj.vpl.size();
            int pcnt = obj.vil.size();
            size = obj.name.length() + 1 + 4 + 12 + (4 + vcnt * 4) + (4 + pcnt * 4);
            this.writeuint32(size);
            this.writeString(obj.name);
            this.writeuint32(obj.type);
            this.writefloat(obj.org.x);
            this.writefloat(obj.org.y);
            this.writefloat(obj.org.z);
            this.writeuint32(vcnt / 3);
            float[] xyz = obj.vpl.toArray();
            for (int a2 = 0; a2 < vcnt; ++a2) {
                this.writefloat(xyz[a2]);
            }
            switch (obj.type) {
                case 4: {
                    this.writeuint32(pcnt / 3);
                    break;
                }
                case 7: {
                    this.writeuint32(pcnt / 4);
                }
            }
            int[] pts = obj.vil.toArray();
            for (int a3 = 0; a3 < pcnt; ++a3) {
                this.writeuint32(pts[a3]);
            }
            int maps = obj.maps.size();
            if (maps == 0) {
                JFLog.log("GL_JF3D:Warning:No UVMaps found for object:" + obj.name);
            }
            for (int m = 0; m < maps; ++m) {
                UVMap map = obj.maps.get(m);
                this.writeuint32(196608);
                int uvcnt = map.uvl.size();
                size = map.name.length() + 1 + 4 + (4 + uvcnt * 4);
                this.writeuint32(size);
                this.writeString(map.name);
                this.writeuint32(map.textureIndex);
                this.writeuint32(uvcnt / 2);
                float[] uv = map.uvl.toArray();
                for (int a4 = 0; a4 < uvcnt; ++a4) {
                    this.writefloat(uv[a4]);
                }
            }
        }
        os.write(this.baos.toByteArray());
    }

    public static void main(String[] args) {
        ModelJF3D jf3d = new ModelJF3D();
        debug = true;
        jf3d.load(args[0]);
    }
}

