/*
 * Decompiled with CFR 0.152.
 */
package javaforce.print;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Objects;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.jbus.JBusClient;
import javaforce.jbus.JBusServer;
import javaforce.service.WebHandler;
import javaforce.service.WebRequest;
import javaforce.service.WebResponse;
import javaforce.service.WebServer;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;

public class JFPrintServer {
    private static final int port = 33202;
    public static final String busPack = "net.sf.jfprint";
    private Server server;
    private HashMap<String, DocPrintJob> jobs = new HashMap();
    private static final String defaultConfig = "#JFPrintServer";
    private static JBusServer busServer;
    private JBusClient busClient;
    private String config = "#JFPrintServer";
    private static JFPrintServer service;

    public static int getBusPort() {
        if (JF.isWindows()) {
            return 33016;
        }
        return 777;
    }

    public static String getConfigFile() {
        return JF.getConfigPath() + "/jfprint.cfg";
    }

    public static String getLogFile() {
        return JF.getLogPath() + "/jfprint.log";
    }

    public void start() {
        this.stop();
        this.server = new Server();
        this.server.start();
    }

    public void stop() {
        if (this.server != null) {
            this.server.cancel();
            this.server = null;
        }
        if (this.busClient != null) {
            this.busClient.close();
            this.busClient = null;
        }
    }

    private PrintService getPrinter(String pname) {
        PrintService[] printers;
        for (PrintService printer : printers = PrintServiceLookup.lookupPrintServices(null, null)) {
            String name = printer.getName();
            int idx = name.lastIndexOf(92);
            if (idx != -1) {
                name = name.substring(idx + 1);
            }
            if (!name.equals(pname)) continue;
            return printer;
        }
        return null;
    }

    private PrintService[] getPrinters() {
        return PrintServiceLookup.lookupPrintServices(null, null);
    }

    private void loadConfig() {
        try {
            String ln;
            StringBuilder cfg = new StringBuilder();
            BufferedReader br = new BufferedReader(new FileReader(JFPrintServer.getConfigFile()));
            while ((ln = br.readLine()) != null) {
                int idx;
                cfg.append(ln);
                cfg.append("\n");
                ln = ln.trim();
                int cmt = ln.indexOf(35);
                if (cmt != -1) {
                    ln = ln.substring(0, cmt).trim();
                }
                if (ln.length() == 0 || (idx = ln.indexOf("=")) == -1) continue;
                String key = ln.substring(0, idx).toLowerCase().trim();
                String value = ln.substring(idx + 1).trim();
                Objects.requireNonNull(key);
            }
            this.config = cfg.toString();
        }
        catch (FileNotFoundException e) {
            try {
                FileOutputStream fos = new FileOutputStream(JFPrintServer.getConfigFile());
                fos.write(defaultConfig.getBytes());
                fos.close();
                this.config = defaultConfig;
            }
            catch (Exception e2) {
                JFLog.log(e2);
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static void serviceStart(String[] args) {
        if (JF.isWindows()) {
            busServer = new JBusServer(JFPrintServer.getBusPort());
            busServer.start();
            while (true) {
                if (JBusServer.ready) break;
                JF.sleep(10);
            }
        }
        service = new JFPrintServer();
        service.start();
    }

    public static void serviceStop() {
        JFLog.log("JFPrint : Stopping service");
        if (busServer != null) {
            busServer.close();
            busServer = null;
        }
        service.stop();
    }

    private class Server
    extends Thread
    implements WebHandler {
        private WebServer web;

        private Server() {
        }

        @Override
        public void run() {
            JFLog.append(JFPrintServer.getLogFile(), true);
            JFLog.setRetention(30);
            JFLog.log("JFPrint : Starting service");
            JFPrintServer.this.loadConfig();
            JFPrintServer.this.busClient = new JBusClient(JFPrintServer.busPack, new JBusMethods());
            JFPrintServer.this.busClient.setPort(JFPrintServer.getBusPort());
            JFPrintServer.this.busClient.start();
            this.web = new WebServer();
            this.web.start(this, 33202);
        }

        public void cancel() {
            this.web.stop();
            this.web = null;
        }

        private String getHeader(WebRequest req, String name, String defaultValue) {
            String value = req.getHeader(name);
            if (value == null) {
                value = defaultValue;
            }
            return value;
        }

        @Override
        public void doPost(WebRequest req, WebResponse res) {
            try {
                String _orientation;
                String url = req.getURL();
                String[] ps = url.substring(1).split("/");
                if (ps.length < 2) {
                    res.write("error:invalid url".getBytes());
                    return;
                }
                String cmd = ps[0];
                if (!cmd.equals("print")) {
                    res.write("error:unknown command".getBytes());
                    return;
                }
                String name = ps[1];
                String _width = this.getHeader(req, "width", "8.5");
                float width = Float.valueOf(_width).floatValue();
                String _height = this.getHeader(req, "height", "11.0");
                float height = Float.valueOf(_height).floatValue();
                String _unit = this.getHeader(req, "unit", "inch");
                int unit = 25400;
                switch (_unit) {
                    case "inch": {
                        unit = 25400;
                        break;
                    }
                    case "mm": {
                        unit = 1000;
                    }
                }
                OrientationRequested orientation = OrientationRequested.PORTRAIT;
                switch (_orientation = this.getHeader(req, "orientation", "portrait")) {
                    case "landscape": {
                        orientation = OrientationRequested.LANDSCAPE;
                        break;
                    }
                    case "portrait": {
                        orientation = OrientationRequested.PORTRAIT;
                    }
                }
                byte[] png = req.getData();
                JFLog.log("print:printer=" + name + ",width=" + width + ",height=" + height + ",unit=" + _unit + ",orientation=" + _orientation + ",png=" + png.length);
                HashPrintRequestAttributeSet attribSet = new HashPrintRequestAttributeSet();
                attribSet.add(new MediaPrintableArea(0.0f, 0.0f, width, height, unit));
                attribSet.add(orientation);
                ByteArrayInputStream is = new ByteArrayInputStream(png);
                SimpleDoc myDoc = new SimpleDoc(is, DocFlavor.INPUT_STREAM.PNG, null);
                PrintService def = JFPrintServer.this.getPrinter(name);
                DocPrintJob job = def.createPrintJob();
                job.print(myDoc, attribSet);
                String jobid = Long.toString(System.currentTimeMillis());
                JFPrintServer.this.jobs.put(jobid, job);
                res.write(("jobid:" + jobid).getBytes());
                this.cleanJobs();
            }
            catch (Exception e) {
                try {
                    res.write(e.toString().getBytes());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void doGet(WebRequest req, WebResponse res) {
            try {
                String cmd;
                String url = req.getURL();
                String[] ps = url.substring(1).split("/");
                switch (cmd = ps[0]) {
                    case "list": {
                        res.write(this.list());
                        break;
                    }
                    case "query": {
                        res.write(this.query(ps[1]));
                        break;
                    }
                    case "status": {
                        res.write(this.status(ps[1]));
                        break;
                    }
                    default: {
                        res.write(("JFPrintServer Ready (JF/" + JF.getVersion() + ")").getBytes());
                    }
                }
                this.cleanJobs();
            }
            catch (Exception e) {
                try {
                    res.write(e.toString().getBytes());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private byte[] list() {
            PrintService[] printers;
            StringBuilder sb = new StringBuilder();
            for (PrintService print : printers = JFPrintServer.this.getPrinters()) {
                String name = print.getName();
                int idx = name.lastIndexOf(92);
                if (idx != -1) {
                    name = name.substring(idx + 1);
                }
                sb.append(name);
                sb.append("\r\n");
            }
            return sb.toString().getBytes();
        }

        private byte[] query(String name) {
            PrintService printer = JFPrintServer.this.getPrinter(name);
            if (printer == null) {
                return "error: not found".getBytes();
            }
            return "status: wip".getBytes();
        }

        private byte[] status(String jobid) {
            return "status: wip".getBytes();
        }

        private void cleanJobs() {
        }
    }

    public static class JBusMethods {
        public void getConfig(String pack) {
            JBusClient cfr_ignored_0 = JFPrintServer.service.busClient;
            JBusClient cfr_ignored_1 = JFPrintServer.service.busClient;
            JFPrintServer.service.busClient.call(pack, "getConfig", JBusClient.quote(JBusClient.encodeString(JFPrintServer.service.config)));
        }

        public void setConfig(String cfg) {
            try {
                FileOutputStream fos = new FileOutputStream(JFPrintServer.getConfigFile());
                fos.write(JBusClient.decodeString(cfg).getBytes());
                fos.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void restart() {
            service.stop();
            service = new JFPrintServer();
            service.start();
        }
    }
}

