/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.Random;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.media.AudioInput;
import javaforce.media.MediaAudioDecoder;
import javaforce.media.MediaAudioEncoder;
import javaforce.media.MediaCoder;
import javaforce.media.MediaDecoder;
import javaforce.media.MediaEncoder;
import javaforce.media.MediaIO;
import javaforce.media.MediaInput;
import javaforce.media.MediaOutput;
import javaforce.media.MediaVideoDecoder;
import javaforce.media.MediaVideoEncoder;
import javaforce.voip.CodecInfo;
import javaforce.voip.Packet;

public class TestMedia
implements MediaIO {
    public static int encoder_seconds = 4;
    public static String encoder_audio_src = "random";
    public static boolean use_media_io = false;
    public RandomAccessFile raf;
    public long size;

    public static void usage() {
        System.out.println("TestMedia encoder | decoder | output | input");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            TestMedia.usage();
        }
        MediaCoder.init();
        for (int a = 0; a < args.length; ++a) {
            int idx = args[a].indexOf(61);
            if (idx != -1) {
                String key = args[a].substring(0, idx);
                String value = args[a].substring(idx + 1);
                switch (key) {
                    case "seconds": {
                        encoder_seconds = Integer.valueOf(value);
                        break;
                    }
                    case "audiosrc": {
                        encoder_audio_src = value;
                    }
                }
                continue;
            }
            try {
                switch (args[a]) {
                    case "decoder": {
                        TestMedia.decoder();
                        break;
                    }
                    case "encoder": {
                        TestMedia.encoder(true);
                        break;
                    }
                    case "input": {
                        TestMedia.input();
                        break;
                    }
                    case "output": {
                        TestMedia.output(true);
                        break;
                    }
                    default: {
                        TestMedia.usage();
                        break;
                    }
                }
                continue;
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    public static void decoder() {
        if (!new File("test-0.mp4").exists()) {
            TestMedia.encoder(false);
        }
        while (true) {
            TestMedia media = new TestMedia();
            MediaDecoder decoder = new MediaDecoder();
            media.open("test-0.mp4");
            decoder.start(media, 640, 480, 2, 44100, true);
            boolean eof = false;
            int pkts = 0;
            block6: do {
                int type = decoder.read();
                ++pkts;
                switch (type) {
                    case 2: {
                        int[] px = decoder.getVideo();
                        if (px == null) continue block6;
                        System.out.println("video=" + px.length);
                        break;
                    }
                    case 1: {
                        short[] sams = decoder.getAudio();
                        if (sams == null) continue block6;
                        System.out.println("audio=" + sams.length);
                        break;
                    }
                    case -1: {
                        eof = true;
                    }
                }
            } while (!eof);
            System.out.println("packets=" + pkts);
            decoder.stop();
            media.close();
        }
    }

    public static void input() {
        if (!new File("test-0.mp4").exists()) {
            TestMedia.output(false);
        }
        while (true) {
            Packet pkt;
            TestMedia media = new TestMedia();
            MediaInput decoder = new MediaInput();
            media.open("test-0.mp4");
            decoder.open(media);
            int pkts = 0;
            MediaVideoDecoder videoDecoder = decoder.createVideoDecoder();
            MediaAudioDecoder audioDecoder = decoder.createAudioDecoder();
            while ((pkt = decoder.readPacket()) != null && pkt.length != 0) {
                ++pkts;
                if (pkt.stream == videoDecoder.getStream()) {
                    int[] px = videoDecoder.decode(pkt);
                    if (px != null) {
                        JFLog.log("video=" + px.length);
                        continue;
                    }
                    JFLog.log("no video");
                    continue;
                }
                if (pkt.stream != audioDecoder.getStream()) continue;
                short[] sams = audioDecoder.decode(pkt);
                if (sams != null) {
                    JFLog.log("audio=" + sams.length);
                    continue;
                }
                JFLog.log("no audio");
            }
            System.out.println("packets=" + pkts);
            decoder.close();
            media.close();
        }
    }

    public static void random(int[] px) {
        Random r = new Random();
        int len = px.length;
        for (int a = 0; a < len; ++a) {
            px[a] = r.nextInt() | 0xFF000000;
        }
    }

    public static void random(short[] sams) {
        Random r = new Random();
        int len = sams.length;
        for (int a = 0; a < len; ++a) {
            sams[a] = (short)(r.nextInt(65536) - 32768);
        }
    }

    public static void encoder(boolean loop) {
        TestMedia media = new TestMedia();
        int[] px = new int[307200];
        short[] sams = new short[7350];
        int i = 0;
        int video = 173;
        int audio = 86018;
        do {
            MediaEncoder encoder = new MediaEncoder();
            AudioInput input = new AudioInput();
            if (use_media_io) {
                media.size = 0L;
                media.create(i++);
                encoder.start((MediaIO)media, 640, 480, 24, 2, 44100, "mp4", video, audio);
            } else {
                String file = "test-" + i++ + ".mp4";
                encoder.startFile(file, 640, 480, 24, 2, 44100, "mp4", video, audio);
                System.out.println("file=" + file);
            }
            if (i == 10) {
                i = 0;
            }
            int frame_size = encoder.getAudioFramesize() * 2;
            JFLog.log("frame_size=" + frame_size);
            if (encoder_audio_src.equals("mic")) {
                input.start(2, 44100, 16, frame_size, "<default>");
            }
            System.out.println("Audio Frame Size=" + encoder.getAudioFramesize());
            for (int a = 0; a < 24 * encoder_seconds; ++a) {
                TestMedia.random(px);
                if (encoder_audio_src.equals("mic")) {
                    while (!input.read(sams)) {
                        JF.sleep(50);
                    }
                } else {
                    TestMedia.random(sams);
                }
                encoder.addVideo(px);
                encoder.addAudio(sams);
            }
            encoder.stop();
            if (use_media_io) {
                media.close();
                System.out.println("size=" + media.size);
            }
            if (encoder_audio_src.equals("mic")) {
                input.stop();
            }
            System.gc();
        } while (loop);
    }

    public static void output(boolean loop) {
        TestMedia media = new TestMedia();
        int[] px = new int[307200];
        short[] sams = new short[7350];
        int i = 0;
        CodecInfo info = new CodecInfo();
        do {
            MediaOutput encoder = new MediaOutput();
            AudioInput input = new AudioInput();
            if (use_media_io) {
                media.size = 0L;
                media.create(i++);
                encoder.create(media, "mp4");
            } else {
                String file = "test-" + i++ + ".mp4";
                encoder.create(file, "mp4");
                System.out.println("file=" + file);
            }
            info.width = 640;
            info.height = 480;
            info.fps = 10.0f;
            info.video_bit_rate = 0x100000;
            info.video_codec = 173;
            MediaVideoEncoder videoEncoder = encoder.createVideoEncoder(info);
            info.chs = 2;
            info.freq = 44100;
            info.audio_bit_rate = 131072;
            info.audio_codec = 86018;
            MediaAudioEncoder audioEncoder = encoder.createAudioEncoder(info);
            if (i == 10) {
                i = 0;
            }
            int frame_size = audioEncoder.getAudioFramesize() * 2;
            JFLog.log("frame_size=" + frame_size);
            if (encoder_audio_src.equals("mic")) {
                input.start(2, 44100, 16, frame_size, "<default>");
            }
            System.out.println("Audio Frame Size=" + audioEncoder.getAudioFramesize());
            for (int a = 0; a < 24 * encoder_seconds; ++a) {
                TestMedia.random(px);
                Packet packet = videoEncoder.encode(px, 0, px.length);
                if (packet != null) {
                    encoder.writePacket(packet);
                }
                if (encoder_audio_src.equals("mic")) {
                    while (!input.read(sams)) {
                        JF.sleep(50);
                    }
                } else {
                    TestMedia.random(sams);
                }
                if ((packet = audioEncoder.encode(sams, 0, sams.length)) == null) continue;
                encoder.writePacket(packet);
            }
            encoder.close();
            if (use_media_io) {
                media.close();
                System.out.println("size=" + media.size);
            }
            if (encoder_audio_src.equals("mic")) {
                input.stop();
            }
            System.gc();
        } while (loop);
    }

    public void create(int i) {
        try {
            this.raf = new RandomAccessFile("test-" + i + ".mp4", "rw");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open(String filename) {
        try {
            this.raf = new RandomAccessFile(filename, "rw");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.raf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.raf = null;
    }

    @Override
    public int read(MediaCoder coder, byte[] data) {
        try {
            return this.raf.read(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public int write(MediaCoder coder, byte[] data) {
        try {
            this.size += (long)data.length;
            this.raf.write(data);
            return data.length;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public long seek(MediaCoder coder, long pos, int type) {
        try {
            switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    pos += this.raf.getFilePointer();
                    break;
                }
                case 2: {
                    pos += this.raf.length();
                }
            }
            this.raf.seek(pos);
            return pos;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

