package javaforce.awt;

/** MQTT Viewer
 *
 * @author peter.quiring
 */

import java.io.*;

import javaforce.*;

public class MQTTViewer extends javax.swing.JFrame implements MQTTEvents {

  /**
   * Creates new form MQTTViewer
   */
  public MQTTViewer() {
    initComponents();
    initSecureWebKeys();
    setState(true);
    if (args.length > 0) {
      server.setText(args[0]);
      if (args.length > 1) {
        authenticate.setSelected(true);
        username.setText(args[1]);
        if (args.length > 2) {
          password.setText(args[2]);
          if (args.length > 3) {
            switch (args[3]) {
              case "-secure": secure.setSelected(true); break;
            }
          }
        }
      }
    }
  }

  /**
   * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The content of this method is always regenerated by the Form
   * Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    jLabel1 = new javax.swing.JLabel();
    server = new javax.swing.JTextField();
    jLabel2 = new javax.swing.JLabel();
    topic = new javax.swing.JTextField();
    start = new javax.swing.JButton();
    jScrollPane1 = new javax.swing.JScrollPane();
    msgs = new javax.swing.JTextArea();
    jLabel3 = new javax.swing.JLabel();
    authenticate = new javax.swing.JCheckBox();
    username = new javax.swing.JTextField();
    jLabel4 = new javax.swing.JLabel();
    password = new javax.swing.JTextField();
    clear = new javax.swing.JButton();
    secure = new javax.swing.JCheckBox();
    jLabel5 = new javax.swing.JLabel();
    send_topic = new javax.swing.JTextField();
    jLabel6 = new javax.swing.JLabel();
    send_msg = new javax.swing.JTextField();
    send = new javax.swing.JButton();
    subscribe = new javax.swing.JButton();

    setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
    setTitle("MQTT Viewer");

    jLabel1.setText("Server");

    server.setText("127.0.0.1");
    server.setMinimumSize(new java.awt.Dimension(200, 22));
    server.setPreferredSize(new java.awt.Dimension(200, 22));

    jLabel2.setText("Topic");

    topic.setText("#");

    start.setText("Start");
    start.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        startActionPerformed(evt);
      }
    });

    msgs.setColumns(20);
    msgs.setRows(5);
    jScrollPane1.setViewportView(msgs);

    jLabel3.setText("Username");

    authenticate.setText("Authenticate");

    username.setMinimumSize(new java.awt.Dimension(100, 22));
    username.setPreferredSize(new java.awt.Dimension(100, 22));

    jLabel4.setText("Password");

    password.setMinimumSize(new java.awt.Dimension(100, 22));
    password.setPreferredSize(new java.awt.Dimension(100, 22));

    clear.setText("Clear");
    clear.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        clearActionPerformed(evt);
      }
    });

    secure.setText("Secure");

    jLabel5.setText("Topic");

    send_topic.setText("uns/topic");

    jLabel6.setText("Msg");

    send_msg.setText("{data}");

    send.setText("Send");
    send.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        sendActionPerformed(evt);
      }
    });

    subscribe.setText("Subscribe");
    subscribe.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        subscribeActionPerformed(evt);
      }
    });

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(jScrollPane1)
          .addGroup(layout.createSequentialGroup()
            .addComponent(jLabel2)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(topic)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(subscribe))
          .addGroup(layout.createSequentialGroup()
            .addComponent(jLabel1)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(server, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(authenticate)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(jLabel3)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(username, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(jLabel4)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(password, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(secure)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addComponent(clear)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(start))
          .addGroup(layout.createSequentialGroup()
            .addComponent(jLabel5)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(send_topic, javax.swing.GroupLayout.PREFERRED_SIZE, 303, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(jLabel6)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(send_msg)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(send)))
        .addContainerGap())
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel1)
          .addComponent(server, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(start)
          .addComponent(jLabel3)
          .addComponent(authenticate)
          .addComponent(username, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(jLabel4)
          .addComponent(password, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(clear)
          .addComponent(secure))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
            .addComponent(jLabel2)
            .addComponent(topic, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
          .addComponent(subscribe, javax.swing.GroupLayout.Alignment.TRAILING))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 603, Short.MAX_VALUE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(send_topic, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(jLabel6)
          .addComponent(jLabel5)
          .addComponent(send_msg, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(send))
        .addContainerGap())
    );

    pack();
  }// </editor-fold>//GEN-END:initComponents

  private void startActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_startActionPerformed
    start();
  }//GEN-LAST:event_startActionPerformed

  private void clearActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearActionPerformed
    clear();
  }//GEN-LAST:event_clearActionPerformed

  private void sendActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sendActionPerformed
    send();
  }//GEN-LAST:event_sendActionPerformed

  private void subscribeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_subscribeActionPerformed
    subscribe();
  }//GEN-LAST:event_subscribeActionPerformed

  /**
   * @param args the command line arguments
   */
  public static void main(String args[]) {
    MQTTViewer.args = args;
    /* Create and display the form */
    java.awt.EventQueue.invokeLater(new Runnable() {
      public void run() {
        new MQTTViewer().setVisible(true);
      }
    });
  }

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JCheckBox authenticate;
  private javax.swing.JButton clear;
  private javax.swing.JLabel jLabel1;
  private javax.swing.JLabel jLabel2;
  private javax.swing.JLabel jLabel3;
  private javax.swing.JLabel jLabel4;
  private javax.swing.JLabel jLabel5;
  private javax.swing.JLabel jLabel6;
  private javax.swing.JScrollPane jScrollPane1;
  private javax.swing.JTextArea msgs;
  private javax.swing.JTextField password;
  private javax.swing.JCheckBox secure;
  private javax.swing.JButton send;
  private javax.swing.JTextField send_msg;
  private javax.swing.JTextField send_topic;
  private javax.swing.JTextField server;
  private javax.swing.JButton start;
  private javax.swing.JButton subscribe;
  private javax.swing.JTextField topic;
  private javax.swing.JTextField username;
  // End of variables declaration//GEN-END:variables

  private MQTT client;
  private KeyMgmt keys;

  private static String[] args;

  public void addText(String msg) {
    msgs.setText(msgs.getText() + msg);
  }

  public boolean message(String topic, String msg) {
    String ln = topic + "=" + msg + "\r\n";
    addText(ln);
    return true;
  }

  public void start() {
    if (client == null) {
      start_new();
    } else {
      stop();
    }
  }

  public void start_new() {
    String _server = server.getText();
    boolean _secure = secure.isSelected();
    int port = -1;
    if (_secure) {
      port = 8883;
    } else {
      port = 1883;
    }
    int idx = _server.indexOf(':');
    if (idx != -1) {
      String _port = _server.substring(idx + 1);
      _server = _server.substring(0, idx);
      port = JF.atoi(_port);
    }
    msgs.setText("Connecting to " + _server + ":" + port + "...");
    client = new MQTT();
    if (_secure) {
      if (!client.connect(_server, port, keys)) {
        msgs.setText("Connection failed!");
        client = null;
        return;
      }
    } else {
      if (!client.connect(_server, port)) {
        msgs.setText("Connection failed!");
        client = null;
        return;
      }
    }
    if (authenticate.isSelected()) {
      String _user = username.getText();
      String _pass = password.getText();
      client.connect(_user, _pass);
    } else {
      client.connect();
    }
    msgs.setText("Connected to " + _server + "\r\n");
    client.setListener(this);
    start.setText("Stop");
    setState(false);
  }

  public void stop() {
    if (client != null) {
      client.disconnect();
      client = null;
    }
    start.setText("Start");
    setState(true);
  }

  public void subscribe() {
    if (client == null) return;
    String _topic = topic.getText();
    client.subscribe(_topic);
    addText("Subscribed to : " + _topic + "\r\n");
  }

  private void setState(boolean state) {
    server.setEditable(state);
    authenticate.setEnabled(state);
    username.setEditable(state);
    password.setEditable(state);
    secure.setEnabled(state);

    topic.setEditable(!state);
    subscribe.setEnabled(!state);
    send.setEnabled(!state);
  }

  private void clear() {
    if (client == null) {
      msgs.setText("");
    } else {
      msgs.setText("Connected to " + server.getText() + "\r\n");
    }
  }

  private void send() {
    if (client == null) return;
    String topic = send_topic.getText();
    String msg = send_msg.getText();
    client.publish(topic, msg);
  }

  private void initSecureWebKeys() {
    String keyfile = JF.getUserPath() + "/jfmqtt.key";
    String password = "password";
    KeyParams params = new KeyParams();
    params.dname = "CN=jfmqtt.sourceforge.net, O=client, OU=mqtt, C=CA";
    if (new File(keyfile).exists()) {
      //load existing keys
      keys = new KeyMgmt();
      try {
        FileInputStream fis = new FileInputStream(keyfile);
        keys.open(fis, password);
        fis.close();
      } catch (Exception e) {
        if (!keys.isValid()) {
          //generate random keys
          keys = KeyMgmt.create(keyfile, password, "webserver", params, password);
        }
        JFLog.log(e);
      }
    } else {
      //generate random keys
      keys = KeyMgmt.create(keyfile, password, "webserver", params, password);
    }
  }
}
