/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.RandomAccessFile;
import javaforce.JF;
import javaforce.JFLog;

public class DebugState
extends Thread {
    private RandomAccessFile file;
    private boolean active = true;
    private Runnable runnable;
    private StringBuilder sb = new StringBuilder();
    private static String mark = "*********************************************\n";

    public DebugState(String filename, Runnable update) {
        this.runnable = update;
        try {
            this.file = new RandomAccessFile(filename, "rw");
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void write(String msg) {
        this.sb.append(msg);
        this.sb.append("\n");
    }

    private void flush() {
        try {
            this.file.setLength(0L);
            this.file.write(this.sb.toString().getBytes());
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void cancel() {
        this.active = false;
    }

    @Override
    public void run() {
        this.setName("DebugState");
        while (this.active) {
            this.sb.setLength(0);
            this.sb.append(mark);
            try {
                this.runnable.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sb.append(mark);
            this.flush();
            JF.sleep(1000);
        }
    }
}

