/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javaforce.JFLog;

public class JSON {
    public static boolean debug = false;
    private char[] json;
    private int len;
    private int pos;

    public static Element parse(String str) throws Exception {
        Element root = new Element();
        root.key = "root";
        JSON json = new JSON();
        json.json = str.trim().toCharArray();
        json.len = json.json.length;
        json.readElement(root);
        return root;
    }

    public static Element parseStream(InputStream is) throws Exception {
        try {
            byte[] data = is.readAllBytes();
            return JSON.parse(new String(data, "UTF-8"));
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static Element parseFile(String file) throws Exception {
        try {
            FileInputStream fis = new FileInputStream(file);
            Element root = JSON.parseStream(fis);
            fis.close();
            return root;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    private void trim() {
        while (this.pos < this.len && Character.isWhitespace(this.json[this.pos])) {
            ++this.pos;
        }
    }

    private void readKey(Element e) throws Exception {
        if (debug) {
            JFLog.log("readKey:pos=" + this.pos);
        }
        boolean quote = false;
        e.key = "";
        block6: while (true) {
            char ch;
            if ((ch = this.json[this.pos++]) == '\"') {
                if (quote) {
                    quote = false;
                    continue;
                }
                if (e.key.length() > 0) {
                    throw new Exception("bad key name:" + e.key + ":pos=" + this.pos);
                }
                quote = true;
                continue;
            }
            if (quote) {
                e.key = e.key + ch;
                continue;
            }
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': {
                    if (e.key.length() <= 0) continue block6;
                    return;
                }
                case '}': {
                    --this.pos;
                    return;
                }
                case ':': {
                    if (e.key.length() == 0) {
                        throw new Exception("no key name:pos=" + this.pos);
                    }
                    --this.pos;
                    return;
                }
                case '[': 
                case ']': 
                case '{': {
                    throw new Exception("bad key name:" + ch + ":" + e.key + ":pos=" + this.pos);
                }
            }
            e.key = e.key + ch;
        }
    }

    private void readArray(Element parent) throws Exception {
        block6: {
            char next;
            char open;
            if (debug) {
                JFLog.log("readArray [");
            }
            if ((open = this.readToken()) != '[') {
                throw new Exception("bad array:pos=" + this.pos);
            }
            do {
                this.trim();
                char ch = this.json[this.pos];
                if (ch == ']') break block6;
                Element child = new Element();
                child.key = "";
                this.readValue(child, true);
                if (child.value.length() > 0 || child.children.size() > 0) {
                    if (child.value.length() > 0 && debug) {
                        JFLog.log("value=" + child.value);
                    }
                    parent.children.add(child);
                }
                if ((next = this.readToken()) == ']') break block6;
            } while (next == ',');
            throw new Exception("bad array:pos=" + this.pos);
        }
        if (debug) {
            JFLog.log("] //end of array");
        }
    }

    private void readValue(Element e, boolean array) throws Exception {
        if (debug) {
            JFLog.log("readValue:array=" + array + ":pos=" + this.pos);
        }
        boolean quote = false;
        boolean escape = false;
        e.value = "";
        block22: while (true) {
            this.trim();
            char ch = this.json[this.pos++];
            if (ch == '\"' && !escape) {
                if (quote) {
                    return;
                }
                if (e.value.length() > 0) {
                    throw new Exception("bad value:pos=" + this.pos);
                }
                quote = true;
                continue;
            }
            if (ch == '\\' && !escape) {
                escape = true;
            }
            if (quote) {
                if (escape) {
                    switch (ch) {
                        case 'n': {
                            e.value = e.value + "\n";
                            break;
                        }
                        case 'r': {
                            e.value = e.value + "\r";
                            break;
                        }
                        case 't': {
                            e.value = e.value + "\t";
                            break;
                        }
                        case 'b': {
                            e.value = e.value + "\b";
                            break;
                        }
                        case 'f': {
                            e.value = e.value + "\f";
                            break;
                        }
                        default: {
                            e.value = e.value + ch;
                        }
                    }
                    escape = false;
                    continue;
                }
                e.value = e.value + ch;
                continue;
            }
            switch (ch) {
                case ',': {
                    --this.pos;
                    return;
                }
                case ':': {
                    if (e.value.length() <= 0) continue block22;
                    throw new Exception("bad value:pos=" + this.pos);
                }
                case '{': {
                    if (e.value.length() > 0) {
                        throw new Exception("bad value:pos=" + this.pos);
                    }
                    --this.pos;
                    this.readElement(e);
                    return;
                }
                case '}': {
                    if (array) {
                        throw new Exception("bad array:pos=" + this.pos);
                    }
                    --this.pos;
                    return;
                }
                case '[': {
                    if (e.value.length() > 0) {
                        throw new Exception("bad value:pos=" + this.pos);
                    }
                    --this.pos;
                    this.readArray(e);
                    return;
                }
                case ']': {
                    if (!array) {
                        throw new Exception("bad array:pos=" + this.pos);
                    }
                    --this.pos;
                    return;
                }
            }
            if (escape) {
                switch (ch) {
                    case 'n': {
                        e.value = e.value + "\n";
                        break;
                    }
                    case 'r': {
                        e.value = e.value + "\r";
                        break;
                    }
                    case 't': {
                        e.value = e.value + "\t";
                        break;
                    }
                    case 'b': {
                        e.value = e.value + "\b";
                        break;
                    }
                    case 'f': {
                        e.value = e.value + "\f";
                        break;
                    }
                    default: {
                        e.value = e.value + ch;
                    }
                }
                escape = false;
                continue;
            }
            e.value = e.value + ch;
        }
    }

    private char readToken() throws Exception {
        this.trim();
        return this.json[this.pos++];
    }

    private void readElement(Element e) throws Exception {
        char open;
        if (debug) {
            JFLog.log("readElement {");
        }
        if ((open = this.readToken()) != '{') {
            throw new Exception("bad element:pos=" + this.pos);
        }
        while (this.pos < this.len) {
            char eq;
            this.trim();
            char ch = this.json[this.pos];
            if (ch == '}') break;
            Element child = new Element();
            this.readKey(child);
            if (debug) {
                JFLog.log("key=" + child.key);
            }
            if ((eq = this.readToken()) != ':') {
                throw new Exception("bad element:pos=" + this.pos);
            }
            this.readValue(child, false);
            if (debug) {
                JFLog.log("value=" + child.value);
            }
            e.children.add(child);
            char next = this.readToken();
            if (next == '}') break;
            if (next == ',') continue;
            throw new Exception("bad element:next=" + next + ":pos=" + this.pos);
        }
        if (debug) {
            JFLog.log("} //end of element");
        }
    }

    public static String escape(String in) {
        char[] ca;
        if (in == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (char ch : ca = in.toCharArray()) {
            if (ch < ' ') {
                sb.append(String.format("\\u%04x", ch));
                continue;
            }
            if (ch == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (ch == '\\') {
                sb.append("\\\\");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            if (args.length > 1 && args[1].equals("debug")) {
                debug = true;
            }
            Element test = JSON.parseFile(args[0]);
            test.print();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static class Element {
        public String key;
        public String value;
        public ArrayList<Element> children = new ArrayList();

        public Element getChild(String name) {
            for (Element child : this.children) {
                if (!child.key.equals(name)) continue;
                return child;
            }
            if (debug) {
                JFLog.log("JSON:Child not found:" + name);
            }
            return null;
        }

        public Element getChild(int idx) {
            return this.children.get(idx);
        }

        public int getChildCount() {
            return this.children.size();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append(this.key + "=" + this.value);
            if (this.children.size() > 0) {
                sb.append("[");
                boolean first = true;
                for (Element child : this.children) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(child.toString());
                }
                sb.append("]");
            }
            sb.append("}\r\n");
            return sb.toString();
        }

        public void print() {
            System.out.println(this.toString());
        }
    }
}

