/*
 * Decompiled with CFR 0.152.
 */
package javaforce.controls.s7;

import javaforce.controls.s7.COTP;
import javaforce.controls.s7.S7Data;
import javaforce.controls.s7.S7Header;
import javaforce.controls.s7.S7Params;
import javaforce.controls.s7.S7Types;
import javaforce.controls.s7.TPKT;

public class S7Packet {
    public static byte[] makeConnectPacket1() {
        TPKT tpkt = new TPKT();
        COTP cotp = new COTP(-32);
        int size = tpkt.size() + cotp.size();
        byte[] data = new byte[size];
        int dataoff = 0;
        tpkt.write(data, dataoff, (short)size);
        cotp.write(data, dataoff += tpkt.size());
        return data;
    }

    public static byte[] makeConnectPacket2() {
        TPKT tpkt = new TPKT();
        COTP cotp = new COTP(-16);
        S7Header header = new S7Header();
        S7Params params = new S7Params();
        params.makeConnect();
        int size = tpkt.size() + cotp.size() + header.size() + params.size();
        byte[] data = new byte[size];
        int dataoff = 0;
        tpkt.write(data, dataoff, (short)size);
        cotp.write(data, dataoff += tpkt.size());
        header.write(data, dataoff += cotp.size(), (short)params.size(), (short)0);
        params.write(data, dataoff += header.size());
        return data;
    }

    public static byte[] makeReadPacket(S7Data s7) {
        TPKT tpkt = new TPKT();
        COTP cotp = new COTP(-16);
        S7Header header = new S7Header();
        S7Params params = new S7Params();
        params.makeRead(s7);
        int size = tpkt.size() + cotp.size() + header.size() + params.size();
        byte[] data = new byte[size];
        int dataoff = 0;
        tpkt.write(data, dataoff, (short)size);
        cotp.write(data, dataoff += tpkt.size());
        header.write(data, dataoff += cotp.size(), (short)params.size(), (short)0);
        params.write(data, dataoff += header.size());
        return data;
    }

    public static byte[] makeReadPacket(S7Data[] s7) {
        TPKT tpkt = new TPKT();
        COTP cotp = new COTP(-16);
        S7Header header = new S7Header();
        S7Params params = new S7Params();
        params.makeRead(s7);
        int size = tpkt.size() + cotp.size() + header.size() + params.size();
        byte[] data = new byte[size];
        int dataoff = 0;
        tpkt.write(data, dataoff, (short)size);
        cotp.write(data, dataoff += tpkt.size());
        header.write(data, dataoff += cotp.size(), (short)params.size(), (short)0);
        params.write(data, dataoff += header.size());
        return data;
    }

    public static byte[] makeWritePacket(S7Data type) {
        TPKT tpkt = new TPKT();
        COTP cotp = new COTP(-16);
        S7Header header = new S7Header();
        S7Params params = new S7Params();
        params.makeWrite(type.block_type, type.block_number, type.data_type, type.offset, type.length, type.data);
        int size = tpkt.size() + cotp.size() + header.size() + params.size();
        byte[] data = new byte[size];
        int dataoff = 0;
        tpkt.write(data, dataoff, (short)size);
        cotp.write(data, dataoff += tpkt.size());
        header.write(data, dataoff += cotp.size(), (short)(params.size() - 4 - type.data.length), (short)(4 + type.data.length));
        params.write(data, dataoff += header.size());
        return data;
    }

    public static S7Data decodeAddress(String addr) {
        int offset;
        S7Data data = new S7Data();
        if (addr.startsWith("DB")) {
            data.block_type = (byte)-124;
            int idx = addr.indexOf(46);
            data.block_number = Integer.valueOf(addr.substring(2, idx));
            addr = addr.substring(idx + 2);
        } else if (addr.startsWith("M")) {
            data.block_type = (byte)-125;
        } else if (addr.startsWith("I")) {
            data.block_type = (byte)-127;
        } else if (addr.startsWith("Q")) {
            data.block_type = (byte)-126;
        } else {
            return null;
        }
        data.data_type = S7Types.getType(addr.charAt(1));
        int idx = addr.indexOf(46);
        if (idx == -1) {
            idx = addr.indexOf(32);
        }
        if (idx == -1) {
            idx = addr.length();
        }
        if (data.data_type == 0) {
            offset = Integer.valueOf(addr.substring(1, idx));
            data.data_type = 1;
        } else {
            offset = Integer.valueOf(addr.substring(2, idx));
        }
        data.offset = offset << 3;
        if (data.data_type == 1) {
            int idx2 = addr.indexOf(32);
            if (idx2 == -1) {
                idx2 = addr.length();
            }
            byte bit = Byte.valueOf(addr.substring(idx + 1, idx2));
            data.offset += bit;
        }
        data.length = 1;
        idx = addr.indexOf(" BIT ");
        if (idx != -1) {
            data.length = Integer.valueOf(addr.substring(idx + 5));
        }
        if ((idx = addr.indexOf(" BYTE ")) != -1) {
            data.data_type = (byte)2;
            data.length = Integer.valueOf(addr.substring(idx + 6));
        }
        if ((idx = addr.indexOf(" CHAR ")) != -1) {
            data.data_type = (byte)3;
            data.length = Integer.valueOf(addr.substring(idx + 6));
        }
        if ((idx = addr.indexOf(" WORD ")) != -1) {
            data.data_type = (byte)4;
            data.length = Integer.valueOf(addr.substring(idx + 6));
        }
        if ((idx = addr.indexOf(" INT ")) != -1) {
            data.data_type = (byte)5;
            data.length = Integer.valueOf(addr.substring(idx + 5));
        }
        if ((idx = addr.indexOf(" DWORD ")) != -1) {
            data.data_type = (byte)6;
            data.length = Integer.valueOf(addr.substring(idx + 7));
        }
        if ((idx = addr.indexOf(" DINT ")) != -1) {
            data.data_type = (byte)7;
            data.length = Integer.valueOf(addr.substring(idx + 6));
        }
        if ((idx = addr.indexOf(" REAL ")) != -1) {
            data.data_type = (byte)8;
            data.length = Integer.valueOf(addr.substring(idx + 6));
        }
        return data;
    }

    public static S7Data decodePacket(byte[] packet) {
        try {
            S7Data data = new S7Data();
            int offset = 0;
            TPKT tpkt = new TPKT();
            tpkt.read(packet, offset);
            COTP cotp = new COTP();
            cotp.read(packet, offset += tpkt.size());
            if (cotp.PDU_type == -32) {
                return data;
            }
            if (cotp.PDU_type == -48) {
                return data;
            }
            S7Header header = new S7Header();
            header.read(packet, offset += cotp.size());
            S7Params params = new S7Params();
            if (!params.read(packet, offset += header.size(), data)) {
                return null;
            }
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static S7Data[] decodeMultiPacket(byte[] packet, int count) {
        try {
            S7Data[] data = new S7Data[count];
            for (int a = 0; a < count; ++a) {
                data[a] = new S7Data();
            }
            int offset = 0;
            TPKT tpkt = new TPKT();
            tpkt.read(packet, offset);
            COTP cotp = new COTP();
            cotp.read(packet, offset += tpkt.size());
            if (cotp.PDU_type == -32) {
                return data;
            }
            if (cotp.PDU_type == -48) {
                return data;
            }
            S7Header header = new S7Header();
            header.read(packet, offset += cotp.size());
            S7Params params = new S7Params();
            params.read(packet, offset += header.size(), data);
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isPacketComplete(byte[] packet) {
        return S7Packet.decodePacket(packet) != null;
    }
}

