/*
 * Decompiled with CFR 0.152.
 */
package javaforce.gl.model;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javaforce.BE;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.LE;
import javaforce.gl.Model;
import javaforce.gl.Object3;
import javaforce.gl.UVMap;
import javaforce.gl.model.Model_IO;

public class ModelBLEND
implements Model_IO {
    public static boolean debug = false;
    public static boolean debugDNA = false;
    public static boolean debugScene = false;
    public static boolean debugCD = false;
    public static boolean debugCDProp = false;
    private byte[] data;
    private int datapos;
    private boolean x64;
    private boolean le;
    private Model model;
    private Object3 obj;
    private float[] org = new float[3];
    private boolean haveDups;
    private HashMap<Long, Chunk> chunk_map = new HashMap();
    private static final int ID_ME = 17741;
    private static final int ID_OB = 16975;
    private static final int ID_SC = 17235;
    private static final int ID_BR = 21058;
    private static final int ID_WM = 19799;
    private static final int ID_SN = 20051;
    private static final int ID_LS = 21324;
    private static final int ID_WO = 20311;
    private static final int ID_DNA1 = 826363460;
    private static final int ID_DATA = 0x41544144;
    private static final int OB_MESH = 1;
    private static final int CD_MVERT = 0;
    private static final int CD_MSTICKY = 1;
    private static final int CD_MDEFORMVERT = 2;
    private static final int CD_MEDGE = 3;
    private static final int CD_MFACE = 4;
    private static final int CD_MTFACE = 5;
    private static final int CD_MCOL = 6;
    private static final int CD_ORIGINDEX = 7;
    private static final int CD_NORMAL = 8;
    private static final int CD_PROP_FLT = 10;
    private static final int CD_PROP_INT = 11;
    private static final int CD_PROP_STR = 12;
    private static final int CD_ORIGSPACE = 13;
    private static final int CD_ORCO = 14;
    private static final int CD_MTEXPOLY = 15;
    private static final int CD_MLOOPUV = 16;
    private static final int CD_MLOOPCOL = 17;
    private static final int CD_TANGENT = 18;
    private static final int CD_MDISPS = 19;
    private static final int CD_PREVIEW_MCOL = 20;
    private static final int CD_ID_MCOL = 21;
    private static final int CD_TEXTURE_MCOL = 22;
    private static final int CD_CLOTH_ORCO = 23;
    private static final int CD_RECAST = 24;
    private static final int CD_MPOLY = 25;
    private static final int CD_MLOOP = 26;
    private static final int CD_SHAPE_KEYINDEX = 27;
    private static final int CD_SHAPEKEY = 28;
    private static final int CD_BWEIGHT = 29;
    private static final int CD_CREASE = 30;
    private static final int CD_ORIGSPACE_MLOOP = 31;
    private static final int CD_PREVIEW_MLOOPCOL = 32;
    private static final int CD_BM_ELEM_PYPTR = 33;
    private static final int CD_PAINT_MASK = 34;
    private static final int CD_GRID_PAINT_MASK = 35;
    private static final int CD_MVERT_SKIN = 36;
    private static final int CD_FREESTYLE_EDGE = 37;
    private static final int CD_FREESTYLE_FACE = 38;
    private static final int CD_MLOOPTANGENT = 39;
    private static final int CD_TESSLOOPNORMAL = 40;
    private static final int CD_CUSTOMLOOPNORMAL = 41;
    private static final int CD_SCULPT_FACE_SETS = 42;
    private static final int CD_LOCATION = 43;
    private static final int CD_RADIUS = 44;
    private static final int CD_PROP_INT8 = 45;
    private static final int CD_PROP_INT32_2D = 46;
    private static final int CD_PROP_COLOR = 47;
    private static final int CD_PROP_FLOAT3 = 48;
    private static final int CD_PROP_FLOAT2 = 49;
    private static final int CD_PROP_BOOL = 50;
    private static final int CD_HAIRLENGTH = 51;
    private static final int CD_PROP_QUATERNION = 52;
    private static final int CD_NUMTYPES = 53;
    private ArrayList<String> names = new ArrayList();
    private ArrayList<String> types = new ArrayList();
    private ArrayList<Short> typelen = new ArrayList();
    private ArrayList<struct> structs = new ArrayList();

    private struct getStruct(String name) throws Exception {
        for (int a = 0; a < this.structs.size(); ++a) {
            struct s = this.structs.get(a);
            if (!s.name.equals(name)) continue;
            return s;
        }
        throw new Exception("struct not found:" + name);
    }

    private int calcMemberSize(member m) {
        if (m.name.startsWith("*")) {
            if (this.x64) {
                return 8;
            }
            return 4;
        }
        if (m.name.indexOf("[") != -1) {
            String[] f = m.name.replaceAll("\\]", "").split("\\[");
            if (f.length == 2) {
                return m.typelen * Integer.valueOf(f[1]);
            }
            return m.typelen * Integer.valueOf(f[1]) * Integer.valueOf(f[2]);
        }
        return m.typelen;
    }

    public Model load(String filename) {
        try {
            FileInputStream is = new FileInputStream(filename);
            Model model = this.loadBlend(is);
            ((InputStream)is).close();
            return model;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Model load(InputStream is) {
        try {
            return this.loadBlend(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean eof() {
        return this.datapos >= this.data.length;
    }

    private byte readuint8() {
        byte uint8 = this.data[this.datapos++];
        return uint8;
    }

    private short readuint16() {
        int uint16 = this.le ? LE.getuint16(this.data, this.datapos) : BE.getuint16(this.data, this.datapos);
        this.datapos += 2;
        return (short)uint16;
    }

    private int readuint32() {
        int uint32 = this.le ? LE.getuint32(this.data, this.datapos) : BE.getuint32(this.data, this.datapos);
        this.datapos += 4;
        return uint32;
    }

    private long readuint64() {
        long uint64 = this.le ? LE.getuint64(this.data, this.datapos) : BE.getuint64(this.data, this.datapos);
        this.datapos += 8;
        return uint64;
    }

    private long readptr() {
        if (this.x64) {
            return this.readuint64();
        }
        return this.readuint32();
    }

    private void readByteArray(byte[] in) {
        System.arraycopy(this.data, this.datapos, in, 0, in.length);
        this.datapos += in.length;
    }

    private void readPtrArray(long[] in) {
        for (int a = 0; a < in.length; ++a) {
            in[a] = this.readptr();
        }
    }

    private void readFloatArray(float[] in) {
        for (int a = 0; a < in.length; ++a) {
            in[a] = this.readfloat();
        }
    }

    private float readfloat() {
        return Float.intBitsToFloat(this.readuint32());
    }

    private String readString(int len) {
        int sl = this.strlen(this.data, this.datapos, len);
        String str = new String(this.data, this.datapos, sl);
        this.datapos += len;
        return str;
    }

    private String readString() {
        int sl = this.strlen(this.data, this.datapos, this.data.length - this.datapos);
        String str = new String(this.data, this.datapos, sl);
        this.datapos += sl + 1;
        return str;
    }

    private void setData(byte[] in) {
        this.data = in;
        this.datapos = 0;
    }

    private Context pushData() {
        Context ctx = new Context();
        ctx.data = this.data;
        ctx.datapos = this.datapos;
        return ctx;
    }

    private void popData(Context ctx) {
        this.data = ctx.data;
        this.datapos = ctx.datapos;
    }

    private int strlen(byte[] str, int offset, int max) {
        for (int a = 0; a < max; ++a) {
            if (str[a + offset] != 0) continue;
            return a;
        }
        return max;
    }

    private Chunk findChunkByPtr(long ptr) {
        if (ptr == 0L) {
            return null;
        }
        Chunk chunk = this.chunk_map.get(ptr);
        if (chunk == null) {
            return null;
        }
        if (chunk.dup) {
            int cnt = chunk.dupidx++;
            for (int a = 0; a < cnt; ++a) {
                chunk = chunk.nextdup;
            }
        }
        return chunk;
    }

    private Model loadBlend(InputStream is) throws Exception {
        Chunk[] chunks;
        this.setData(JF.readAll(is));
        if (this.data.length < 12) {
            throw new Exception("BLEND:File too small");
        }
        this.model = new Model();
        if (!new String(this.data, 0, 7).equals("BLENDER")) {
            throw new Exception("Not a blender file");
        }
        switch (this.data[7]) {
            case 45: {
                this.x64 = true;
                break;
            }
            case 95: {
                this.x64 = false;
                break;
            }
            default: {
                throw new Exception("BLEND:Unknown bit size");
            }
        }
        switch (this.data[8]) {
            case 118: {
                this.le = true;
                break;
            }
            case 86: {
                this.le = false;
                break;
            }
            default: {
                throw new Exception("BLEND:Unknown Endianness");
            }
        }
        String version = new String(this.data, 9, 3);
        JFLog.log("Blender file version:" + version);
        int ver = Integer.valueOf(version);
        if (ver < 263) {
            throw new Exception("Error:Blender file too old, can not read.");
        }
        this.datapos = 12;
        while (!this.eof()) {
            Chunk chunk = new Chunk();
            chunk.filepos = this.datapos;
            chunk.read();
            Chunk ochunk = this.chunk_map.get(chunk.ptr);
            if (ochunk != null) {
                if (!this.haveDups) {
                    JFLog.log("Warning:This file contains duplicate BHeads.");
                    this.haveDups = true;
                }
                ochunk.dup = true;
                while (ochunk.nextdup != null) {
                    ochunk = ochunk.nextdup;
                }
                ochunk.nextdup = chunk;
                continue;
            }
            this.chunk_map.put(chunk.ptr, chunk);
        }
        int chunkCnt = this.chunk_map.size();
        for (Chunk chunk : chunks = this.chunk_map.values().toArray(new Chunk[chunkCnt])) {
            if (chunk.id != 826363460) continue;
            if (debug) {
                JFLog.log("Blend:ID_DNA1 @ " + chunk.ptr);
            }
            this.setData(chunk.raw);
            String SDNA = this.readString(4);
            if (!SDNA.equals("SDNA")) {
                throw new Exception("Bad DNA Struct:SDNA");
            }
            String NAME = this.readString(4);
            if (!NAME.equals("NAME")) {
                throw new Exception("Bad DNA Struct:NAME");
            }
            int nr_names = this.readuint32();
            for (int a = 0; a < nr_names; ++a) {
                String str = this.readString();
                if (debugDNA) {
                    JFLog.log("DNA.name=" + str);
                }
                this.names.add(str);
            }
            this.datapos += 3;
            this.datapos &= 0xFFFFFFFC;
            String TYPE = this.readString(4);
            if (!TYPE.equals("TYPE")) {
                throw new Exception("Bad DNA Struct:TYPE");
            }
            int nr_types = this.readuint32();
            for (int a = 0; a < nr_types; ++a) {
                String str = this.readString();
                if (debugDNA) {
                    JFLog.log("DNA.type=" + str);
                }
                this.types.add(str);
            }
            this.datapos += 3;
            this.datapos &= 0xFFFFFFFC;
            String TLEN = this.readString(4);
            if (!TLEN.equals("TLEN")) {
                throw new Exception("Bad DNA Struct:TLEN");
            }
            for (int a = 0; a < nr_types; ++a) {
                this.typelen.add(this.readuint16());
            }
            this.datapos += 3;
            this.datapos &= 0xFFFFFFFC;
            String STRC = this.readString(4);
            if (!STRC.equals("STRC")) {
                throw new Exception("Bad DNA Struct:STRC");
            }
            int nr_structs = this.readuint32();
            for (int a = 0; a < nr_structs; ++a) {
                struct s = new struct();
                s.typeidx = this.readuint16();
                s.mem_nr = this.readuint16();
                s.name = this.types.get(s.typeidx);
                if (debugDNA) {
                    JFLog.log("DNA.struct:" + s.name + "==" + a);
                }
                for (int b = 0; b < s.mem_nr; ++b) {
                    member m = new member();
                    m.typelenidx = this.readuint16();
                    m.nameidx = this.readuint16();
                    m.name = this.names.get(m.nameidx);
                    m.typelen = this.typelen.get(m.typelenidx).shortValue();
                    m.size = this.calcMemberSize(m);
                    if (debugDNA) {
                        JFLog.log("  member:" + m.name + "=" + m.typelen);
                    }
                    s.members.add(m);
                }
                this.structs.add(s);
            }
            break;
        }
        for (Chunk chunk : chunks) {
            if (debugDNA) {
                JFLog.log("Chunk.id=0x" + Integer.toString(chunk.id, 16) + ",pos=0x" + Integer.toString(chunk.fileOffset, 16) + ",size=" + chunk.getSize());
            }
            if (chunk.id == 17235 && debug) {
                JFLog.log("Blend:ID_SC @ " + chunk.ptr);
            }
            if (chunk.id == 16975) {
                if (debug) {
                    JFLog.log("Blend:ID_OB @ " + chunk.ptr);
                }
                this.readObject(chunk);
            }
            if (chunk.id != 17741 || !debug) continue;
            JFLog.log("Blend:ID_ME @ " + chunk.ptr);
        }
        return this.model;
    }

    private void readObject(Chunk chunk) throws Exception {
        this.setData(chunk.raw);
        bObject bObj = new bObject();
        bObj.read();
        if (debug) {
            JFLog.log("Blend:object.type=" + bObj.type);
        }
        if (bObj.type != 1) {
            return;
        }
        this.obj = new Object3();
        this.model.addObject(this.obj);
        this.obj.name = bObj.id.name.substring(2);
        this.obj.org.x = bObj.loc[0];
        this.org[0] = bObj.loc[0];
        this.obj.org.y = bObj.loc[1];
        this.org[1] = bObj.loc[1];
        this.obj.org.z = bObj.loc[2];
        this.org[2] = bObj.loc[2];
        if (debug) {
            JFLog.log("Blend:object.name=" + this.obj.name + ",org=" + this.org[0] + "," + this.org[1] + "," + this.org[2]);
        }
        if ((chunk = this.findChunkByPtr(bObj.data)) == null) {
            throw new Exception("BLEND:Unable to find Mesh for Object");
        }
        this.readMesh(chunk);
    }

    private void readMesh(Chunk chunk) throws Exception {
        int a;
        ArrayList<Vertex> vertexList = new ArrayList<Vertex>();
        ArrayList<Integer> loopList = new ArrayList<Integer>();
        Mesh mesh = new Mesh();
        this.setData(chunk.raw);
        if (debug) {
            JFLog.log("Blend.Mesh @ " + chunk.fileOffset);
        }
        mesh.read();
        if (mesh.mvert != 0L) {
            chunk = this.findChunkByPtr(mesh.mvert);
            if (chunk == null) {
                JFLog.log("BLEND:Unable to find MVert for Mesh:" + mesh.mvert);
                mesh.mvert = 0L;
            } else {
                this.setData(chunk.raw);
                for (a = 0; a < chunk.array_nr; ++a) {
                    MVert mvert = new MVert();
                    mvert.read();
                    Vertex v = new Vertex();
                    v.xyz[0] = mvert.v[0];
                    v.xyz[1] = mvert.v[1];
                    v.xyz[2] = mvert.v[2];
                    vertexList.add(v);
                    if (!debugCDProp) continue;
                    JFLog.log("PROP_FLOAT3:" + v.xyz[0] + "," + v.xyz[1] + "," + v.xyz[2]);
                }
            }
        }
        if (mesh.mloop != 0L) {
            chunk = this.findChunkByPtr(mesh.mloop);
            if (chunk == null) {
                JFLog.log("BLEND:Unable to find MLoop for Mesh:" + mesh.mloop);
                mesh.mloop = 0L;
            } else {
                this.setData(chunk.raw);
                for (a = 0; a < chunk.array_nr; ++a) {
                    MLoop mloop = new MLoop();
                    mloop.read();
                    loopList.add(mloop.v);
                    if (!debugCDProp) continue;
                    JFLog.log("PROP_INT_LOOP:" + mloop.v);
                }
            }
        }
        if (mesh.mpoly != 0L) {
            chunk = this.findChunkByPtr(mesh.mpoly);
            if (chunk == null) {
                JFLog.log("BLEND:Unable to find MPoly for Mesh:" + mesh.mpoly);
                mesh.mpoly = 0L;
            } else {
                this.setData(chunk.raw);
                int type = -1;
                int pcnt = -1;
                int vidx = 0;
                for (int a2 = 0; a2 < chunk.array_nr; ++a2) {
                    MPoly mpoly = new MPoly();
                    mpoly.read();
                    switch (mpoly.totloop) {
                        case 3: {
                            if (type == 7) {
                                throw new Exception("BLEND:Mixed QUADS/TRIANGLES not supported");
                            }
                            type = 4;
                            pcnt = 3;
                            break;
                        }
                        case 4: {
                            if (type == 4) {
                                throw new Exception("BLEND:Mixed QUADS/TRIANGLES not supported");
                            }
                            type = 7;
                            pcnt = 4;
                            break;
                        }
                        default: {
                            throw new Exception("BLEND:Polygon not supported:nr=" + mpoly.totloop);
                        }
                    }
                    int loopidx = mpoly.loopstart;
                    if (debugCDProp) {
                        JFLog.log("PROP_INT_START:" + loopidx);
                    }
                    int[] poly = new int[1];
                    for (int p = 0; p < pcnt; ++p) {
                        int idx = loopList.get(loopidx++);
                        if (debugCDProp) {
                            JFLog.log("PROP_INT_POLY:" + idx);
                        }
                        this.obj.addVertex(vertexList.get((int)idx).xyz);
                        poly[0] = vidx++;
                        this.obj.addPoly(poly);
                    }
                }
                this.obj.type = type;
                if (debugCDProp) {
                    JFLog.log("Blend:obj.type=" + this.obj.type);
                }
            }
        }
        this.readCustomDataLayer(mesh, mesh.vdata, "vdata", vertexList, loopList);
        this.readCustomDataLayer(mesh, mesh.edata, "edata", vertexList, loopList);
        this.readCustomDataLayer(mesh, mesh.fdata, "fdata", vertexList, loopList);
        this.readCustomDataLayer(mesh, mesh.pdata, "pdata", vertexList, loopList);
        this.readCustomDataLayer(mesh, mesh.ldata, "ldata", vertexList, loopList);
    }

    private void readCustomDataLayer(Mesh mesh, CustomData cd, String name, ArrayList<Vertex> vertexList, ArrayList<Integer> loopList) throws Exception {
        if (debugCD) {
            JFLog.log("readLayer:" + name + ".layers=" + Long.toString(cd.layers, 16));
        }
        if (cd == null || cd.layers == 0L) {
            return;
        }
        Chunk raw = this.findChunkByPtr(cd.layers);
        if (raw == null) {
            throw new Exception("BLEND:Unable to find " + name + ".layers for Mesh");
        }
        this.setData(raw.raw);
        if (debugCD) {
            JFLog.log("readLayer:#layers=" + cd.totlayer + ",max=" + cd.maxlayer);
        }
        for (int a = 0; a < cd.totlayer; ++a) {
            Chunk layer_data;
            CustomDataLayer layer = new CustomDataLayer();
            layer.read();
            String layer_name = layer.name;
            if (layer.data == 0L) {
                if (!debugCD) continue;
                JFLog.log("readLayer:layer.data == null");
                continue;
            }
            if (debugCD) {
                JFLog.log("layer.name=" + layer.name);
            }
            if ((layer_data = this.findChunkByPtr(layer.data)) == null) {
                throw new Exception("BLEND:Unable to find " + name + ".layers.data for Mesh");
            }
            Context ctx = this.pushData();
            this.setData(layer_data.raw);
            if (debugCD) {
                JFLog.log("layer.data=" + Long.toString(layer.data, 16) + ",type=" + layer.type + ",a=" + a + ",nr=" + layer_data.array_nr + ",size=" + layer_data.raw.length);
            }
            switch (layer.type) {
                case 0: {
                    if (mesh.mvert != 0L) break;
                    MVert mvert = new MVert();
                    if (debugCD) {
                        JFLog.log("Vertex:" + layer_data.array_nr);
                    }
                    for (int i = 0; i < layer_data.array_nr; ++i) {
                        mvert.read();
                        Vertex v = new Vertex();
                        v.xyz[0] = mvert.v[0];
                        v.xyz[1] = mvert.v[1];
                        v.xyz[2] = mvert.v[2];
                        vertexList.add(v);
                        this.obj.addVertex(v.xyz);
                    }
                    break;
                }
                case 11: {
                    if (loopList.isEmpty()) {
                        int pcnt = -1;
                        this.obj.type = 7;
                        pcnt = 4;
                        if (debugCDProp) {
                            JFLog.log("Blend:obj.type=" + this.obj.type);
                        }
                        int[] poly = new int[pcnt];
                        int pi = 0;
                        int vidx = 0;
                        if (debugCD) {
                            JFLog.log("Poly:" + layer_data.array_nr);
                        }
                        for (int i = 0; i < layer_data.array_nr; ++i) {
                            int idx = this.readuint32();
                            if (debugCDProp) {
                                JFLog.log("PROP_INT:" + idx);
                            }
                            loopList.add(idx);
                            this.obj.addVertex(vertexList.get((int)idx).xyz);
                            poly[pi++] = vidx++;
                            if (pi != pcnt) continue;
                            this.obj.addPoly(poly);
                            pi = 0;
                        }
                    } else {
                        for (int i = 0; i < layer_data.array_nr; ++i) {
                            int idx = this.readuint32();
                            if (!debugCDProp) continue;
                            JFLog.log("PROP_INT_2:" + idx);
                        }
                    }
                    break;
                }
                case 49: {
                    if (this.obj.getUVMaps() != 0) break;
                    int tidx = this.model.addTexture("fake.png");
                    UVMap map = this.obj.createUVMap();
                    map.name = layer_name;
                    map.textureIndex = tidx;
                    float[] uv = new float[2];
                    if (debugCD) {
                        JFLog.log("UV:" + layer_data.array_nr);
                    }
                    for (int i = 0; i < layer_data.array_nr; ++i) {
                        uv[0] = this.readfloat();
                        uv[1] = this.readfloat();
                        uv[1] = 1.0f - uv[1];
                        if (debugCDProp) {
                            JFLog.log("PROP_FLOAT2:" + uv[0] + "," + uv[1]);
                        }
                        this.obj.addText(uv);
                    }
                    break;
                }
                case 48: {
                    if (mesh.mvert != 0L) break;
                    if (debugCD) {
                        JFLog.log("Vertex:" + layer_data.array_nr);
                    }
                    for (int i = 0; i < layer_data.array_nr; ++i) {
                        Vertex v = new Vertex();
                        v.xyz[0] = this.readfloat() + this.org[0];
                        v.xyz[1] = this.readfloat() + this.org[1];
                        v.xyz[2] = this.readfloat() + this.org[2];
                        if (debugCDProp) {
                            JFLog.log("PROP_FLOAT3:" + v.xyz[0] + "," + v.xyz[1] + "," + v.xyz[2]);
                        }
                        vertexList.add(v);
                    }
                    break;
                }
                case 46: {
                    if (debugCD) {
                        JFLog.log("Edge:" + layer_data.array_nr);
                    }
                    for (int i = 0; i < layer_data.array_nr; ++i) {
                        int v1 = this.readuint32();
                        int uv = this.readuint32();
                    }
                    break;
                }
                case 15: {
                    MTexPoly tex = new MTexPoly();
                    tex.read();
                    Chunk imageChunk = this.findChunkByPtr(tex.tpage);
                    if (imageChunk == null) {
                        throw new Exception("BLEND:No texture found for UVMap:" + a);
                    }
                    this.setData(imageChunk.raw);
                    Image image = new Image();
                    image.read();
                    UVMap map = a < this.obj.getUVMaps() ? this.obj.getUVMap(a) : this.obj.createUVMap();
                    String tn = image.name;
                    int tnidx = tn.lastIndexOf("/");
                    if (tnidx != -1) {
                        tn = tn.substring(tnidx + 1);
                    }
                    if ((tnidx = tn.lastIndexOf("\\")) != -1) {
                        tn = tn.substring(tnidx + 1);
                    }
                    int tidx = this.model.addTexture(tn);
                    if (debugCDProp) {
                        JFLog.log("Blend:texture=" + tn + "=" + tidx);
                    }
                    map.textureIndex = tidx;
                    map.name = layer_name;
                    if (!debugCD) break;
                    JFLog.log("texpoly=" + map.name);
                    break;
                }
                case 16: {
                    if (a >= this.obj.getUVMaps()) {
                        this.obj.createUVMap();
                    }
                    for (int i = 0; i < layer_data.array_nr; ++i) {
                        MLoopUV uv = new MLoopUV();
                        uv.read();
                        uv.uv[1] = 1.0f - uv.uv[1];
                        this.obj.addText(uv.uv, a);
                        if (!debugCDProp) continue;
                        JFLog.log("PROP_FLOAT2:" + uv.uv[0] + "," + uv.uv[1]);
                    }
                    break;
                }
            }
            this.popData(ctx);
        }
    }

    @Override
    public boolean save(Model model, OutputStream os) {
        return false;
    }

    private class struct {
        short typeidx;
        short mem_nr;
        String name;
        ArrayList<member> members = new ArrayList();

        private struct() {
        }
    }

    private class member {
        short typelenidx;
        short nameidx;
        String name;
        int typelen;
        int size;

        private member() {
        }
    }

    private class Context {
        byte[] data;
        int datapos;

        private Context() {
        }
    }

    private class Chunk {
        int id;
        int len;
        long ptr;
        int SDNAnr;
        int array_nr;
        byte[] raw;
        int filepos;
        int fileOffset;
        boolean dup;
        int dupidx;
        Chunk nextdup;

        private Chunk() {
        }

        void read() {
            this.id = ModelBLEND.this.readuint32();
            this.len = ModelBLEND.this.readuint32();
            this.ptr = ModelBLEND.this.readptr();
            this.SDNAnr = ModelBLEND.this.readuint32();
            this.array_nr = ModelBLEND.this.readuint32();
            this.fileOffset = ModelBLEND.this.datapos;
            if (this.len == 0) {
                return;
            }
            this.raw = new byte[this.len];
            ModelBLEND.this.readByteArray(this.raw);
        }

        int getSize() {
            if (this.raw == null) {
                return 0;
            }
            return this.raw.length;
        }
    }

    private class bObject {
        ID id;
        int type;
        long data;
        float[] loc;

        private bObject() {
            this.id = new ID();
            this.loc = new float[3];
        }

        void read() throws Exception {
            struct s = ModelBLEND.this.getStruct("Object");
            for (int a = 0; a < s.mem_nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("*data")) {
                    this.data = ModelBLEND.this.readptr();
                    continue;
                }
                if (m.name.equals("loc[3]")) {
                    ModelBLEND.this.readFloatArray(this.loc);
                    continue;
                }
                if (m.name.equals("type")) {
                    this.type = ModelBLEND.this.readuint16();
                    continue;
                }
                if (m.name.equals("id")) {
                    this.id.read();
                    continue;
                }
                ModelBLEND.this.datapos += m.size;
            }
        }
    }

    private class ID {
        String name;

        private ID() {
        }

        void read() throws Exception {
            struct s = ModelBLEND.this.getStruct("ID");
            for (int a = 0; a < s.mem_nr; ++a) {
                member m = s.members.get(a);
                if (m.name.startsWith("name[")) {
                    this.name = ModelBLEND.this.readString(m.size);
                    continue;
                }
                ModelBLEND.this.datapos += m.size;
            }
        }
    }

    private class Mesh {
        ID id;
        long mpoly;
        long mloop;
        long mloopuv;
        long mvert;
        CustomData vdata;
        CustomData edata;
        CustomData fdata;
        CustomData pdata;
        CustomData ldata;

        private Mesh() {
            this.id = new ID();
            this.vdata = new CustomData();
            this.edata = new CustomData();
            this.fdata = new CustomData();
            this.pdata = new CustomData();
            this.ldata = new CustomData();
        }

        void read() throws Exception {
            struct s = ModelBLEND.this.getStruct("Mesh");
            for (int a = 0; a < s.mem_nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("*mpoly")) {
                    this.mpoly = ModelBLEND.this.readptr();
                    continue;
                }
                if (m.name.equals("*mloop")) {
                    this.mloop = ModelBLEND.this.readptr();
                    continue;
                }
                if (m.name.equals("*mloopuv")) {
                    this.mloopuv = ModelBLEND.this.readptr();
                    continue;
                }
                if (m.name.equals("*mvert")) {
                    this.mvert = ModelBLEND.this.readptr();
                    continue;
                }
                if (m.name.equals("vdata") || m.name.equals("vert_data")) {
                    this.vdata.read("vdata");
                    continue;
                }
                if (m.name.equals("edata") || m.name.equals("edge_data")) {
                    this.edata.read("edata");
                    continue;
                }
                if (m.name.equals("fdata") || m.name.equals("face_data")) {
                    this.fdata.read("fdata");
                    continue;
                }
                if (m.name.equals("pdata")) {
                    this.pdata.read("pdata");
                    continue;
                }
                if (m.name.equals("ldata")) {
                    this.ldata.read("ldata");
                    continue;
                }
                if (m.name.equals("id")) {
                    this.id.read();
                    continue;
                }
                ModelBLEND.this.datapos += m.size;
            }
        }
    }

    private class MVert {
        float[] v = new float[3];

        private MVert() {
        }

        void read() throws Exception {
            struct s = ModelBLEND.this.getStruct("MVert");
            for (int a = 0; a < s.mem_nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("co[3]")) {
                    for (int b = 0; b < 3; ++b) {
                        this.v[b] = ModelBLEND.this.readfloat() + ModelBLEND.this.org[b];
                    }
                    continue;
                }
                ModelBLEND.this.datapos += m.size;
            }
        }
    }

    private class Vertex {
        float[] xyz = new float[3];

        private Vertex() {
        }
    }

    private class MLoop {
        int v;

        private MLoop() {
        }

        void read() throws Exception {
            struct s = ModelBLEND.this.getStruct("MLoop");
            for (int a = 0; a < s.mem_nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("v")) {
                    this.v = ModelBLEND.this.readuint32();
                    continue;
                }
                ModelBLEND.this.datapos += m.size;
            }
        }
    }

    private class MPoly {
        int loopstart;
        int totloop;

        private MPoly() {
        }

        void read() throws Exception {
            struct s = ModelBLEND.this.getStruct("MPoly");
            for (int a = 0; a < s.mem_nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("loopstart")) {
                    this.loopstart = ModelBLEND.this.readuint32();
                    continue;
                }
                if (m.name.equals("totloop")) {
                    this.totloop = ModelBLEND.this.readuint32();
                    continue;
                }
                ModelBLEND.this.datapos += m.size;
            }
        }
    }

    private class CustomData {
        long layers;
        int totlayer;
        int maxlayer;

        private CustomData() {
        }

        void read(String name) throws Exception {
            struct s = ModelBLEND.this.getStruct("CustomData");
            for (int a = 0; a < s.mem_nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("*layers")) {
                    this.layers = ModelBLEND.this.readptr();
                    continue;
                }
                if (m.name.equals("totlayer")) {
                    this.totlayer = ModelBLEND.this.readuint32();
                    continue;
                }
                if (m.name.equals("maxlayer")) {
                    this.maxlayer = ModelBLEND.this.readuint32();
                    continue;
                }
                ModelBLEND.this.datapos += m.size;
            }
        }
    }

    private class CustomDataLayer {
        int type;
        String name;
        long data;

        private CustomDataLayer() {
        }

        void read() throws Exception {
            struct s = ModelBLEND.this.getStruct("CustomDataLayer");
            for (int a = 0; a < s.mem_nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("type")) {
                    this.type = ModelBLEND.this.readuint32();
                    continue;
                }
                if (m.name.startsWith("name[")) {
                    this.name = ModelBLEND.this.readString(m.size);
                    continue;
                }
                if (m.name.equals("*data")) {
                    this.data = ModelBLEND.this.readptr();
                    continue;
                }
                ModelBLEND.this.datapos += m.size;
            }
        }
    }

    private class MTexPoly {
        long tpage;

        private MTexPoly() {
        }

        void read() throws Exception {
            struct s = ModelBLEND.this.getStruct("MTexPoly");
            for (int a = 0; a < s.mem_nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("*tpage")) {
                    this.tpage = ModelBLEND.this.readptr();
                    continue;
                }
                ModelBLEND.this.datapos += m.size;
            }
        }
    }

    private class Image {
        ID id;
        String name;

        private Image() {
            this.id = new ID();
        }

        void read() throws Exception {
            struct s = ModelBLEND.this.getStruct("Image");
            for (int a = 0; a < s.mem_nr; ++a) {
                member m = s.members.get(a);
                if (m.name.startsWith("name[")) {
                    this.name = ModelBLEND.this.readString(m.size);
                    continue;
                }
                if (m.name.equals("id")) {
                    this.id.read();
                    continue;
                }
                ModelBLEND.this.datapos += m.size;
            }
        }
    }

    private class MLoopUV {
        float[] uv = new float[2];

        private MLoopUV() {
        }

        void read() throws Exception {
            struct s = ModelBLEND.this.getStruct("MLoopUV");
            for (int a = 0; a < s.mem_nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("uv[2]")) {
                    this.uv[0] = ModelBLEND.this.readfloat();
                    this.uv[1] = ModelBLEND.this.readfloat();
                    continue;
                }
                ModelBLEND.this.datapos += m.size;
            }
        }
    }

    private class Base {
        long next;
        long prev;
        long object;

        private Base() {
        }

        void read() throws Exception {
            struct s = ModelBLEND.this.getStruct("Base");
            for (int a = 0; a < s.mem_nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("*next")) {
                    this.next = ModelBLEND.this.readptr();
                    continue;
                }
                if (m.name.equals("*prev")) {
                    this.prev = ModelBLEND.this.readptr();
                    continue;
                }
                if (m.name.equals("*object")) {
                    this.object = ModelBLEND.this.readptr();
                    continue;
                }
                ModelBLEND.this.datapos += m.size;
            }
        }
    }

    private class Scene {
        long first;
        long last;

        private Scene() {
        }

        void read() throws Exception {
            struct s = ModelBLEND.this.getStruct("Scene");
            block6: for (int a = 0; a < s.mem_nr; ++a) {
                member m = s.members.get(a);
                if (debugScene) {
                    JFLog.log("  member:" + m.name + ",size=" + m.size);
                }
                switch (m.name) {
                    case "base": {
                        this.first = ModelBLEND.this.readptr();
                        this.last = ModelBLEND.this.readptr();
                        if (!debug) continue block6;
                        JFLog.log("  scene.first=" + this.first + ",last=" + this.last);
                        continue block6;
                    }
                    default: {
                        ModelBLEND.this.datapos += m.size;
                    }
                }
            }
        }
    }

    private class UV {
        float[] uv = new float[2];

        private UV() {
        }
    }
}

