/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javaforce.JF;
import javaforce.awt.JFAWT;
import javaforce.awt.JFImage;
import javaforce.awt.ViewLog;
import javaforce.awt.security.KeyMgr;
import javaforce.jbus.JBusClient;
import javaforce.service.SOCKSServer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class SOCKSApp
extends JFrame {
    private JTextArea config;
    private JButton gen_keys;
    private JButton help;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton key_mgr;
    private JButton save;
    private JButton viewLog;
    public ViewLog viewer;
    public JBusClient busClient;
    public KeyMgr keymgr;

    public SOCKSApp() {
        this.initComponents();
        JFImage img = new JFImage();
        img.loadPNG(this.getClass().getResourceAsStream("/javaforce/icons/socks.png"));
        this.setIconImage(img.getImage());
        new Thread(){

            @Override
            public void run() {
                Random r = new Random();
                SOCKSApp.this.busClient = new JBusClient("net.sf.jfsocks.client" + r.nextInt(), new JBusMethods());
                SOCKSApp.this.busClient.setPort(SOCKSServer.getBusPort());
                SOCKSApp.this.busClient.start();
                SOCKSApp.this.busClient.call("net.sf.jfsocks", "getConfig", "\"" + SOCKSApp.this.busClient.pack + "\"");
            }
        }.start();
        JFAWT.centerWindow(this);
    }

    public void writeConfig() {
        this.busClient.call("net.sf.jfsocks", "setConfig", JBusClient.quote(JBusClient.encodeString(this.config.getText())));
    }

    public void restart() {
        this.busClient.call("net.sf.jfsocks", "restart", "");
    }

    private void initComponents() {
        this.save = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.config = new JTextArea();
        this.jLabel1 = new JLabel();
        this.viewLog = new JButton();
        this.gen_keys = new JButton();
        this.help = new JButton();
        this.key_mgr = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("SOCKS Server");
        this.save.setText("Save");
        this.save.setEnabled(false);
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SOCKSApp.this.saveActionPerformed(evt);
            }
        });
        this.config.setColumns(20);
        this.config.setRows(5);
        this.config.setText(" [ loading ... ]\n");
        this.config.setEnabled(false);
        this.jScrollPane1.setViewportView(this.config);
        this.jLabel1.setText("SOCKS Configuration:");
        this.viewLog.setText("View Log");
        this.viewLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SOCKSApp.this.viewLogActionPerformed(evt);
            }
        });
        this.gen_keys.setText("Generate SSL Key");
        this.gen_keys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SOCKSApp.this.gen_keysActionPerformed(evt);
            }
        });
        this.help.setText("Help");
        this.help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SOCKSApp.this.helpActionPerformed(evt);
            }
        });
        this.key_mgr.setText("Key Manager");
        this.key_mgr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SOCKSApp.this.key_mgrActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 583, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.viewLog).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.key_mgr).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gen_keys).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.help).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.save)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 424, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.save).addComponent(this.viewLog).addComponent(this.gen_keys).addComponent(this.help).addComponent(this.key_mgr)).addContainerGap()));
        this.pack();
    }

    private void saveActionPerformed(ActionEvent evt) {
        this.writeConfig();
        this.restart();
        JFAWT.showMessage("Notice", "Settings saved!");
    }

    private void viewLogActionPerformed(ActionEvent evt) {
        this.showViewLog();
    }

    private void gen_keysActionPerformed(ActionEvent evt) {
        this.genKeys();
    }

    private void helpActionPerformed(ActionEvent evt) {
        this.showHelp();
    }

    private void key_mgrActionPerformed(ActionEvent evt) {
        this.keymgr();
    }

    public static void main(String[] args) {
        String[] stringArray = args;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String arg;
            switch (arg = stringArray[i]) {
                case "createKeys": {
                    SOCKSServer.createKeys();
                    System.exit(0);
                }
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SOCKSApp().setVisible(true);
            }
        });
    }

    public void showViewLog() {
        if (this.viewer == null || this.viewer.isClosed) {
            this.viewer = new ViewLog(SOCKSServer.getLogFile());
            this.viewer.setTitle("SOCKS Log");
        }
        this.viewer.setVisible(true);
    }

    private void genKeys() {
        this.busClient.call("net.sf.jfsocks", "genKeys", "\"" + this.busClient.pack + "\"");
    }

    private void showHelp() {
        JFAWT.openURL("http://pquiring.github.io/javaforce/projects/jfsocks/docs/help.html");
    }

    public static String getKeyFile() {
        return JF.getConfigPath() + "/jfsocks.key";
    }

    private void keymgr() {
        if (this.keymgr != null) {
            return;
        }
        this.busClient.call("net.sf.jfsocks", "getKeys", "\"" + this.busClient.pack + "\"");
    }

    public class JBusMethods {
        public void getConfig(final String cfg) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SOCKSApp.this.config.setText(JBusClient.decodeString(cfg));
                    SOCKSApp.this.config.setEnabled(true);
                    SOCKSApp.this.save.setEnabled(true);
                }
            });
        }

        public void genKeysStatus(final String status) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (status.equals("OK")) {
                        JFAWT.showMessage("GenKeys", "OK");
                    } else {
                        JFAWT.showError("GenKeys", "Error");
                    }
                }
            });
        }

        public void giveKeys(final String str) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SOCKSApp.this.keymgr != null) {
                        return;
                    }
                    String tmpfile = JF.getUserPath() + "/.jfsocks-edit.key";
                    byte[] data = JBusClient.decodeByteArray(str);
                    JF.writeFile(tmpfile, data);
                    SOCKSApp.this.keymgr = new KeyMgr(tmpfile, "password");
                    SOCKSApp.this.keymgr.setRootAlias("jfsocks");
                    SOCKSApp.this.keymgr.setVisible(true);
                    SOCKSApp.this.keymgr = null;
                    data = JF.readFile(tmpfile);
                    SOCKSApp.this.busClient.call("net.sf.jfsocks", "setKeys", "\"" + SOCKSApp.this.busClient.pack + "\"," + JBusClient.encodeByteArray(data));
                }
            });
        }

        public void setKeysStatus(final String status) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (status.equals("OK")) {
                        JFAWT.showMessage("SetKeys", "OK");
                    } else {
                        JFAWT.showError("SetKeys", "Error");
                    }
                }
            });
        }
    }
}

