/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.Container;
import javaforce.webui.HTMLContainer;
import javaforce.webui.event.Changed;
import javaforce.webui.event.Click;

public class CheckBox
extends Container {
    private HTMLContainer input = new HTMLContainer("input");
    private HTMLContainer label;
    private boolean selected;

    public CheckBox(String text) {
        this.input.setEnclosed(false);
        this.input.addAttr("type", "checkbox");
        this.input.addEvent("onchange", "onCheckBoxChange(event, this);");
        this.input.addChangedListener(c -> {
            this.selected = !this.selected;
            this.onChanged(new String[0]);
        });
        this.label = new HTMLContainer("label");
        this.label.setText(text);
        this.input.add(this.label);
        this.add(this.input);
        this.setClass("noselect");
    }

    @Override
    public String html() {
        this.label.addAttr("for", "'" + this.input.id + "'");
        if (this.selected) {
            this.input.addAttr("checked", null);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<div" + this.getAttrs() + ">");
        int cnt = this.count();
        for (int a = 0; a < cnt; ++a) {
            sb.append(this.get(a).html());
        }
        sb.append("</div>");
        return sb.toString();
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public void setSelected(boolean state) {
        if (this.selected == state) {
            return;
        }
        this.selected = state;
        this.input.sendEvent("setchecked", new String[]{"state=" + this.selected});
    }

    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setReadonly(boolean state) {
        this.input.setReadonly(state);
    }

    @Override
    public void setDisabled(boolean state) {
        this.input.setDisabled(state);
    }

    @Override
    public void addChangedListener(Changed handler) {
        this.input.addChangedListener(handler);
    }

    @Override
    public void addClickListener(Click handler) {
        this.input.addClickListener(handler);
    }
}

