package javaforce.awt;

/** TestEvents
 *
 * @author pquiring
 */

import java.awt.event.*;

public class TestEvents extends javax.swing.JFrame implements KeyListener, MouseListener, MouseMotionListener, MouseWheelListener {

  /**
   * Creates new form TestEvents
   */
  public TestEvents() {
    initComponents();
    keys.addKeyListener(this);
    mouse.addMouseListener(this);
    mouse.addMouseMotionListener(this);
    mouse.addMouseWheelListener(this);
    System.out.println("JAR Resource URL=" + getClass().getResource("/javaforce/icons/dhcp.png").toString());
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    keys = new javax.swing.JTextField();
    exit = new javax.swing.JButton();
    mouse = new javax.swing.JLabel();

    setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

    exit.setText("Exit");
    exit.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        exitActionPerformed(evt);
      }
    });

    mouse.setBackground(new java.awt.Color(255, 255, 0));
    mouse.setText("Mouse Events");
    mouse.setOpaque(true);

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(keys)
          .addGroup(layout.createSequentialGroup()
            .addComponent(mouse, javax.swing.GroupLayout.DEFAULT_SIZE, 321, Short.MAX_VALUE)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(exit)))
        .addContainerGap())
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addComponent(keys, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(exit)
          .addComponent(mouse))
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    pack();
  }// </editor-fold>//GEN-END:initComponents

  private void exitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitActionPerformed
    System.exit(0);
  }//GEN-LAST:event_exitActionPerformed

  /**
   * @param args the command line arguments
   */
  public static void main(String[] args) {
    /* Create and display the form */
    java.awt.EventQueue.invokeLater(new Runnable() {
      public void run() {
        new TestEvents().setVisible(true);
      }
    });
  }

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton exit;
  private javax.swing.JTextField keys;
  private javax.swing.JLabel mouse;
  // End of variables declaration//GEN-END:variables

  //KeyListener

  public void keyTyped(KeyEvent e) {
    int key = e.getKeyCode();
    int mods = e.getModifiersEx();
    System.out.println(String.format("       keyTyped:key=0x%x,mods=0x%x",key,mods));
  }

  public void keyPressed(KeyEvent e) {
    int key = e.getKeyCode();
    int mods = e.getModifiersEx();
    System.out.println(String.format("     keyPressed:key=0x%x,mods=0x%x",key,mods));
  }

  public void keyReleased(KeyEvent e) {
    int key = e.getKeyCode();
    int mods = e.getModifiersEx();
    System.out.println(String.format("    keyReleased:key=0x%x,mods=0x%x",key,mods));
  }

  //MouseListener

  public void mouseClicked(MouseEvent e) {
    int x = e.getX();
    int y = e.getY();
    int b = e.getButton();
    System.out.println(String.format("   mouseClicked:x=%d,y=%d,b=0x%x",x,y,b));
  }

  public void mousePressed(MouseEvent e) {
    int x = e.getX();
    int y = e.getY();
    int b = e.getButton();
    System.out.println(String.format("   mousePressed:x=%d,y=%d,b=0x%x",x,y,b));
  }

  public void mouseReleased(MouseEvent e) {
    int x = e.getX();
    int y = e.getY();
    int b = e.getButton();
    System.out.println(String.format("  mouseReleased:x=%d,y=%d,b=0x%x",x,y,b));
  }

  public void mouseEntered(MouseEvent e) {
    int x = e.getX();
    int y = e.getY();
    int b = e.getButton();
    System.out.println(String.format("   mouseEntered:x=%d,y=%d,b=0x%x",x,y,b));
  }

  public void mouseExited(MouseEvent e) {
    int x = e.getX();
    int y = e.getY();
    int b = e.getButton();
    System.out.println(String.format("    mouseExited:x=%d,y=%d,b=0x%x",x,y,b));
  }

  //MouseMotionListener

  public void mouseDragged(MouseEvent e) {
    int x = e.getX();
    int y = e.getY();
    int b = e.getButton();
    System.out.println(String.format("   mouseDragged:x=%d,y=%d,b=0x%x",x,y,b));
  }

  public void mouseMoved(MouseEvent e) {
    int x = e.getX();
    int y = e.getY();
    int b = e.getButton();
    System.out.println(String.format("     mouseMoved:x=%d,y=%d,b=0x%x",x,y,b));
  }

  //MouseWheelListener

  public void mouseWheelMoved(MouseWheelEvent e) {
    int x = e.getX();
    int y = e.getY();
    int b = e.getButton();
    int w = e.getWheelRotation();
    System.out.println(String.format("mouseWheelMoved:x=%d,y=%d,b=0x%x,w=%d",x,y,b,w));
  }
}
