/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt.priv;

import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.attributes.ViewBox;
import com.github.weisj.jsvg.parser.DefaultParserProvider;
import com.github.weisj.jsvg.parser.LoaderContext;
import com.github.weisj.jsvg.parser.ParserProvider;
import com.github.weisj.jsvg.parser.SVGLoader;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.OutputStream;
import javaforce.Base64;
import javaforce.JFLog;
import javaforce.ui.Dimension;

public class svg {
    public static int[] load(InputStream in, Dimension size) {
        SVGLoader loader = new SVGLoader();
        SVGDocument svgDocument = loader.load(in, null, LoaderContext.builder().parserProvider((ParserProvider)new DefaultParserProvider()).build());
        BufferedImage image = new BufferedImage(size.width, size.height, 2);
        svgDocument.render((Component)null, (Graphics2D)image.getGraphics(), new ViewBox(0.0f, 0.0f, (float)size.width, (float)size.height));
        int[] px = new int[size.width * size.height];
        image.getRGB(0, 0, size.width, size.height, px, 0, size.width);
        return px;
    }

    public static boolean save(OutputStream out, byte[] png_data, Dimension size) {
        int w = size.width;
        int h = size.height;
        try {
            out.write("<?xml version='1.0' encoding='UTF-8' standalone='no'?>".getBytes());
            out.write(("<svg xmlns:xlink='http://www.w3.org/1999/xlink' version='1.1' width='" + w + "' height='" + h + "'>").getBytes());
            out.write(("<image width='" + w + "' height='" + h + "' x='0' y='0' ").getBytes());
            out.write("xlink:href='data:image/png;base64,".getBytes());
            out.write(Base64.encode(png_data, 76));
            out.write("'/>".getBytes());
            out.write("</svg>".getBytes());
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        return true;
    }
}

