/*
 * Decompiled with CFR 0.152.
 */
package javaforce.gl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javaforce.JFLog;
import javaforce.gl.GL;
import javaforce.ui.Image;

public class Texture {
    public Image image;
    public int refcnt = 0;
    public int tid = -1;
    public boolean loaded;
    public int idx;
    public String name;
    private static boolean mipmaps = false;

    public Texture(int idx) {
        this.image = new Image();
        this.loaded = false;
        this.idx = idx;
    }

    public Texture(int idx, int width, int height) {
        this.image = new Image(width, height);
        this.loaded = false;
        this.idx = idx;
    }

    public Image getImage() {
        return this.image;
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public void set(int[] pixels, int x, int y) {
        this.image.setSize(x, y);
        this.image.putPixels(pixels, 0, 0, x, y, 0);
    }

    public void setImage(Image img) {
        this.image = img;
    }

    public boolean loadPNG(String filename) {
        JFLog.log("Loading Texture:" + filename.toString());
        try {
            return this.loadPNG(new FileInputStream(filename));
        }
        catch (FileNotFoundException e) {
            JFLog.log("File not found:" + filename);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean loadPNG(InputStream is) {
        return this.image.loadPNG(is);
    }

    public boolean loadJPG(String filename) {
        JFLog.log("Loading Texture:" + filename.toString());
        try {
            return this.loadJPG(new FileInputStream(filename));
        }
        catch (FileNotFoundException e) {
            JFLog.log("File not found:" + filename);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean loadJPG(InputStream is) {
        return this.image.loadJPG(is);
    }

    public boolean load() {
        if (this.tid == -1) {
            int[] id = new int[]{-1};
            GL.glGenTextures(1, id);
            if (id[0] == -1) {
                JFLog.log("glGenTextures failed:Error=0x" + Integer.toString(GL.glGetError(), 16));
                return false;
            }
            this.tid = id[0];
        }
        if (this.loaded) {
            return true;
        }
        GL.glActiveTexture(33984 + this.idx);
        GL.glBindTexture(3553, this.tid);
        GL.glTexParameteri(3553, 10242, 10497);
        GL.glTexParameteri(3553, 10243, 10497);
        if (mipmaps) {
            GL.glTexParameteri(3553, 10240, 9984);
            GL.glTexParameteri(3553, 10241, 9984);
        } else {
            GL.glTexParameteri(3553, 10240, 9728);
            GL.glTexParameteri(3553, 10241, 9728);
        }
        GL.glTexImage2D(3553, 0, 6408, this.image.getWidth(), this.image.getHeight(), 0, 32993, 5121, this.image.getBuffer());
        this.loaded = true;
        return true;
    }

    public void unload() {
        if (this.tid == -1) {
            return;
        }
        int[] id = new int[]{this.tid};
        GL.glDeleteTextures(1, id);
        this.tid = -1;
    }

    public void bind() {
        GL.glActiveTexture(33984 + this.idx);
        GL.glBindTexture(3553, this.tid);
    }
}

