/*
 * Decompiled with CFR 0.152.
 */
package javaforce.lxc;

import java.util.ArrayList;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.ShellProcess;
import javaforce.jni.lnx.LnxPty;
import javaforce.lxc.LxcContainer;
import javaforce.lxc.LxcContainerManager;
import javaforce.lxc.LxcImage;
import javaforce.lxc.LxcOption;

public class Docker
implements LxcContainerManager {
    @Override
    public LxcImage[] listImages() {
        ShellProcess sp = new ShellProcess();
        String out = sp.run(new String[]{"/usr/bin/docker", "image", "list"}, true);
        String[] lns = out.split("\n");
        ArrayList<LxcImage> images = new ArrayList<LxcImage>();
        for (int i = 1; i < lns.length; ++i) {
            String[] fs = lns[i].split("\\s+");
            if (fs.length < 3) continue;
            images.add(new DockerImage(fs[0], fs[1]).setID(fs[2]));
        }
        return images.toArray(new LxcImage[0]);
    }

    @Override
    public LnxPty pullImage(LxcImage image) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("/usr/bin/docker");
        cmd.add("image");
        cmd.add("pull");
        cmd.add(image.toString());
        cmd.add(null);
        return LnxPty.exec("/usr/bin/docker", cmd.toArray(JF.StringArrayType), LnxPty.makeEnvironment(new String[]{"TERM=xterm"}));
    }

    @Override
    public LnxPty createImage(String script_file, LxcImage image, String src_folder) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("/usr/bin/docker");
        cmd.add("build");
        cmd.add("-f");
        cmd.add(script_file);
        cmd.add("-t");
        cmd.add(image.toString());
        cmd.add(src_folder);
        cmd.add(null);
        return LnxPty.exec("/usr/bin/docker", cmd.toArray(JF.StringArrayType), LnxPty.makeEnvironment(new String[]{"TERM=xterm"}));
    }

    @Override
    public LxcContainer[] listContainers() {
        ShellProcess sp = new ShellProcess();
        String out = sp.run(new String[]{"/usr/bin/docker", "container", "list"}, true);
        String[] lns = out.split("\n");
        ArrayList<LxcContainer> containers = new ArrayList<LxcContainer>();
        for (int i = 1; i < lns.length; ++i) {
            String[] fs = lns[i].split("\\s+");
            if (fs.length < 3) continue;
            containers.add(new DockerContainer(fs[0]).setImage(new DockerImage(fs[1])));
        }
        return containers.toArray(new LxcContainer[0]);
    }

    @Override
    public LxcContainer createContainer(LxcImage image, String[] cmd) {
        return this.createContainer(image, cmd, new String[0]);
    }

    @Override
    public LxcContainer createContainer(LxcImage image, String[] cmd, LxcOption[] options) {
        ShellProcess sp = new ShellProcess();
        ArrayList<Object> cl = new ArrayList<Object>();
        cl.add("/usr/bin/docker");
        cl.add("run");
        cl.add("-itd");
        cl.add("--rm");
        if (options != null) {
            block10: for (LxcOption opt : options) {
                String value = opt.value;
                switch (opt.name) {
                    case "restart": {
                        cl.add("--restart");
                        cl.add(value);
                        continue block10;
                    }
                    case "port": {
                        String[] src_dst = opt.splitValue();
                        if (src_dst == null) continue block10;
                        cl.add("-p");
                        cl.add(value);
                        continue block10;
                    }
                    case "mount": {
                        String[] src_dst = opt.splitValue();
                        if (src_dst == null) continue block10;
                        String src = src_dst[0];
                        String dst = src_dst[1];
                        cl.add("--mount");
                        cl.add("type=bind,src=" + src + ",dst=" + dst);
                        continue block10;
                    }
                }
            }
        }
        cl.add(image.toString());
        for (int i = 0; i < cmd.length; ++i) {
            cl.add(cmd[i]);
        }
        String out = sp.run(cl.toArray(JF.StringArrayType), true);
        if (sp.getErrorLevel() != 0) {
            return null;
        }
        String[] lns = out.split("\n");
        return new DockerContainer(lns[0]);
    }

    @Override
    public LxcContainer createContainer(LxcImage image, String[] cmd, String[] options) {
        ShellProcess sp = new ShellProcess();
        ArrayList<String> cl = new ArrayList<String>();
        cl.add("/usr/bin/docker");
        cl.add("run");
        cl.add("-itd");
        cl.add("--rm");
        if (options != null) {
            for (String opt : options) {
                cl.add(opt);
            }
        }
        cl.add(image.toString());
        for (int i = 0; i < cmd.length; ++i) {
            cl.add(cmd[i]);
        }
        String out = sp.run(cl.toArray(JF.StringArrayType), true);
        if (sp.getErrorLevel() != 0) {
            JFLog.log("Docker:createContainer failed:" + out);
            return null;
        }
        String[] lns = out.split("\n");
        return new DockerContainer(lns[0]);
    }

    public static class DockerImage
    extends LxcImage {
        public static String default_repo = "docker.io";

        public DockerImage() {
        }

        public DockerImage(String mtag) {
            super(mtag);
        }

        public DockerImage(String mtag, String ver) {
            super(mtag, ver);
        }

        @Override
        public boolean delete() {
            if (this.id == null) {
                return false;
            }
            ShellProcess sp = new ShellProcess();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("/usr/bin/docker");
            cmd.add("image");
            cmd.add("rm");
            cmd.add(this.id);
            sp.run(cmd.toArray(JF.StringArrayType), true);
            return sp.getErrorLevel() == 0;
        }
    }

    public static class DockerContainer
    extends LxcContainer {
        private LnxPty pty;
        private static byte[] ctrl_p = new byte[]{16};
        private static byte[] ctrl_q = new byte[]{17};

        public DockerContainer(String id) {
            super(id);
        }

        @Override
        public LnxPty attach() {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("/usr/bin/docker");
            cmd.add("attach");
            cmd.add(this.id);
            cmd.add(null);
            this.pty = LnxPty.exec("/usr/bin/docker", cmd.toArray(JF.StringArrayType), LnxPty.makeEnvironment(new String[]{"TERM=xterm"}));
            return this.pty;
        }

        @Override
        public boolean detach() {
            if (this.pty == null) {
                return true;
            }
            JF.sleep(50);
            this.pty.write(ctrl_p);
            JF.sleep(50);
            this.pty.write(ctrl_q);
            JF.sleep(50);
            this.close();
            return true;
        }

        @Override
        public boolean close() {
            if (this.pty == null) {
                return true;
            }
            this.pty.close();
            this.pty = null;
            return true;
        }

        @Override
        public boolean restart() {
            return false;
        }

        @Override
        public boolean delete() {
            ShellProcess sp = new ShellProcess();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("/usr/bin/docker");
            cmd.add("container");
            cmd.add("rm");
            cmd.add(this.id);
            sp.run(cmd.toArray(JF.StringArrayType), true);
            return sp.getErrorLevel() == 0;
        }
    }
}

