/*
 * Decompiled with CFR 0.152.
 */
package javaforce.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.UShort;
import javaforce.net.IP4;

public class IP6 {
    public short[] ip = new short[8];
    public String device;

    public IP6() {
    }

    public IP6(String ip6) {
        this.setIP(ip6);
    }

    public IP6(String ip6, String device) {
        this.setIP(ip6);
        this.device = device;
    }

    public IP6(IP6 ip6) {
        this.setIP(ip6);
    }

    public static boolean isIP(String str) {
        int double_idx = str.indexOf("::");
        boolean compressed = double_idx != -1;
        String[] os = str.split("[:]", -1);
        if (compressed) {
            if (str.endsWith(":")) {
                return false;
            }
            if (str.indexOf("::", double_idx + 1) != -1) {
                return false;
            }
            if (os.length < 3 || os.length > 8) {
                return false;
            }
        } else if (os.length != 8) {
            return false;
        }
        try {
            for (String o : os) {
                if (o.length() > 4) {
                    return false;
                }
                if (o.equals(JF.filter(o, JF.filter_hex))) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean setIP(String str) {
        if (!IP6.isIP(str)) {
            return false;
        }
        String[] os = str.split("[:]", -1);
        try {
            int idx = 0;
            for (String o : os) {
                if (o.length() == 0) {
                    if (idx == 0) {
                        ++idx;
                        continue;
                    }
                    idx = 8 - (os.length - (idx + 1));
                    continue;
                }
                this.ip[idx++] = UShort.valueOf(o, 16);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean setIP(InetAddress addr) {
        return this.setIP(addr.getHostAddress());
    }

    public boolean setIP(IP6 o) {
        for (int a = 0; a < 8; ++a) {
            this.ip[a] = o.ip[a];
        }
        return true;
    }

    public InetAddress toInetAddress() {
        try {
            return InetAddress.getByName(this.toIP6String());
        }
        catch (Exception e) {
            JFLog.log("Error:IP6.toInetAddress() failed:" + this.toIP6String());
            return null;
        }
    }

    public String toIP6String() {
        return String.format("%04x:%04x:%04x:%04x:%04x:%04x:%04x:%04x", this.ip[0] & 0xFFFF, this.ip[1] & 0xFFFF, this.ip[2] & 0xFFFF, this.ip[3] & 0xFFFF, this.ip[4] & 0xFFFF, this.ip[5] & 0xFFFF, this.ip[6] & 0xFFFF, this.ip[7] & 0xFFFF);
    }

    public String toString() {
        return this.toIP6String();
    }

    public boolean isEmpty() {
        for (int a = 0; a < 8; ++a) {
            if (this.ip[a] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isMulticastAddress() {
        return this.toInetAddress().isMulticastAddress();
    }

    public short[] getIP() {
        short[] ip6 = new short[8];
        for (int a = 0; a < 8; ++a) {
            ip6[a] = this.ip[a];
        }
        return ip6;
    }

    public short[] getNetwork() {
        short[] subnet = new short[4];
        for (int a = 0; a < 4; ++a) {
            subnet[a] = this.ip[a];
        }
        return subnet;
    }

    public short[] getHost() {
        short[] host = new short[4];
        for (int a = 0; a < 4; ++a) {
            host[a] = this.ip[4 + a];
        }
        return host;
    }

    public boolean isIP4() {
        for (int a = 0; a < 5; ++a) {
            if (this.ip[a] == 0) continue;
            return false;
        }
        return this.ip[5] == -1;
    }

    public IP4 toIP4() {
        if (!this.isIP4()) {
            return null;
        }
        IP4 ip4 = new IP4();
        ip4.ip[0] = (byte)(this.ip[6] >>> 8);
        ip4.ip[1] = (byte)(this.ip[6] & 0xFF);
        ip4.ip[2] = (byte)(this.ip[7] >>> 8);
        ip4.ip[3] = (byte)(this.ip[7] & 0xFF);
        return ip4;
    }

    public static IP6 getLoopbackIP() {
        IP6 ip6 = new IP6();
        ip6.ip[7] = 1;
        return ip6;
    }

    public static IP6[] list(boolean up) {
        ArrayList<IP6> list = new ArrayList<IP6>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface networkInterface : Collections.list(networkInterfaces)) {
                if (networkInterface.isLoopback() || up && !networkInterface.isUp()) continue;
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                String device = networkInterface.getDisplayName();
                for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                    String ip;
                    if (!inetAddress.isSiteLocalAddress() || !IP6.isIP(ip = inetAddress.getHostAddress())) continue;
                    list.add(new IP6(ip, device));
                }
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        return list.toArray(new IP6[list.size()]);
    }

    public static IP6[] list() {
        return IP6.list(false);
    }

    public static void test(String ip) {
        IP6 ip6 = new IP6();
        ip6.setIP(ip);
        JFLog.log(IP6.isIP(ip) + "=" + ip + "=" + ip6.toString());
    }

    public static void tests() {
        IP6.test("1:2:3:4:5:6:7:8");
        IP6.test("1111:4444:7777:aaaa:bbbb:cccc:dddd:ffff");
        IP6.test("1:2:3::8");
        IP6.test("1:2::8");
        IP6.test("::8");
        IP6.test("::7:8");
        IP6.test("1.1.1.1");
        IP6.test("1111:4444:7777:aaaa:bbbb:cccc:dddd:ffff:");
        IP6.test("1111:4444:7777:aaaa:bbbb:cccc:dddd::ffff");
        IP6.test("1:2:3:::8");
        JFLog.log("loopback6=" + IP6.getLoopbackIP().toString());
        JFLog.log("loopback4=" + IP4.getLoopbackIP().toIP6().toString());
        IP4 ip4 = new IP4();
        ip4.setIP("255.255.255.0");
        JFLog.log("IP4=" + ip4.toString() + " to IP6=" + ip4.toIP6().toString() + " back IP4=" + ip4.toIP6().toIP4().toString());
        JFLog.log("IP4.loopback.toIP6.isIP4=" + IP4.getLoopbackIP().toIP6().isIP4());
    }

    private static void list_ips() {
        IP6[] list;
        for (IP6 ip : list = IP6.list()) {
            System.out.println(ip.device + "=" + ip.toString());
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage:IP6 {tests | list}");
            return;
        }
        switch (args[0]) {
            case "tests": {
                IP6.tests();
                break;
            }
            case "list": {
                IP6.list_ips();
            }
        }
    }
}

