/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ui;

import javaforce.ui.Dimension;
import javaforce.ui.Image;
import javaforce.ui.TextComponent;

public class TextField
extends TextComponent {
    private Image buffer;
    private boolean password;

    public TextField(String text) {
        super(false);
        this.setText(text);
        this.setFocusable(true);
        this.setEditable(true);
    }

    @Override
    public Dimension getMinSize() {
        int w = this.getWidth();
        int h = this.getFont().getMetrics(this.getText()).getHeight();
        return new Dimension(w, h);
    }

    @Override
    public void render(Image image) {
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        if (w == 0) {
            return;
        }
        int adv = this.getFont().getMaxAdvance();
        Dimension size = this.getFont().getMetrics(this.getText()).toDimension();
        if (size.width < this.getWidth()) {
            size.width = this.getWidth();
        }
        size.width += adv;
        if (this.buffer == null || this.buffer.getWidth() != size.width || this.buffer.getHeight() != size.height) {
            this.buffer = new Image(size.width, size.height);
        }
        image.setForeColor(this.getForeColor());
        image.drawBox(x, y, w, h);
        w -= 2;
        h -= 2;
        this.buffer.fill(0, 0, size.width, size.height, this.getBackColor().getColor());
        if (this.haveSelection()) {
            int x1 = this.getSelectionStartOffset() * adv;
            int x2 = this.getSelectionEndOffset() * adv - 1;
            int sel_width = x2 - x1 + 1;
            this.buffer.fill(x1, 0, sel_width, size.height, this.getSelectedColor().getColor());
        }
        this.buffer.setForeColor(this.getForeColor());
        if (this.password) {
            int len = this.getLength();
            StringBuilder stars = new StringBuilder();
            for (int a = 0; a < len; ++a) {
                stars.append('*');
            }
            this.buffer.drawText(0, -this.getFont().getMaxAscent(), stars.toString());
        } else {
            this.buffer.drawText(0, -this.getFont().getMaxAscent(), this.getText());
        }
        if (this.isFocused() && this.getFont().showCursor()) {
            int cx1 = this.getCursorOffset() * adv;
            int cx2 = this.isOverwrite() ? cx1 + adv - 1 : cx1 + 2;
            int cy1 = 0;
            int cy2 = this.getFont().getMaxHeight() - 1;
            int cw = cx2 - cx1 + 1;
            int ch = cy2 - cy1 + 1;
            this.buffer.fill(cx1, cy1, cw, ch);
        }
        int cx = 1;
        int cy = (size.height - this.getHeight()) / 2 + 1;
        if (this.getViewX() + w > size.width) {
            w = size.width - this.getViewX();
        }
        image.putPixelsBlend(this.buffer.getBuffer(), x + cx, y + cy, w, h, this.getViewX(), size.width, true);
    }

    public boolean isPassword() {
        return this.password;
    }

    public void setPassword(boolean state) {
        this.password = state;
    }

    public String toString() {
        return "TextField:" + this.getText();
    }
}

