/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.util.HashMap;
import javaforce.JFLog;
import javaforce.LE;
import javaforce.jni.LnxNative;

public class monitordir {
    private static int fd;
    private static boolean active;
    private static HashMap<Integer, Listener> map;
    private static final int IN_MOVED_FROM = 64;
    private static final int IN_MOVED_TO = 128;
    private static final int IN_CREATE = 256;
    private static final int IN_DELETE = 512;
    private static final int IN_DELETE_SELF = 1024;
    private static final int IN_MOVED_SELF = 2048;
    private static final int IN_ALL = 4032;

    public static boolean init() {
        try {
            fd = LnxNative.inotify_init();
            if (fd == -1) {
                throw new Exception("inotify_init failed");
            }
            new Worker().start();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static void uninit() {
        active = false;
        LnxNative.inotify_close(fd);
    }

    public static int add(String path) {
        int wd = LnxNative.inotify_add_watch(fd, path, 4032);
        return wd;
    }

    public static void remove(int wd) {
        LnxNative.inotify_rm_watch(fd, wd);
        map.remove(wd);
    }

    public static void setListener(int wd, Listener listener) {
        map.put(wd, listener);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage:jf-monitor-dir folder");
            return;
        }
        if (!monitordir.init()) {
            return;
        }
        monitordir.add(args[0]);
        try {
            new Object().wait();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        active = true;
        map = new HashMap();
    }

    public static class Worker
    extends Thread {
        @Override
        public void run() {
            while (active) {
                byte[] data = LnxNative.inotify_read(fd);
                int pos = 0;
                int siz = data.length;
                while (siz > 12) {
                    int _wd = LE.getuint32(data, pos);
                    int _mask = LE.getuint32(data, pos += 4);
                    pos += 4;
                    int _len = LE.getuint32(data, pos += 4);
                    String _name = _len > 0 ? LE.getString(data, pos += 4, _len) : null;
                    siz -= 16 + _len;
                    String _event = null;
                    switch (_mask & 0xFC0) {
                        case 256: {
                            _event = "CREATED";
                            break;
                        }
                        case 512: {
                            _event = "DELETED";
                            break;
                        }
                        case 64: {
                            _event = "MOVED_FROM";
                            break;
                        }
                        case 128: {
                            _event = "MOVED_TO";
                            break;
                        }
                        case 1024: {
                            _event = "DELETE_SELF";
                            break;
                        }
                        case 2048: {
                            _event = "MOVED_SELF";
                        }
                    }
                    if (_event == null) continue;
                    Listener listener = map.get(_wd);
                    if (listener != null) {
                        listener.folderChangeEvent(_event, _name);
                        continue;
                    }
                    JFLog.log(_event + ":" + _name);
                }
            }
        }
    }

    public static interface Listener {
        public void folderChangeEvent(String var1, String var2);
    }
}

