/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.Color;
import javaforce.webui.Image;
import javaforce.webui.Resource;
import javaforce.webui.TextComponent;
import javaforce.webui.event.MouseEvent;

public class ToggleButton
extends TextComponent {
    private boolean state;
    private int clrOff;
    private int clrOn;
    private Image img;

    public ToggleButton(String text) {
        this.text = text;
        this.setColors(Color.darkGrey, Color.grey);
        this.addEvent("onclick", "onClick(event, this);");
        this.setColor();
    }

    public ToggleButton(String text, int clrOff, int clrOn) {
        this.text = text;
        this.setColors(clrOff, clrOn);
        this.addEvent("onclick", "onClick(event, this);");
        this.setColor();
    }

    public ToggleButton(Resource img, String text) {
        this.img = new Image(img);
        this.add(this.img);
        this.text = text;
        this.setColors(Color.darkGrey, Color.grey);
        this.addEvent("onclick", "onClick(event, this);");
        this.setColor();
    }

    public ToggleButton(Resource img, String text, int clrOff, int clrOn) {
        this.img = new Image(img);
        this.add(this.img);
        this.text = text;
        this.setColors(clrOff, clrOn);
        this.addEvent("onclick", "onClick(event, this);");
        this.setColor();
    }

    private void setColor() {
        this.setBackColor(this.state ? this.clrOn : this.clrOff);
    }

    @Override
    public void onClick(String[] args, MouseEvent me) {
        this.state = !this.state;
        this.setColor();
        this.onChanged(args);
        super.onClick(args, me);
    }

    @Override
    public String html() {
        StringBuilder sb = new StringBuilder();
        sb.append("<button" + this.getAttrs() + ">");
        if (this.img != null) {
            sb.append(this.img.html());
        }
        if (this.text != null) {
            sb.append(this.text);
        }
        sb.append("</button>");
        return sb.toString();
    }

    @Override
    public void setText(String text) {
        this.text = text;
        this.sendEvent("settext", new String[]{"text=" + text});
    }

    @Override
    public void updateText(String text) {
        this.sendEvent("settext", new String[]{"text=" + text});
    }

    public void setColors(int clrOff, int clrOn) {
        this.clrOff = clrOff;
        this.clrOn = clrOn;
        this.setColor();
    }

    public void setSelected(boolean state) {
        this.state = state;
        this.setColor();
    }

    public boolean isSelected() {
        return this.state;
    }
}

