package javaforce.awt;

/** SVG Editor
 *
 * @author pquiring
 */

import java.io.*;
import java.awt.event.*;
import javax.swing.*;

import javaforce.*;

public class SVGEditor extends javax.swing.JFrame {

  private static final java.util.logging.Logger logger = java.util.logging.Logger.getLogger(SVGEditor.class.getName());

  /**
   * Creates new form SVGEditor
   */
  public SVGEditor() {
    initComponents();
    svg.addKeyListener(new java.awt.event.KeyAdapter() {
      public void keyPressed(java.awt.event.KeyEvent evt) {
        keyPressedEvent(evt);
      }
    });
    processArgs();
    svg.requestFocus();
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    jToolBar1 = new javax.swing.JToolBar();
    open = new javax.swing.JButton();
    save = new javax.swing.JButton();
    update = new javax.swing.JButton();
    jLabel1 = new javax.swing.JLabel();
    sx = new javax.swing.JTextField();
    jLabel2 = new javax.swing.JLabel();
    sy = new javax.swing.JTextField();
    msg = new javax.swing.JLabel();
    jSplitPane1 = new javax.swing.JSplitPane();
    jScrollPane1 = new javax.swing.JScrollPane();
    svg = new JFTextArea();
    img = new javax.swing.JLabel();

    setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
    setTitle("SVG Editor");
    setPreferredSize(new java.awt.Dimension(1280, 1024));

    open.setText("Open");
    open.setFocusable(false);
    open.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
    open.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
    open.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        openActionPerformed(evt);
      }
    });
    jToolBar1.add(open);

    save.setText("Save");
    save.setToolTipText("Save and update image");
    save.setFocusable(false);
    save.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
    save.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
    save.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        saveActionPerformed(evt);
      }
    });
    jToolBar1.add(save);

    update.setText("Update");
    update.setFocusable(false);
    update.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
    update.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
    update.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        updateActionPerformed(evt);
      }
    });
    jToolBar1.add(update);

    jLabel1.setText("Size:");
    jToolBar1.add(jLabel1);

    sx.setText("512");
    sx.setMaximumSize(new java.awt.Dimension(100, 2147483647));
    jToolBar1.add(sx);

    jLabel2.setText("x");
    jToolBar1.add(jLabel2);

    sy.setText("512");
    sy.setMaximumSize(new java.awt.Dimension(100, 2147483647));
    jToolBar1.add(sy);

    msg.setText("...");
    jToolBar1.add(msg);

    jSplitPane1.setDividerLocation(512);

    svg.setColumns(20);
    svg.setRows(5);
    jScrollPane1.setViewportView(svg);

    jSplitPane1.setLeftComponent(jScrollPane1);

    img.setText("[img]");
    jSplitPane1.setRightComponent(img);

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addComponent(jToolBar1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
      .addComponent(jSplitPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 956, Short.MAX_VALUE)
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addComponent(jToolBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(jSplitPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 830, Short.MAX_VALUE))
    );

    pack();
  }// </editor-fold>//GEN-END:initComponents

  private void openActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_openActionPerformed
    open();
  }//GEN-LAST:event_openActionPerformed

  private void saveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveActionPerformed
    save();
  }//GEN-LAST:event_saveActionPerformed

  private void updateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_updateActionPerformed
    update();
  }//GEN-LAST:event_updateActionPerformed

  /**
   * @param args the command line arguments
   */
  public static void main(String[] args) {
    SVGEditor.args = args;
    /* Create and display the form */
    java.awt.EventQueue.invokeLater(() -> new SVGEditor().setVisible(true));
  }

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JLabel img;
  private javax.swing.JLabel jLabel1;
  private javax.swing.JLabel jLabel2;
  private javax.swing.JScrollPane jScrollPane1;
  private javax.swing.JSplitPane jSplitPane1;
  private javax.swing.JToolBar jToolBar1;
  private javax.swing.JLabel msg;
  private javax.swing.JButton open;
  private javax.swing.JButton save;
  private javax.swing.JTextArea svg;
  private javax.swing.JTextField sx;
  private javax.swing.JTextField sy;
  private javax.swing.JButton update;
  // End of variables declaration//GEN-END:variables

  private static String[] args;
  private File file;

  public void processArgs() {
    try {
      for(String arg : args) {
        file = new File(arg);
        load();
      }
    } catch (Exception e) {
      JFLog.log(e);
    }
  }

  public void open() {
    JFileChooser chooser = new JFileChooser();
    chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
    chooser.setMultiSelectionEnabled(false);
    chooser.setCurrentDirectory(new File(JF.getCurrentPath()));
    if (chooser.showOpenDialog(this) != JFileChooser.APPROVE_OPTION) return;
    file = chooser.getSelectedFile();
    clear();
    load();
  }

  public void clear() {
    svg.setText("");
  }

  public void load() {
    JFLog.log("loading:" + file.getAbsolutePath());
    try {
      FileInputStream fis = new FileInputStream(file);
      byte[] data = fis.readAllBytes();
      fis.close();
      svg.setText(new String(data));
      update();
    } catch (Exception e) {
      JFLog.log(e);
    }
  }

  public void save() {
    if (file == null) return;
    try {
      FileOutputStream fos = new FileOutputStream(file);
      byte[] data = svg.getText().getBytes();
      fos.write(data);
      fos.close();
      update();
    } catch (Exception e) {
      JFLog.log(e);
    }
  }

  public void update() {
    try {
      msg.setText("");
      int x = Integer.valueOf(sx.getText());
      int y = Integer.valueOf(sy.getText());
      byte[] data = svg.getText().getBytes();
      ByteArrayInputStream bais = new ByteArrayInputStream(data);
      JFImage.setDefaultColor(0x00ffffff);
      JFImage tmp = new JFImage();
      tmp.loadSVG(bais, x, y);
      img.setText("");
      img.setIcon(tmp);
    } catch (Exception e) {
      JFLog.log(e);
      msg.setText("SVG corrupt");
    }
  }

  private void keyPressedEvent(java.awt.event.KeyEvent evt) {
    //Key Pressed
    int key = evt.getKeyCode();
    int mod = evt.getModifiersEx() & JFAWT.KEY_MASKS;
    switch (mod) {
      case 0:
        switch (key) {
          case KeyEvent.VK_F1: {
            JOptionPane.showMessageDialog(this,
              "SVGEditor/" + JF.getVersion() + "\n\n" +
              "F1 = Help\n" +
              "F5 = Update\n" +
              "CTRL-O = Open\n" +
              "CTRL-S = Save\n"
              , "Help", JOptionPane.INFORMATION_MESSAGE);
            break;
          }
          case KeyEvent.VK_F5: {
            update();
            break;
          }
        }
        break;
      case KeyEvent.SHIFT_DOWN_MASK:
        break;
      case KeyEvent.CTRL_DOWN_MASK:
        switch (key) {
          case KeyEvent.VK_S: { save(); return; }
          case KeyEvent.VK_O: { open(); return; }
        }
        break;
      case KeyEvent.ALT_DOWN_MASK:
        break;
    }
  }
}
