/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import javaforce.BE;

public class JFByteBuffer {
    private byte[] buffer;
    private int length;
    private int offset;
    private int max_length;
    private byte[] tmp = new byte[8];

    public JFByteBuffer(int max_length) {
        this.max_length = max_length;
        this.buffer = new byte[max_length];
    }

    public void reset() {
        this.length = 0;
        this.offset = 0;
    }

    public void setLength(int len) {
        this.length = len;
        this.offset = 0;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public byte readByte() {
        if (this.offset + 1 > this.length) {
            return -1;
        }
        return this.buffer[this.offset++];
    }

    public short readShort() {
        if (this.offset + 2 > this.length) {
            return -1;
        }
        short value = (short)BE.getuint16(this.buffer, this.offset);
        this.offset += 2;
        return value;
    }

    public int readInt() {
        if (this.offset + 4 > this.length) {
            return -1;
        }
        int value = BE.getuint32(this.buffer, this.offset);
        this.offset += 4;
        return value;
    }

    public long readLong() {
        if (this.offset + 8 > this.length) {
            return -1L;
        }
        long value = BE.getuint64(this.buffer, this.offset);
        this.offset += 8;
        return value;
    }

    public boolean readBytes(byte[] out, int off, int len) {
        if (this.offset + len > this.length) {
            return false;
        }
        System.arraycopy(this.buffer, this.offset, out, off, len);
        this.offset += len;
        return true;
    }

    public boolean write(byte b) {
        this.buffer[this.offset++] = b;
        ++this.length;
        return true;
    }

    public boolean write(short len) {
        BE.setuint16(this.tmp, 0, len);
        return this.write(this.tmp, 0, 2);
    }

    public boolean write(int len) {
        BE.setuint32(this.tmp, 0, len);
        return this.write(this.tmp, 0, 4);
    }

    public boolean write(long len) {
        BE.setuint64(this.tmp, 0, len);
        return this.write(this.tmp, 0, 8);
    }

    public boolean write(byte[] buf, int off, int len) {
        if (this.offset + len > this.max_length) {
            return false;
        }
        System.arraycopy(buf, off, this.buffer, this.offset, len);
        this.offset += len;
        this.length += len;
        return true;
    }
}

