/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javaforce.JF;
import javaforce.JFLog;

public class JFClassLoader
extends ClassLoader {
    private ArrayList<Folder> cp_folders = new ArrayList();
    private HashMap<String, Folder> cp_files = new HashMap();
    public static boolean debug = false;

    public JFClassLoader(String[] classpath) {
        super(ClassLoader.getPlatformClassLoader());
        File[] files = new File[classpath.length];
        int idx = 0;
        for (String cp : classpath) {
            files[idx++] = new File(cp);
        }
        this.init(files);
    }

    public JFClassLoader(File[] classpath) {
        super(ClassLoader.getPlatformClassLoader());
        this.init(classpath);
    }

    private void init(File[] classpath) {
        if (debug) {
            JFLog.log("platform = " + String.valueOf(ClassLoader.getPlatformClassLoader()));
            JFLog.log("system = " + String.valueOf(ClassLoader.getSystemClassLoader()));
            for (ClassLoader parent = this.getParent(); parent != null; parent = parent.getParent()) {
                JFLog.log("parent = " + String.valueOf(parent));
            }
        }
        for (File file : classpath) {
            if (!file.exists()) {
                JFLog.log("Error:ClassPath element not found:" + file.getAbsolutePath());
                continue;
            }
            if (file.isDirectory()) {
                Folder folder = new Folder();
                this.cp_folders.add(folder);
                this.doFileFolder(file, folder, "");
                continue;
            }
            if (file.getName().endsWith(".jar")) {
                Folder jar_folder = new Folder();
                this.cp_folders.add(jar_folder);
                this.doJarFolder(file, jar_folder, "");
                continue;
            }
            JFLog.log("Unknown ClassPath element:" + String.valueOf(file));
        }
    }

    private void doFileFolder(File folder, Folder file_folder, String path) {
        try {
            File[] files;
            for (File file : files = folder.listFiles()) {
                String cls;
                byte[] data;
                FileInputStream fis;
                Object full;
                String name = file.getName();
                if (file.isDirectory()) {
                    full = path.length() == 0 ? name : path + "/" + name;
                    this.doFileFolder(file, file_folder, (String)full);
                    continue;
                }
                if (file.getName().endsWith(".jar")) {
                    Folder jar_folder = new Folder();
                    this.cp_folders.add(jar_folder);
                    this.doJarFolder(file, jar_folder, "");
                    continue;
                }
                if (file.getName().endsWith(".class")) {
                    full = path.length() == 0 ? name : path + "/" + name;
                    fis = new FileInputStream(file);
                    data = fis.readAllBytes();
                    fis.close();
                    cls = this.convert_class((String)full);
                    if (debug) {
                        JFLog.log("class:" + cls);
                    }
                    file_folder.files.put(cls, data);
                    this.cp_files.put(cls, file_folder);
                    continue;
                }
                full = path.length() == 0 ? name : path + "/" + name;
                fis = new FileInputStream(file);
                data = fis.readAllBytes();
                fis.close();
                cls = this.convert_resource((String)full);
                if (debug) {
                    JFLog.log("resource:" + cls);
                }
                file_folder.files.put(cls, data);
                this.cp_files.put(cls, file_folder);
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private void doJarFolder(File jar, Folder jar_folder, String path) {
        try {
            ZipEntry ze;
            ZipInputStream zis = new ZipInputStream(new FileInputStream(jar));
            while ((ze = zis.getNextEntry()) != null) {
                String name = ze.getName();
                if (ze.isDirectory() || !name.endsWith(".class")) continue;
                Object full = path.length() == 0 ? name : path + "/" + name;
                byte[] data = zis.readAllBytes();
                String cls = this.convert_class((String)full);
                if (debug) {
                    JFLog.log("jar.class:" + cls);
                }
                jar_folder.files.put(cls, data);
                this.cp_files.put(cls, jar_folder);
            }
            zis.close();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private String convert_class(String in) {
        in = in.substring(0, in.length() - 6);
        in = in.replaceAll("[/]", ".");
        if (JF.isWindows()) {
            in = in.replaceAll("[\\\\]", ".");
        }
        return in;
    }

    private String convert_resource(String in) {
        if (JF.isWindows()) {
            in = in.replaceAll("[\\\\]", "/");
        }
        return in;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        return this.findClass(null, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> findClass(String module_name, String name) {
        Folder folder;
        if (!name.startsWith("javaforce.")) {
            try {
                Class<?> cls = module_name == null ? super.findClass(name) : super.findClass(module_name, name);
                if (cls != null) {
                    if (debug) {
                        JFLog.log("bootClass:" + name);
                    }
                    return cls;
                }
            }
            catch (Exception cls) {
                // empty catch block
            }
        }
        if ((folder = this.cp_files.get(name)) == null) {
            return null;
        }
        Object object = folder.lock;
        synchronized (object) {
            Class<?> cls = folder.classes.get(name);
            if (cls != null) {
                return cls;
            }
            byte[] data = this.getData(name);
            if (data == null) {
                return null;
            }
            if (debug) {
                JFLog.log("defineClass:" + name);
            }
            try {
                cls = this.defineClass(name, data, 0, data.length);
                if (cls != null) {
                    folder.classes.put(name, cls);
                }
                return cls;
            }
            catch (Throwable t) {
                JFLog.log(t);
                return null;
            }
        }
    }

    private byte[] getData(String name) {
        Folder folder = this.cp_files.get(name);
        if (folder == null) {
            JFLog.log("JFClassLoader:class not found:" + name);
            return null;
        }
        return folder.files.get(name);
    }

    @Override
    public URL findResource(String name) {
        return super.findResource(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return super.findResources(name);
    }

    @Override
    public URL getResource(String name) {
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return super.getResources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] data = this.getData(name);
        if (data == null) {
            return super.getResourceAsStream(name);
        }
        return new ByteArrayInputStream(data);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return super.loadClass(name);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    public static String inspectClass(Class<?> cls, boolean recursive) {
        Class<?>[] ifaces;
        StringBuilder sb = new StringBuilder();
        sb.append("inspectClass{");
        sb.append("class=" + String.valueOf(cls));
        Class<?> supercls = cls.getSuperclass();
        if (supercls != null) {
            sb.append(",super=" + String.valueOf(supercls));
        }
        for (Class<?> iface : ifaces = cls.getInterfaces()) {
            sb.append(",interface=" + String.valueOf(iface));
        }
        sb.append("}");
        if (recursive && supercls != null) {
            sb.append(JFClassLoader.inspectClass(supercls, recursive));
        }
        return sb.toString();
    }

    public static String inspectObject(Object obj, boolean recursive) {
        Class<?>[] ifaces;
        StringBuilder sb = new StringBuilder();
        sb.append("inspectObject{object=" + String.valueOf(obj));
        Class<?> cls = obj.getClass();
        sb.append(",class=" + String.valueOf(cls));
        Class<?> supercls = cls.getSuperclass();
        sb.append(",super=" + String.valueOf(supercls));
        for (Class<?> iface : ifaces = cls.getInterfaces()) {
            sb.append(",interface=" + String.valueOf(iface));
        }
        sb.append("}");
        if (recursive && supercls != null) {
            sb.append(JFClassLoader.inspectClass(supercls, recursive));
        }
        return sb.toString();
    }

    public String toString() {
        return "JFClassLoader";
    }

    private static class Folder {
        public Object lock = new Object();
        public HashMap<String, byte[]> files = new HashMap();
        public HashMap<String, Class<?>> classes = new HashMap();

        private Folder() {
        }
    }
}

