/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Random;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javaforce.BE;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.awt.JFImage;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class RFB {
    private Socket s;
    private InputStream is;
    private OutputStream os;
    private boolean connected;
    private int width;
    private int height;
    private String name;
    private JFImage image;
    private int[] buffer;
    private PixelFormat pf;
    private int bytesPixel;
    private int clr;
    private int[] colors = new int[256];
    private int mx;
    private int my;
    private static int log;
    private static final int MAX_TEXT_LENGTH = 0x100000;
    public static boolean debug;
    public static boolean debugEncoding;
    public static boolean debugKey;
    public static int PF_LE_RGB;
    public static int PF_BE_BGR;
    public static final int VK_BACK_SPACE = 65288;
    public static final int VK_TAB = 65289;
    public static final int VK_ENTER = 65293;
    public static final int VK_ESCAPE = 65307;
    public static final int VK_HOME = 65360;
    public static final int VK_LEFT = 65361;
    public static final int VK_UP = 65362;
    public static final int VK_RIGHT = 65363;
    public static final int VK_DOWN = 65364;
    public static final int VK_PAGE_UP = 65365;
    public static final int VK_PAGE_DOWN = 65366;
    public static final int VK_END = 65367;
    public static final int VK_INSERT = 65379;
    public static final int VK_CONTEXT_MENU = 65383;
    public static final int VK_NUMPAD_ENTER = 65421;
    public static final int VK_NUMPAD_ASTERISK = 65450;
    public static final int VK_NUMPAD_PLUS = 65451;
    public static final int VK_NUMPAD_PERIOD = 65454;
    public static final int VK_NUMPAD_MINUS = 65453;
    public static final int VK_NUMPAD_DIVIDE = 65455;
    public static final int VK_NUMPAD0 = 65456;
    public static final int VK_NUMPAD1 = 65457;
    public static final int VK_NUMPAD2 = 65458;
    public static final int VK_NUMPAD3 = 65459;
    public static final int VK_NUMPAD4 = 65460;
    public static final int VK_NUMPAD5 = 65461;
    public static final int VK_NUMPAD6 = 65462;
    public static final int VK_NUMPAD7 = 65463;
    public static final int VK_NUMPAD8 = 65464;
    public static final int VK_NUMPAD9 = 65465;
    public static final int VK_F1 = 65470;
    public static final int VK_F2 = 65471;
    public static final int VK_F3 = 65472;
    public static final int VK_F4 = 65473;
    public static final int VK_F5 = 65474;
    public static final int VK_F6 = 65475;
    public static final int VK_F7 = 65476;
    public static final int VK_F8 = 65477;
    public static final int VK_F9 = 65478;
    public static final int VK_F10 = 65479;
    public static final int VK_F11 = 65480;
    public static final int VK_F12 = 65481;
    public static final int VK_SHIFT = 65505;
    public static final int VK_SHIFT_R = 65506;
    public static final int VK_CONTROL = 65507;
    public static final int VK_CONTROL_R = 65508;
    public static final int VK_META = 65511;
    public static final int VK_META_R = 65512;
    public static final int VK_ALT = 65513;
    public static final int VK_ALT_R = 65514;
    public static final int VK_WIN_KEY = 65515;
    public static final int VK_WIN_KEY_R = 65516;
    public static final int VK_DELETE = 65535;
    public static final int VK_EXCLAMATION_MASK = 33;
    public static final int VK_AT = 64;
    public static final int VK_NUMBER_SIGN = 35;
    public static final int VK_DOLLAR_SIGN = 36;
    public static final int VK_PERCENT = 37;
    public static final int VK_CIRCUMFLEX = 94;
    public static final int VK_AMPERSAND = 38;
    public static final int VK_ASTERISK = 42;
    public static final int VK_LEFT_PARENTHSIS = 40;
    public static final int VK_RIGHT_PARENTHSIS = 41;
    public static final int VK_UNDERSCORE = 95;
    public static final int VK_PLUS = 43;
    public static final int VK_QUOTE_LEFT = 96;
    public static final int VK_TILDE = 126;
    public static final int VK_OPEN_BRACKET = 123;
    public static final int VK_CLOSE_BRACKET = 125;
    public static final int VK_PIPE = 124;
    public static final int VK_SEMICOLON = 58;
    public static final int VK_DOUBLE_QUOTE = 34;
    public static final int VK_LESS = 60;
    public static final int VK_GREATER = 62;
    public static final int VK_QUESTION_MARK = 63;
    public static final int VK_QUOTE = 39;
    public static float VERSION_3_3;
    public static float VERSION_3_7;
    public static float VERSION_3_8;
    public static final int AUTH_FAIL = 0;
    public static final int AUTH_NONE = 1;
    public static final int AUTH_VNC = 2;
    public static final int C_MSG_SET_PIXEL_FORMAT = 0;
    public static final int C_MSG_SET_ENCODING = 2;
    public static final int C_MSG_BUFFER_REQUEST = 3;
    public static final int C_MSG_KEY_EVENT = 4;
    public static final int C_MSG_MOUSE_EVENT = 5;
    public static final int C_MSG_CUT_TEXT = 6;
    private int[] encodings;
    public static final int S_MSG_CLOSE = -1;
    public static final int S_MSG_BUFFER_UPDATE = 0;
    public static final int S_MSG_COLOR_MAP = 1;
    public static final int S_MSG_BELL = 2;
    public static final int S_MSG_CUT_TEXT = 3;
    public static final int TYPE_RAW = 0;
    public static final int TYPE_RECT_COPY = 1;
    public static final int TYPE_RRE = 2;
    public static final int TYPE_CORRE = 4;
    public static final int TYPE_HEXTILE = 5;
    public static final int TYPE_ZLIB = 6;
    public static final int TYPE_TIGHT = 7;
    public static final int TYPE_HEXTILE_ZLIB = 8;
    public static final int TYPE_ULTRA = 9;
    public static final int TYPE_ULTRA2 = 10;
    public static final int TYPE_TRLE = 15;
    public static final int TYPE_ZRLE = 16;
    public static final int TYPE_ZYWRLE = 17;
    public static final int TYPE_DESKTOP_SIZE = -223;
    public static final int TYPE_LAST_RECT = -224;
    public static final int TYPE_POINTER_POS = -232;
    public static final int TYPE_CURSOR = -239;
    public static final int TYPE_JPEG_9 = -23;
    public static final int TYPE_JPEG_8 = -24;
    public static final int TYPE_JPEG_7 = -25;
    public static final int TYPE_JPEG_6 = -26;
    public static final int TYPE_JPEG_5 = -27;
    public static final int TYPE_JPEG_4 = -28;
    public static final int TYPE_JPEG_3 = -29;
    public static final int TYPE_JPEG_2 = -30;
    public static final int TYPE_JPEG_1 = -31;
    public static final int TYPE_JPEG_0 = -32;
    private int hextile_bg = 0;
    private int hextile_fg = 0;
    private final int HEXTILE_RAW = 1;
    private final int HEXTILE_BACKGROUND_SPECIFIED = 2;
    private final int HEXTILE_FOREGROUND_SPECIFIED = 4;
    private final int HEXTILE_ANY_SUBRECTS = 8;
    private final int HEXTILE_SUBRECTS_COLOURED = 16;
    private final int HEXTILE_ZLIB_RAW = 32;
    private final int HEXTILE_ZLIB = 64;
    private Inflater zlibInflater;
    private Inflater[] tightInflaters = new Inflater[4];
    private static final int TIGHT_FILTER_COPY = 0;
    private static final int TIGHT_FILTER_PALETTE = 1;
    private static final int TIGHT_FILTER_GRADIENT = 2;
    private static final int TIGHT_EXPLICIT_FILTER = 4;
    private static final int TIGHT_FILL = 8;
    private static final int TIGHT_JPEG = 9;
    private static final int TIGHT_MAXSUBENCODING = 9;
    private static final int TIGHT_MIN_TO_COMPRESS = 12;
    private Deflater zlibDeflater;

    public static int[] swapPixelFormat(int[] rgb) {
        int len = rgb.length;
        int[] bgr = new int[len];
        for (int i = 0; i < len; ++i) {
            int px = rgb[i];
            int aa_gg = px & 0xFF00FF00;
            int rr = (px & 0xFF0000) >> 16;
            int bb = (px & 0xFF) << 16;
            bgr[i] = px = aa_gg | rr | bb;
        }
        return bgr;
    }

    public boolean connect(String host, int port) {
        try {
            this.s = new Socket(host, port);
            this.is = this.s.getInputStream();
            this.os = this.s.getOutputStream();
            this.connected = true;
        }
        catch (Exception e) {
            this.connected = false;
            JFLog.log(log, (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean connect(Socket s) {
        try {
            this.s = s;
            this.is = s.getInputStream();
            this.os = s.getOutputStream();
            this.connected = true;
        }
        catch (Exception e) {
            this.connected = false;
            JFLog.log(log, (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void disconnect() {
        try {
            if (this.s != null) {
                this.s.close();
                this.s = null;
            }
        }
        catch (Exception e) {
            JFLog.log(log, (Throwable)e);
        }
    }

    public static void setLog(int log) {
        RFB.log = log;
    }

    private void setSize() {
        if (debug) {
            JFLog.log("RFB:setSize:" + this.width + "x" + this.height);
        }
        this.image = new JFImage(this.width, this.height);
        this.buffer = this.image.getBuffer();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int[] getBuffer() {
        return this.buffer;
    }

    public void setBuffer(int[] px) {
        if (px.length != this.buffer.length) {
            JFLog.log("Error:RFB.setBuffer():px.length wrong size:" + px.length + "!=" + this.buffer.length);
            return;
        }
        System.arraycopy(px, 0, this.buffer, 0, px.length);
    }

    public JFImage getImage(Rectangle area) {
        JFImage image = new JFImage(area.width, area.height);
        image.putPixels(this.getBuffer(), 0, 0, area.width, area.height, area.y * this.width + area.x, this.width);
        return image;
    }

    public int getMouseX() {
        return this.mx;
    }

    public int getMouseY() {
        return this.my;
    }

    public String getDesktopName() {
        return this.name;
    }

    private static int getPixelBGR(byte[] data, int offset) {
        int ret = (data[offset + 2] & 0xFF) << 16;
        ret += (data[offset + 1] & 0xFF) << 8;
        return ret += data[offset + 0] & 0xFF;
    }

    private static int getPixelRGB(byte[] data, int offset) {
        int ret = (data[offset + 0] & 0xFF) << 16;
        ret += (data[offset + 1] & 0xFF) << 8;
        return ret += data[offset + 2] & 0xFF;
    }

    private void fill(Rectangle rect, int clr) {
        if (debug) {
            JFLog.log(log, "RFB:fill:" + String.valueOf(rect) + ",clr=" + Integer.toString(clr, 16));
        }
        int x1 = rect.x;
        int x2 = x1 + rect.width - 1;
        int y1 = rect.y;
        int y2 = y1 + rect.height - 1;
        if (x2 >= this.width) {
            x2 = this.width - 1;
        }
        if (y2 >= this.height) {
            y2 = this.height - 1;
        }
        clr |= 0xFF000000;
        for (int y = y1; y <= y2; ++y) {
            for (int x = x1; x <= x2; ++x) {
                this.buffer[y * this.width + x] = clr;
            }
        }
    }

    private int readByte() {
        try {
            int val = this.is.read();
            if (val == -1) {
                throw new Exception("EOF");
            }
            return val;
        }
        catch (Exception e) {
            this.connected = false;
            JFLog.log(log, (Throwable)e);
            return -1;
        }
    }

    private int readShort() {
        byte[] data = this.read(2);
        if (data == null) {
            return -1;
        }
        return BE.getuint16(data, 0);
    }

    private int readInt() {
        byte[] data = this.read(4);
        if (data == null) {
            return -1;
        }
        return BE.getuint32(data, 0);
    }

    private byte[] read(int len) {
        try {
            return this.is.readNBytes(len);
        }
        catch (Exception e) {
            this.connected = false;
            JFLog.log(log, (Throwable)e);
            return null;
        }
    }

    private int readCompactLen() {
        int[] portion = new int[3];
        portion[0] = this.readByte();
        int byteCount = 1;
        int len = portion[0] & 0x7F;
        if ((portion[0] & 0x80) != 0) {
            portion[1] = this.readByte();
            ++byteCount;
            len |= (portion[1] & 0x7F) << 7;
            if ((portion[1] & 0x80) != 0) {
                portion[2] = this.readByte();
                ++byteCount;
                len |= (portion[2] & 0xFF) << 14;
            }
        }
        return len;
    }

    private void writeCompactLen(int length) {
        while (length > 0) {
            if (length >= 128) {
                this.writeByte((length & 0x7F) + 128);
            } else {
                this.writeByte(length & 0x7F);
            }
            length >>= 7;
        }
    }

    private void writeByte(int data) {
        try {
            this.os.write(data);
        }
        catch (Exception e) {
            this.connected = false;
            JFLog.log(log, (Throwable)e);
        }
    }

    private void writeShort(int data) {
        byte[] pkt = new byte[2];
        BE.setuint16(pkt, 0, data);
        this.write(pkt);
    }

    private void writeInt(int data) {
        byte[] pkt = new byte[4];
        BE.setuint32(pkt, 0, data);
        this.write(pkt);
    }

    private void write(byte[] data) {
        try {
            this.os.write(data);
        }
        catch (Exception e) {
            this.connected = false;
            JFLog.log(log, (Throwable)e);
        }
    }

    private void write(byte[] data, int offset, int length) {
        try {
            this.os.write(data, offset, length);
        }
        catch (Exception e) {
            this.connected = false;
            JFLog.log(log, (Throwable)e);
        }
    }

    public float readVersion() {
        byte[] data = this.read(12);
        String major = new String(data, 4, 3);
        String minor = new String(data, 8, 3);
        float ver = Float.valueOf(major).floatValue() + Float.valueOf(minor).floatValue() / 10.0f;
        if (debug) {
            JFLog.log(log, "RFB:read server version=" + ver);
        }
        return ver;
    }

    public void writeVersion(float ver) {
        int major = (int)ver;
        int minor = (int)((ver - (float)major + 0.01f) * 10.0f);
        String str = String.format("RFB %03d.%03d\n", major, minor);
        if (debug) {
            JFLog.log(log, "RFB:write client version=" + str);
        }
        byte[] pkt = str.getBytes();
        this.write(pkt);
    }

    public byte[] readAuthTypes() {
        int cnt = this.readByte();
        if (debug) {
            JFLog.log(log, "RFB:read AuthType Count=" + cnt);
        }
        byte[] types2 = this.read(cnt);
        if (debug) {
            for (int a = 0; a < types2.length; ++a) {
                JFLog.log(log, "RFB:read AuthType[]=" + types2[a]);
            }
        }
        return types2;
    }

    public void writeAuthTypes() {
        byte[] pkt = new byte[]{1, 2};
        this.write(pkt);
    }

    public byte readAuthType() {
        return (byte)this.readByte();
    }

    public byte[] readAuthChallenge() {
        byte[] data = this.read(16);
        if (debug) {
            JFLog.log(log, "RFB:read challenge=" + String.valueOf(data));
        }
        return data;
    }

    public byte[] writeAuthChallenge() {
        byte[] pkt = new byte[16];
        Random r = new Random();
        for (int a = 0; a < 16; ++a) {
            pkt[a] = (byte)r.nextInt(256);
        }
        if (debug) {
            JFLog.log(log, "RFB:read challenge=" + String.valueOf(pkt));
        }
        this.write(pkt);
        return pkt;
    }

    private static byte[] reverseBits(byte[] input) {
        byte[] output = new byte[input.length];
        for (int a = 0; a < input.length; ++a) {
            byte in = input[a];
            int out = 0;
            for (int b = 0; b < 8; ++b) {
                out = (byte)(out << 1);
                if ((in & 1) == 1) {
                    out = (byte)(out | 1);
                }
                in = (byte)(in >> 1);
            }
            output[a] = out;
        }
        return output;
    }

    public static String checkPassword(String password) {
        int len = password.length();
        if (len == 8) {
            return password;
        }
        if (len > 8) {
            return password.substring(0, 8);
        }
        byte[] buf = new byte[8];
        System.arraycopy(password.getBytes(), 0, buf, 0, len);
        for (int i = len; i < 8; ++i) {
            buf[i] = 48;
        }
        return new String(buf);
    }

    public static byte[] encodeResponse(byte[] challenge, byte[] password) {
        byte[] password8 = RFB.checkPassword(new String(password)).getBytes();
        byte[] r_password = RFB.reverseBits(password8);
        try {
            DESKeySpec desKeySpec = new DESKeySpec(r_password);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(1, secretKey);
            return cipher.doFinal(challenge);
        }
        catch (Exception e) {
            JFLog.log(log, (Throwable)e);
            return null;
        }
    }

    public void writeAuthType(int type) {
        if (debug) {
            JFLog.log(log, "RFB:write AuthType=" + type);
        }
        this.writeByte(type);
    }

    public void writeAuthResponse(byte[] res) {
        if (debug) {
            JFLog.log(log, "RFB:write AuthResponse=" + String.valueOf(res));
        }
        this.write(res);
    }

    public void writeAuthResult(boolean state) {
        int value = state ? 0 : 1;
        this.writeInt(value);
        if (value == 1) {
            this.writeInt(0);
        }
    }

    public boolean readAuthResult() {
        int res = this.readInt();
        if (debug) {
            JFLog.log(log, "RFB:read AuthResult=" + res);
        }
        if (res == 1) {
            int strlen = this.readInt();
            if (strlen > 0x100000) {
                JFLog.log(log, "RFB:error strlen=" + strlen);
                this.connected = false;
                return false;
            }
            byte[] errmsg_bytes = this.read(strlen);
            String errmsg = new String(errmsg_bytes);
            this.connected = false;
            JFLog.log("RFB:errmsg=" + errmsg);
        }
        return res == 0;
    }

    public byte readClientInit() {
        return (byte)this.readByte();
    }

    public void writeClientInit(boolean shared) {
        if (debug) {
            JFLog.log(log, "RFB:write ClientInit:shared=" + shared);
        }
        this.writeByte((byte)(shared ? 1 : 0));
    }

    public boolean readServerInit() {
        int strlen;
        byte[] pkt = this.read(20);
        this.width = BE.getuint16(pkt, 0);
        this.height = BE.getuint16(pkt, 2);
        this.setSize();
        this.pf = new PixelFormat();
        this.pf.decode(pkt, 4);
        this.bytesPixel = this.pf.bytesPixel();
        if (debug) {
            JFLog.log(log, "RFB:read server pixel format=" + String.valueOf(this.pf));
        }
        if ((strlen = this.readInt()) > 0x100000) {
            JFLog.log(log, "RFB:error strlen=" + strlen);
            this.connected = false;
            return false;
        }
        byte[] name_bytes = this.read(strlen);
        this.name = new String(name_bytes);
        if (debug) {
            JFLog.log("RFB:desktop name=" + this.name);
        }
        return true;
    }

    public boolean writeServerInit(int width, int height) {
        String name = JF.getHostname();
        if (name == null || name.length() == 0) {
            name = "computer";
        }
        int len = name.length();
        byte[] pkt = new byte[24 + len];
        this.width = width;
        this.height = height;
        this.setSize();
        BE.setuint16(pkt, 0, width);
        BE.setuint16(pkt, 2, height);
        this.pf = PixelFormat.create_24bpp(false);
        this.pf.encode(pkt, 4);
        BE.setuint32(pkt, 20, len);
        System.arraycopy(name.getBytes(), 0, pkt, 24, len);
        this.write(pkt);
        return true;
    }

    public PixelFormat readPixelFormat() {
        PixelFormat pf = new PixelFormat();
        byte[] pkt = this.read(19);
        pf.decode(pkt, 3);
        return pf;
    }

    public void writePixelFormat() {
        if (debug) {
            JFLog.log(log, "RFB:write PixelFormat");
        }
        byte[] pkt = new byte[20];
        pkt[0] = 0;
        PixelFormat pf = PixelFormat.create_24bpp(true);
        pf.encode(pkt, 4);
        this.write(pkt);
    }

    public int[] readEncodings() {
        byte[] header = this.read(3);
        int count = BE.getuint16(header, 1);
        if (count < 0 || count > 128) {
            JFLog.log("RFB:Error:# encodings=" + count);
            return null;
        }
        this.encodings = new int[count];
        byte[] data = this.read(count * 4);
        for (int idx = 0; idx < count; ++idx) {
            this.encodings[idx] = BE.getuint32(data, idx * 4);
        }
        return this.encodings;
    }

    public boolean haveEncodings() {
        return this.encodings != null;
    }

    private boolean haveEncoding(int encoding) {
        for (int a = 0; a < this.encodings.length; ++a) {
            if (this.encodings[a] != encoding) continue;
            return true;
        }
        return false;
    }

    private int bestEncoding() {
        if (this.haveEncoding(7)) {
            return 7;
        }
        if (this.haveEncoding(6)) {
            return 6;
        }
        return 0;
    }

    public void writeEncodings(int[] encodings) {
        if (debug) {
            JFLog.log(log, "RFB:write Encodings");
        }
        int count = encodings.length;
        byte[] pkt = new byte[4 + count * 4];
        pkt[0] = 2;
        BE.setuint16(pkt, 2, count);
        for (int a = 0; a < count; ++a) {
            BE.setuint32(pkt, 4 + a * 4, encodings[a]);
        }
        this.write(pkt);
    }

    public void writeEncodingsFast() {
        this.writeEncodings(new int[]{5, 1, 4, 2, 0, 6, 7, -23, -223, -224, -232, -239});
    }

    public void writeEncodingsLean() {
        this.writeEncodings(new int[]{7, 6, 5, 1, 4, 2, 0, -23, -223, -224, -232, -239});
    }

    public Rectangle readBufferUpdateRequest() {
        Rectangle rect = new Rectangle();
        byte[] pkt = this.read(9);
        rect.x = BE.getuint16(pkt, 1);
        rect.y = BE.getuint16(pkt, 3);
        rect.width = BE.getuint16(pkt, 5);
        rect.height = BE.getuint16(pkt, 7);
        return rect;
    }

    public void writeBufferUpdateRequest(int x, int y, int width, int height, boolean incremental) {
        if (debug) {
            JFLog.log(log, "RFB:write BufferUpdateRequest");
        }
        byte[] pkt = new byte[10];
        pkt[0] = 3;
        pkt[1] = (byte)(incremental ? 1 : 0);
        BE.setuint16(pkt, 2, x);
        BE.setuint16(pkt, 4, y);
        BE.setuint16(pkt, 6, width);
        BE.setuint16(pkt, 8, height);
        this.write(pkt);
    }

    public void writeKeyEvent(int code, boolean down) {
        if (debugKey) {
            JFLog.log(log, "RFB:write KeyEvent");
        }
        byte[] pkt = new byte[8];
        pkt[0] = 4;
        pkt[1] = (byte)(down ? 1 : 0);
        BE.setuint32(pkt, 4, code);
        this.write(pkt);
    }

    public RFBKeyEvent readKeyEvent() {
        RFBKeyEvent event = new RFBKeyEvent();
        byte[] pkt = this.read(7);
        event.down = (pkt[0] & 1) == 1;
        event.code = BE.getuint32(pkt, 3);
        return event;
    }

    public void writeMouseEvent(int x, int y, int buttons) {
        if (debug) {
            JFLog.log(log, "RFB:write MouseEvent");
        }
        byte[] pkt = new byte[6];
        pkt[0] = 5;
        pkt[1] = (byte)buttons;
        BE.setuint16(pkt, 2, x);
        BE.setuint16(pkt, 4, y);
        this.write(pkt);
    }

    public RFBMouseEvent readMouseEvent() {
        RFBMouseEvent event = new RFBMouseEvent();
        byte[] pkt = this.read(5);
        event.buttons = pkt[0];
        event.x = BE.getuint16(pkt, 1);
        event.y = BE.getuint16(pkt, 3);
        return event;
    }

    public void writeCutText(String txt) {
        if (debug) {
            JFLog.log(log, "RFB:write CutText");
        }
        byte[] bytes = txt.getBytes();
        int len = 8 + bytes.length;
        byte[] pkt = new byte[len];
        pkt[0] = 6;
        BE.setuint32(pkt, 4, len);
        System.arraycopy(bytes, 0, pkt, 4, bytes.length);
        this.write(pkt);
    }

    public int readMessageType() {
        if (!this.connected) {
            JFLog.log(log, "RFB:connection is closed");
            return -1;
        }
        if (debug) {
            JFLog.log(log, "Reading Message Type");
        }
        int msg = this.readByte();
        if (debug) {
            JFLog.log(log, "RFB:read msg=" + msg);
        }
        return msg;
    }

    public Rectangle readBufferUpdate() {
        byte[] pkt = this.read(3);
        int count = BE.getuint16(pkt, 1);
        if (debug) {
            JFLog.log("RFB:read UpdateBufferCount=" + count);
        }
        Rectangle rect = new Rectangle();
        for (int a = 0; a < count; ++a) {
            this.readRectangle(rect);
        }
        return rect;
    }

    public void writeBufferUpdate(Rectangle rect, int encoding) {
        byte[] pkt = new byte[4];
        pkt[0] = 0;
        pkt[1] = 0;
        BE.setuint16(pkt, 2, 1);
        this.write(pkt);
        if (encoding == -1) {
            encoding = this.bestEncoding();
        }
        if (debug) {
            JFLog.log("encoding=" + encoding);
        }
        this.writeRectangle(rect, encoding);
    }

    private void readRectangle(Rectangle full) {
        byte[] pkt = this.read(12);
        int encoding = BE.getuint32(pkt, 8);
        Rectangle rect = new Rectangle();
        rect.x = BE.getuint16(pkt, 0);
        rect.y = BE.getuint16(pkt, 2);
        rect.width = BE.getuint16(pkt, 4);
        rect.height = BE.getuint16(pkt, 6);
        full.add(rect);
        switch (encoding) {
            case 0: {
                this.readRectRaw(rect);
                break;
            }
            case 1: {
                this.readRectCopy(rect);
                break;
            }
            case 2: {
                this.readRectRRE(rect);
                break;
            }
            case 4: {
                this.readRectCoRRE(rect);
                break;
            }
            case 5: {
                this.readRectHexTile(rect);
                break;
            }
            case 6: {
                this.readRectZlib(rect);
                break;
            }
            case 7: {
                this.readRectTight(rect);
                break;
            }
            case 8: {
                this.unsupported(encoding);
                break;
            }
            case 15: {
                this.unsupported(encoding);
                break;
            }
            case 16: {
                this.unsupported(encoding);
                break;
            }
            case 17: {
                this.unsupported(encoding);
                break;
            }
            case -239: {
                this.readRectCursor(rect);
                break;
            }
            case -223: {
                this.readRectDesktopSize(rect);
                full.newSize = true;
                break;
            }
            case -232: {
                this.readPointerPos(rect);
                full.ptrPos = true;
                break;
            }
            default: {
                this.unsupported(encoding);
            }
        }
    }

    private void unsupported(int type) {
        JFLog.log("Unsupported encoding:" + type);
    }

    private void readRectRaw(Rectangle rect) {
        if (debugEncoding) {
            JFLog.log(log, "RFB:read RectType[]=0:rect=" + String.valueOf(rect));
        }
        byte[] data = this.read(rect.width * rect.height * 4);
        int src = 0;
        int x1 = rect.x;
        int x2 = x1 + rect.width - 1;
        int y1 = rect.y;
        int y2 = y1 + rect.height - 1;
        int dst = y1 * this.width + x1;
        int stride = this.width - rect.width;
        for (int y = y1; y <= y2; ++y) {
            for (int x = x1; x <= x2; ++x) {
                int px;
                this.buffer[dst] = px = RFB.getPixelBGR(data, src + 1) | 0xFF000000;
                src += 4;
                ++dst;
            }
            dst += stride;
        }
    }

    private void readRectCopy(Rectangle rect) {
        if (debugEncoding) {
            JFLog.log(log, "RFB:read RectType[]=1:rect=" + String.valueOf(rect));
        }
        byte[] pkt = this.read(4);
        int srcx = BE.getuint16(pkt, 0);
        int srcy = BE.getuint16(pkt, 2);
        int x1 = rect.x;
        int x2 = x1 + rect.width - 1;
        int y1 = rect.y;
        int y2 = y1 + rect.height - 1;
        int[] src = this.image.getPixels(srcx, srcy, rect.width, rect.height);
        int soff = 0;
        for (int y = y1; y <= y2; ++y) {
            for (int x = x1; x <= x2; ++x) {
                this.buffer[y * this.width + x] = src[soff++];
            }
        }
    }

    private void readRectRRE(Rectangle rect) {
        if (debugEncoding) {
            JFLog.log(log, "RFB:read RectType[]=2:rect=" + String.valueOf(rect));
        }
        byte[] pkt = this.read(8);
        int cnt = BE.getuint32(pkt, 0);
        int clr = RFB.getPixelBGR(pkt, 5);
        if (debugEncoding) {
            JFLog.log(log, "RFB:RRE:clr=" + Integer.toString(clr, 16));
        }
        this.fill(rect, clr);
        Rectangle subrect = new Rectangle();
        for (int a = 0; a < cnt; ++a) {
            pkt = this.read(12);
            clr = RFB.getPixelBGR(pkt, 1);
            subrect.x = rect.x + BE.getuint16(pkt, 4);
            subrect.y = rect.y + BE.getuint16(pkt, 6);
            subrect.width = BE.getuint16(pkt, 8);
            subrect.height = BE.getuint16(pkt, 10);
            if (debugEncoding) {
                JFLog.log(log, "RFB:RRE:SubRect=" + String.valueOf(subrect) + ",clr=" + Integer.toString(clr, 16));
            }
            this.fill(subrect, clr);
        }
    }

    private void readRectCoRRE(Rectangle rect) {
        if (debugEncoding) {
            JFLog.log(log, "RFB:read RectType[]=4:rect=" + String.valueOf(rect));
        }
        byte[] pkt = this.read(8);
        int cnt = BE.getuint32(pkt, 0);
        int clr = RFB.getPixelBGR(pkt, 5);
        this.fill(rect, clr);
        Rectangle subrect = new Rectangle();
        for (int a = 0; a < cnt; ++a) {
            pkt = this.read(8);
            clr = RFB.getPixelBGR(pkt, 1);
            subrect.x = rect.x + pkt[4] & 0xFF;
            subrect.y = rect.y + pkt[5] & 0xFF;
            subrect.width = pkt[6] & 0xFF;
            subrect.height = pkt[7] & 0xFF;
            this.fill(subrect, clr);
        }
    }

    private void readRectHexTile(Rectangle rect) {
        if (debugEncoding) {
            JFLog.log(log, "RFB:read RectType[]=5:rect=" + String.valueOf(rect));
        }
        this.hextile_bg = 0;
        this.hextile_fg = 0;
        for (int ty = rect.y; ty < rect.y + rect.height; ty += 16) {
            int th = 16;
            if (rect.y + rect.height - ty < 16) {
                th = rect.y + rect.height - ty;
            }
            for (int tx = rect.x; tx < rect.x + rect.width; tx += 16) {
                int tw = 16;
                if (rect.x + rect.width - tx < 16) {
                    tw = rect.x + rect.width - tx;
                }
                this.hextileSubrect(new Rectangle(tx, ty, tw, th));
            }
        }
    }

    private void hextileSubrect(Rectangle sr) {
        byte[] cbuf;
        int subencoding = this.readByte();
        if (debugEncoding) {
            JFLog.log(log, "RFB:HexTile:subType=0x" + Integer.toString(subencoding, 16) + ",rect=" + String.valueOf(sr));
        }
        if ((subencoding & 1) != 0) {
            this.readRectRaw(sr);
            return;
        }
        if ((subencoding & 2) != 0) {
            if (this.bytesPixel == 1) {
                cbuf = this.read(1);
                this.hextile_bg = this.colors[cbuf[0] & 0xFF];
            } else {
                cbuf = this.read(4);
                this.hextile_bg = RFB.getPixelBGR(cbuf, 1);
            }
            if (debugEncoding) {
                JFLog.log("RFB:HexTile:bg=0x" + Integer.toString(this.hextile_bg, 16));
            }
        }
        this.fill(sr, this.hextile_bg);
        if ((subencoding & 4) != 0) {
            if (this.bytesPixel == 1) {
                cbuf = this.read(1);
                this.hextile_fg = this.colors[cbuf[0] & 0xFF];
            } else {
                cbuf = this.read(4);
                this.hextile_fg = RFB.getPixelBGR(cbuf, 1);
            }
            if (debugEncoding) {
                JFLog.log("RFB:HexTile:fg=0x" + Integer.toString(this.hextile_bg, 16));
            }
        }
        if ((subencoding & 8) == 0) {
            return;
        }
        int nSubRects = this.readByte();
        if (debugEncoding) {
            JFLog.log("RFB:HexTile:SubRects=" + nSubRects);
        }
        int bufsize = nSubRects * 2;
        if ((subencoding & 0x10) != 0) {
            bufsize += nSubRects * this.bytesPixel;
        }
        byte[] buf = this.read(bufsize);
        int i = 0;
        if ((subencoding & 0x10) == 0) {
            for (int j = 0; j < nSubRects; ++j) {
                int b1 = buf[i++] & 0xFF;
                int b2 = buf[i++] & 0xFF;
                int sx = sr.x + (b1 >> 4);
                int sy = sr.y + (b1 & 0xF);
                int sw = (b2 >> 4) + 1;
                int sh = (b2 & 0xF) + 1;
                if (debugEncoding) {
                    JFLog.log("RFB:HexTile:SubRect=" + sx + "," + sy + ":" + sw + "," + sh);
                }
                this.fill(new Rectangle(sx, sy, sw, sh), this.hextile_fg);
            }
        } else if (this.bytesPixel == 1) {
            for (int j = 0; j < nSubRects; ++j) {
                int hextile_sub = this.colors[buf[i++] & 0xFF];
                int b1 = buf[i++] & 0xFF;
                int b2 = buf[i++] & 0xFF;
                int sx = sr.x + (b1 >> 4);
                int sy = sr.y + (b1 & 0xF);
                int sw = (b2 >> 4) + 1;
                int sh = (b2 & 0xF) + 1;
                if (debugEncoding) {
                    JFLog.log("RFB:HexTile:SubRectColored8=" + sx + "," + sy + ":" + sw + "," + sh);
                }
                this.fill(new Rectangle(sx, sy, sw, sh), hextile_sub);
            }
        } else {
            for (int j = 0; j < nSubRects; ++j) {
                int hextile_sg = RFB.getPixelBGR(buf, i + 1);
                i += 4;
                int b1 = buf[i++] & 0xFF;
                int b2 = buf[i++] & 0xFF;
                int sx = sr.x + (b1 >> 4);
                int sy = sr.y + (b1 & 0xF);
                int sw = (b2 >> 4) + 1;
                int sh = (b2 & 0xF) + 1;
                if (debugEncoding) {
                    JFLog.log("RFB:HexTile:SubRectColored32=" + sx + "," + sy + ":" + sw + "," + sh);
                }
                this.fill(new Rectangle(sx, sy, sw, sh), hextile_sg);
            }
        }
    }

    void readRectZlib(Rectangle rect) {
        if (debugEncoding) {
            JFLog.log(log, "RFB:read RectType[]=6:rect=" + String.valueOf(rect));
        }
        int nBytes = this.readInt();
        byte[] input = this.read(nBytes);
        if (this.zlibInflater == null) {
            this.zlibInflater = new Inflater();
        }
        this.zlibInflater.setInput(input);
        int x1 = rect.x;
        int y1 = rect.y;
        int x2 = x1 + rect.width - 1;
        int y2 = y1 + rect.height - 1;
        if (this.bytesPixel == 1) {
            byte[] pixels8 = null;
            for (int dy = y1; dy <= y2; ++dy) {
                try {
                    this.zlibInflater.inflate(pixels8, dy * this.width + x1, rect.width);
                    continue;
                }
                catch (Exception e) {
                    JFLog.log(log, (Throwable)e);
                }
            }
        } else {
            byte[] buf = new byte[rect.width * 4];
            for (int dy = y1; dy <= y2; ++dy) {
                try {
                    int length = this.zlibInflater.inflate(buf);
                    if (debug) {
                        JFLog.log("inflate.length=" + length);
                    }
                }
                catch (Exception e) {
                    JFLog.log(log, (Throwable)e);
                }
                int offset = dy * this.width + rect.x;
                for (int i = 0; i < rect.width; ++i) {
                    this.buffer[offset + i] = RFB.getPixelBGR(buf, i * 4 + 1) | 0xFF000000;
                }
            }
        }
    }

    private void readRectCursor(Rectangle rect) {
        if (debugEncoding) {
            JFLog.log(log, "RFB:read RectType[]=-239:rect=" + String.valueOf(rect));
        }
        int cursorLen = rect.width * rect.height * this.bytesPixel;
        byte[] cursor = this.read(cursorLen);
        int bitmaskLen = (rect.width + 7) / 8 * rect.height;
        byte[] bitmask = this.read(bitmaskLen);
    }

    private void readRectTight(Rectangle rect) {
        int dataSize;
        int i;
        byte[] buf;
        if (debugEncoding) {
            JFLog.log(log, "RFB:read RectType[]=7:rect=" + String.valueOf(rect));
        }
        int comp_ctl = this.readByte();
        for (int stream_id = 0; stream_id < 4; ++stream_id) {
            if ((comp_ctl & 1) != 0 && this.tightInflaters[stream_id] != null) {
                this.tightInflaters[stream_id] = null;
            }
            comp_ctl >>= 1;
        }
        if (comp_ctl > 9) {
            JFLog.log(log, "RFB:Incorrect tight subencoding: " + comp_ctl);
            this.connected = false;
            return;
        }
        if (debug) {
            JFLog.log(log, "RFB:Tight:SubType=" + comp_ctl);
        }
        if (comp_ctl == 8) {
            if (this.bytesPixel == 1) {
                int idx = this.readByte();
                this.clr = this.colors[idx];
            } else {
                byte[] buf2 = this.read(3);
                this.clr = RFB.getPixelRGB(buf2, 0);
            }
            this.fill(rect, this.clr);
            return;
        }
        if (comp_ctl == 9) {
            JFImage tmp = new JFImage();
            byte[] jpegData = this.read(this.readCompactLen());
            if (!tmp.loadJPG(new ByteArrayInputStream(jpegData))) {
                JFLog.log(log, "RFB:Error:Unable to load JPEG image");
                return;
            }
            this.image.putJFImage(tmp, rect.x, rect.y);
            return;
        }
        int numColors = 0;
        int rowSize = rect.width;
        byte[] palette8 = new byte[2];
        int[] palette24 = new int[256];
        boolean useGradient = false;
        if ((comp_ctl & 4) != 0) {
            int filter_id = this.readByte();
            if (filter_id == 1) {
                numColors = this.readByte() + 1;
                if (this.bytesPixel == 1) {
                    if (numColors != 2) {
                        JFLog.log(log, "RFB:Incorrect tight palette size: " + numColors);
                        return;
                    }
                    palette8 = this.read(2);
                } else {
                    buf = this.read(numColors * 3);
                    for (i = 0; i < numColors; ++i) {
                        palette24[i] = RFB.getPixelRGB(buf, i * 3) | 0xFF000000;
                    }
                }
                if (numColors == 2) {
                    rowSize = (rect.width + 7) / 8;
                }
            } else if (filter_id == 2) {
                useGradient = true;
            } else if (filter_id != 0) {
                JFLog.log(log, "RFB:Incorrect tight filter id: " + filter_id);
                return;
            }
        }
        if (numColors == 0 && this.bytesPixel == 4) {
            rowSize *= 3;
        }
        if ((dataSize = rect.height * rowSize) < 12) {
            if (numColors != 0) {
                byte[] indexedData = this.read(dataSize);
                if (numColors == 2) {
                    if (this.bytesPixel == 1) {
                        this.decodeMonoData(rect, indexedData, palette8);
                    } else {
                        this.decodeMonoData(rect, indexedData, palette24);
                    }
                } else {
                    i = 0;
                    for (int dy = rect.y; dy < rect.y + rect.height; ++dy) {
                        for (int dx = rect.x; dx < rect.x + rect.width; ++dx) {
                            this.buffer[dy * this.width + dx] = palette24[indexedData[i++] & 0xFF];
                        }
                    }
                }
            } else if (useGradient) {
                buf = this.read(rect.width * rect.height * 3);
                this.decodeGradientData(rect, buf);
            } else if (this.bytesPixel == 1) {
                for (int dy = rect.y; dy < rect.y + rect.height; ++dy) {
                    byte[] pixels8 = this.read(rect.width);
                    for (int a = 0; a < pixels8.length; ++a) {
                        this.buffer[a] = pixels8[dy * this.width + rect.x] | 0xFF000000;
                    }
                }
            } else {
                for (int dy = rect.y; dy < rect.y + rect.height; ++dy) {
                    buf = this.read(rect.width * 3);
                    int offset = dy * this.width + rect.x;
                    for (i = 0; i < rect.width; ++i) {
                        this.buffer[offset + i] = RFB.getPixelRGB(buf, i * 3) | 0xFF000000;
                    }
                }
            }
        } else {
            int zlibDataLen = this.readCompactLen();
            byte[] zlibData = this.read(zlibDataLen);
            int stream_id = comp_ctl & 3;
            if (this.tightInflaters[stream_id] == null) {
                this.tightInflaters[stream_id] = new Inflater();
            }
            Inflater myInflater = this.tightInflaters[stream_id];
            myInflater.setInput(zlibData);
            byte[] buf3 = new byte[dataSize];
            try {
                int length = myInflater.inflate(buf3);
                if (debug) {
                    JFLog.log("Tight.length=" + length);
                }
            }
            catch (Exception e) {
                JFLog.log(log, (Throwable)e);
                return;
            }
            if (numColors != 0) {
                if (numColors == 2) {
                    if (this.bytesPixel == 1) {
                        this.decodeMonoData(rect, buf3, palette8);
                    } else {
                        this.decodeMonoData(rect, buf3, palette24);
                    }
                } else {
                    int i2 = 0;
                    for (int dy = rect.y; dy < rect.y + rect.height; ++dy) {
                        for (int dx = rect.x; dx < rect.x + rect.width; ++dx) {
                            this.buffer[dy * this.width + dx] = palette24[buf3[i2++] & 0xFF];
                        }
                    }
                }
            } else if (useGradient) {
                this.decodeGradientData(rect, buf3);
            } else if (this.bytesPixel == 1) {
                int destOffset = rect.y * this.width + rect.x;
                for (int dy = 0; dy < rect.height; ++dy) {
                    for (int x = 0; x < rect.width; ++x) {
                        this.buffer[destOffset] = buf3[dy * rect.width + x] | 0xFF000000;
                    }
                    destOffset += this.width;
                }
            } else {
                int srcOffset = 0;
                for (int dy = 0; dy < rect.height; ++dy) {
                    int destOffset = (rect.y + dy) * this.width + rect.x;
                    for (int i3 = 0; i3 < rect.width; ++i3) {
                        this.buffer[destOffset + i3] = RFB.getPixelRGB(buf3, srcOffset) | 0xFF000000;
                        srcOffset += 3;
                    }
                }
            }
        }
    }

    void decodeMonoData(Rectangle r, byte[] src, byte[] palette) {
        int i = r.y * this.width + r.x;
        int rowBytes = (r.width + 7) / 8;
        for (int dy = 0; dy < r.height; ++dy) {
            int n;
            int dx;
            for (dx = 0; dx < r.width / 8; ++dx) {
                byte b = src[dy * rowBytes + dx];
                for (n = 7; n >= 0; --n) {
                    this.buffer[i++] = palette[b >> n & 1] | 0xFF000000;
                }
            }
            for (n = 7; n >= 8 - r.width % 8; --n) {
                this.buffer[i++] = palette[src[dy * rowBytes + dx] >> n & 1] | 0xFF000000;
            }
            i += this.width - r.width;
        }
    }

    void decodeMonoData(Rectangle r, byte[] src, int[] palette) {
        int i = r.y * this.width + r.x;
        int rowBytes = (r.width + 7) / 8;
        for (int dy = 0; dy < r.height; ++dy) {
            int n;
            int dx;
            for (dx = 0; dx < r.width / 8; ++dx) {
                byte b = src[dy * rowBytes + dx];
                for (n = 7; n >= 0; --n) {
                    this.buffer[i++] = palette[b >> n & 1];
                }
            }
            for (n = 7; n >= 8 - r.width % 8; --n) {
                this.buffer[i++] = palette[src[dy * rowBytes + dx] >> n & 1];
            }
            i += this.width - r.width;
        }
    }

    void decodeGradientData(Rectangle r, byte[] buf) {
        byte[] prevRow = new byte[r.width * 3];
        byte[] thisRow = new byte[r.width * 3];
        byte[] pix = new byte[3];
        int[] est = new int[3];
        int offset = r.y * this.width + r.x;
        for (int dy = 0; dy < r.height; ++dy) {
            int c;
            for (c = 0; c < 3; ++c) {
                pix[c] = (byte)(prevRow[c] + buf[dy * r.width * 3 + c]);
                thisRow[c] = pix[c];
            }
            this.buffer[offset++] = RFB.getPixelRGB(pix, 0);
            for (int dx = 1; dx < r.width; ++dx) {
                for (c = 0; c < 3; ++c) {
                    est[c] = (prevRow[dx * 3 + c] & 0xFF) + (pix[c] & 0xFF) - (prevRow[(dx - 1) * 3 + c] & 0xFF);
                    if (est[c] > 255) {
                        est[c] = 255;
                    } else if (est[c] < 0) {
                        est[c] = 0;
                    }
                    pix[c] = (byte)(est[c] + buf[(dy * r.width + dx) * 3 + c]);
                    thisRow[dx * 3 + c] = pix[c];
                }
                this.buffer[offset++] = RFB.getPixelRGB(pix, 0);
            }
            System.arraycopy(thisRow, 0, prevRow, 0, r.width * 3);
            offset += this.width - r.width;
        }
    }

    private void readRectDesktopSize(Rectangle rect) {
        if (debugEncoding) {
            JFLog.log(log, "RFB:read RectType[]=-223:rect=" + String.valueOf(rect));
        }
        this.width = rect.width;
        this.height = rect.height;
        this.setSize();
    }

    private void readPointerPos(Rectangle rect) {
        if (debugEncoding) {
            JFLog.log(log, "RFB:read RectType[]=-232:rect=" + String.valueOf(rect));
        }
        this.mx = rect.x;
        this.my = rect.y;
        if (debug) {
            JFLog.log("Pointer Pos:" + this.mx + "," + this.my);
        }
    }

    private void writeRectangle(Rectangle rect, int encoding) {
        byte[] pkt = new byte[12];
        BE.setuint16(pkt, 0, rect.x);
        BE.setuint16(pkt, 2, rect.y);
        BE.setuint16(pkt, 4, rect.width);
        BE.setuint16(pkt, 6, rect.height);
        BE.setuint32(pkt, 8, encoding);
        this.write(pkt);
        switch (encoding) {
            case 0: {
                this.writeRectRaw(rect);
                break;
            }
            case 6: {
                this.writeRectZlib(rect);
                break;
            }
            case 7: {
                this.writeRectTight(rect);
                break;
            }
            case -223: {
                this.writeRectDesktopSize(rect);
            }
        }
    }

    private void writeRectDesktopSize(Rectangle rect) {
        this.width = rect.width;
        this.height = rect.height;
        this.setSize();
    }

    private void readPixel(int src, byte[] out, int dst) {
        int px = this.buffer[src];
        out[dst + 0] = (byte)(px & 0xFF);
        out[dst + 1] = (byte)((px >>>= 8) & 0xFF);
        out[dst + 2] = (byte)((px >>>= 8) & 0xFF);
    }

    private void writeRectRaw(Rectangle rect) {
        byte[] data = new byte[rect.width * rect.height * 4];
        int src = 0;
        int dst = 0;
        int x1 = rect.x;
        int x2 = x1 + rect.width - 1;
        int y1 = rect.y;
        int y2 = y1 + rect.height - 1;
        int stride = this.width - rect.width;
        for (int y = y1; y <= y2; ++y) {
            for (int x = x1; x <= x2; ++x) {
                this.readPixel(src, data, dst);
                ++src;
                dst += 4;
            }
            src += stride;
        }
        this.write(data);
    }

    private void writeRectZlib(Rectangle rect) {
        if (this.zlibDeflater == null) {
            this.zlibDeflater = new Deflater();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] input = new byte[rect.width * 4];
        byte[] output = new byte[input.length + 128];
        int x1 = rect.x;
        int y1 = rect.y;
        int x2 = x1 + rect.width - 1;
        int y2 = y1 + rect.height - 1;
        int src_idx = y1 * this.width + x1;
        int dst_idx = 0;
        int stride = this.width - rect.width;
        for (int y = y1; y <= y2; ++y) {
            dst_idx = 0;
            for (int x = x1; x <= x2; ++x) {
                this.readPixel(src_idx, input, dst_idx);
                ++src_idx;
                dst_idx += 4;
            }
            src_idx += stride;
            this.zlibDeflater.setInput(input);
            int length = this.zlibDeflater.deflate(output, 0, output.length, 2);
            if (debug) {
                JFLog.log("length=" + length);
            }
            baos.write(output, 0, length);
        }
        byte[] out = baos.toByteArray();
        this.writeInt(out.length);
        this.write(out);
    }

    private void writeRectTight(Rectangle r) {
        int x1 = r.x;
        int x2 = x1 + r.width - 1;
        int y1 = r.y;
        int y2 = y1 + r.height - 1;
        int size = r.width * r.height * 3;
        this.writeByte(0);
        if (size < 12) {
            byte[] raw = new byte[size];
            int src = y1 * this.width + x1;
            int dst = 0;
            int stride = this.width - r.width;
            for (int y = y1; y <= y2; ++y) {
                for (int x = x1; x <= x2; ++x) {
                    this.readPixel(src, raw, dst);
                    ++src;
                    dst += 3;
                }
                src += stride;
            }
            this.write(raw);
        } else {
            if (this.zlibDeflater == null) {
                this.zlibDeflater = new Deflater();
            }
            byte[] raw = new byte[size];
            int src = y1 * this.width + x1;
            int dst = 0;
            int stride = this.width - r.width;
            for (int y = y1; y <= y2; ++y) {
                for (int x = x1; x <= x2; ++x) {
                    this.readPixel(src, raw, dst);
                    ++src;
                    dst += 3;
                }
                src += stride;
            }
            byte[] output = new byte[size * 2];
            this.zlibDeflater.setInput(raw);
            int length = this.zlibDeflater.deflate(output, 0, output.length, 2);
            this.writeCompactLen(length);
            this.write(output, 0, length);
        }
    }

    public byte[] readColorMap() {
        byte[] pkt = this.read(5);
        int first = BE.getuint16(pkt, 1);
        int count = BE.getuint16(pkt, 3);
        if (debug) {
            JFLog.log(log, "RFB:read ColorMap:first=" + first + ",count=" + count);
        }
        byte[] clrs = this.read(count * 6);
        if (debug) {
            JFLog.log(log, "RFB:read ColorMap:array=" + String.valueOf(clrs));
        }
        return clrs;
    }

    public void readBell() {
    }

    public String readCutText() {
        byte[] pkt = this.read(7);
        int strlen = BE.getuint32(pkt, 3);
        if (strlen > 0x100000) {
            this.connected = false;
            return null;
        }
        byte[] bytes = this.read(strlen);
        return new String(bytes);
    }

    static {
        PF_LE_RGB = 0;
        PF_BE_BGR = 1;
        VERSION_3_3 = 3.3f;
        VERSION_3_7 = 3.7f;
        VERSION_3_8 = 3.8f;
    }

    public static class Rectangle {
        public int x;
        public int y;
        public int width;
        public int height;
        public boolean newSize;
        public boolean ptrPos;

        public Rectangle() {
        }

        public Rectangle(java.awt.Rectangle r) {
            this.x = r.x;
            this.y = r.y;
            this.width = r.width;
            this.height = r.height;
        }

        public Rectangle(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public Rectangle(Rectangle o) {
            this.x = o.x;
            this.y = o.y;
            this.width = o.width;
            this.height = o.height;
        }

        public void add(Rectangle rect) {
            if (this.width == 0 || this.height == 0) {
                this.x = rect.x;
                this.y = rect.y;
                this.width = rect.width;
                this.height = rect.height;
                return;
            }
            int rx1 = rect.x;
            int rx2 = rx1 + rect.width - 1;
            int ry1 = rect.y;
            int ry2 = ry1 + rect.height - 1;
            int tx1 = this.x;
            int tx2 = tx1 + this.width - 1;
            int ty1 = this.y;
            int ty2 = ty1 + this.height - 1;
            if (rx1 < tx1) {
                tx1 = rx1;
            }
            if (ry1 < ty1) {
                ty1 = ry1;
            }
            if (rx2 > tx2) {
                tx2 = rx2;
            }
            if (ry2 > ty2) {
                ty2 = ry2;
            }
            this.x = tx1;
            this.y = ty1;
            this.width = tx2 - tx1 + 1;
            this.height = ty2 - ty1 + 1;
        }

        public String toString() {
            return "Rectangle:" + this.x + "," + this.y + ":" + this.width + "x" + this.height;
        }
    }

    public static class PixelFormat {
        public int bpp;
        public int depth;
        public boolean be;
        public boolean tc;
        public int r_max;
        public int g_max;
        public int b_max;
        public int r_shift;
        public int g_shift;
        public int b_shift;

        public int bytesPixel() {
            switch (this.bpp) {
                case 8: {
                    return 1;
                }
                case 16: {
                    return 2;
                }
                case 32: {
                    return 4;
                }
            }
            return 0;
        }

        public void decode(byte[] pkt, int offset) {
            this.bpp = pkt[offset++] & 0xFF;
            this.depth = pkt[offset++];
            this.be = pkt[offset++] == 1;
            this.tc = pkt[offset++] == 1;
            this.r_max = BE.getuint16(pkt, offset);
            this.g_max = BE.getuint16(pkt, offset += 2);
            this.b_max = BE.getuint16(pkt, offset += 2);
            offset += 2;
            this.r_shift = pkt[offset++];
            this.g_shift = pkt[offset++];
            this.b_shift = pkt[offset++];
        }

        public void encode(byte[] pkt, int offset) {
            pkt[offset++] = (byte)this.bpp;
            pkt[offset++] = (byte)this.depth;
            pkt[offset++] = (byte)(this.be ? 1 : 0);
            pkt[offset++] = (byte)(this.tc ? 1 : 0);
            BE.setuint16(pkt, offset, this.r_max);
            BE.setuint16(pkt, offset += 2, this.g_max);
            BE.setuint16(pkt, offset += 2, this.b_max);
            offset += 2;
            pkt[offset++] = (byte)this.r_shift;
            pkt[offset++] = (byte)this.g_shift;
            pkt[offset++] = (byte)this.b_shift;
        }

        public static PixelFormat create_24bpp(boolean be) {
            PixelFormat pf = new PixelFormat();
            pf.bpp = 32;
            pf.depth = 24;
            pf.be = be;
            pf.tc = true;
            pf.r_max = 255;
            pf.g_max = 255;
            pf.b_max = 255;
            if (be) {
                pf.r_shift = 0;
                pf.g_shift = 8;
                pf.b_shift = 16;
            } else {
                pf.r_shift = 16;
                pf.g_shift = 8;
                pf.b_shift = 0;
            }
            return pf;
        }

        public int getFormat() {
            if (this.be) {
                return PF_LE_RGB;
            }
            return PF_BE_BGR;
        }

        public String toString() {
            return "PixelFormat:" + this.bpp + "," + this.depth + ",be=" + this.be + ",tc=" + this.tc + ",r=" + this.r_shift + ",g=" + this.g_shift + ",b=" + this.b_shift;
        }
    }

    public static class RFBKeyEvent {
        public int code;
        public boolean down;
    }

    public static class RFBMouseEvent {
        public int x;
        public int y;
        public int buttons;
    }
}

