/*
 * Decompiled with CFR 0.152.
 */
package javaforce.codec.speex;

import javaforce.codec.speex.Bits;
import javaforce.codec.speex.CbSearch;
import javaforce.codec.speex.Filters;
import javaforce.codec.speex.VQ;

public class SplitShapeSearch
extends CbSearch {
    public static final int MAX_COMPLEXITY = 10;
    private final int subvect_size;
    private final int nb_subvect;
    private final int[] shape_cb;
    private final int shape_cb_size;
    private final int shape_bits;
    private final int have_sign;
    private final int[] ind;
    private final int[] signs;
    private final float[] t;
    private final float[] e;
    private final float[] E;
    private final float[] r2;
    private float[][] ot;
    private float[][] nt;
    private final int[][] nind;
    private final int[][] oind;

    public SplitShapeSearch(int subframesize, int subvect_size, int nb_subvect, int[] shape_cb, int shape_bits, int have_sign) {
        this.subvect_size = subvect_size;
        this.nb_subvect = nb_subvect;
        this.shape_cb = shape_cb;
        this.shape_bits = shape_bits;
        this.have_sign = have_sign;
        this.ind = new int[nb_subvect];
        this.signs = new int[nb_subvect];
        this.shape_cb_size = 1 << shape_bits;
        this.ot = new float[10][subframesize];
        this.nt = new float[10][subframesize];
        this.oind = new int[10][nb_subvect];
        this.nind = new int[10][nb_subvect];
        this.t = new float[subframesize];
        this.e = new float[subframesize];
        this.r2 = new float[subframesize];
        this.E = new float[this.shape_cb_size];
    }

    @Override
    public final void quant(float[] target, float[] ak, float[] awk1, float[] awk2, int p, int nsf, float[] exc, int es, float[] r, Bits bits, int complexity) {
        int k;
        int j;
        int i;
        int N = complexity;
        if (N > 10) {
            N = 10;
        }
        float[] resp = new float[this.shape_cb_size * this.subvect_size];
        int[] best_index = new int[N];
        float[] best_dist = new float[N];
        float[] ndist = new float[N];
        float[] odist = new float[N];
        for (i = 0; i < N; ++i) {
            for (j = 0; j < this.nb_subvect; ++j) {
                this.oind[i][j] = -1;
                this.nind[i][j] = -1;
            }
        }
        for (j = 0; j < N; ++j) {
            for (i = 0; i < nsf; ++i) {
                this.ot[j][i] = target[i];
            }
        }
        for (i = 0; i < this.shape_cb_size; ++i) {
            int res = i * this.subvect_size;
            int shape = i * this.subvect_size;
            for (j = 0; j < this.subvect_size; ++j) {
                resp[res + j] = 0.0f;
                for (k = 0; k <= j; ++k) {
                    int n = res + j;
                    resp[n] = resp[n] + 0.03125f * (float)this.shape_cb[shape + k] * r[j - k];
                }
            }
            this.E[i] = 0.0f;
            for (j = 0; j < this.subvect_size; ++j) {
                int n = i;
                this.E[n] = this.E[n] + resp[res + j] * resp[res + j];
            }
        }
        for (j = 0; j < N; ++j) {
            odist[j] = 0.0f;
        }
        for (i = 0; i < this.nb_subvect; ++i) {
            int m;
            int offset = i * this.subvect_size;
            for (j = 0; j < N; ++j) {
                ndist[j] = -1.0f;
            }
            for (j = 0; j < N; ++j) {
                if (this.have_sign != 0) {
                    VQ.nbest_sign(this.ot[j], offset, resp, this.subvect_size, this.shape_cb_size, this.E, N, best_index, best_dist);
                } else {
                    VQ.nbest(this.ot[j], offset, resp, this.subvect_size, this.shape_cb_size, this.E, N, best_index, best_dist);
                }
                block12: for (k = 0; k < N; ++k) {
                    int n;
                    int q;
                    float err = 0.0f;
                    float[] ct = this.ot[j];
                    for (m = offset; m < offset + this.subvect_size; ++m) {
                        this.t[m] = ct[m];
                    }
                    float sign = 1.0f;
                    int rind = best_index[k];
                    if (rind >= this.shape_cb_size) {
                        sign = -1.0f;
                        rind -= this.shape_cb_size;
                    }
                    int res = rind * this.subvect_size;
                    if (sign > 0.0f) {
                        for (m = 0; m < this.subvect_size; ++m) {
                            int n2 = offset + m;
                            this.t[n2] = this.t[n2] - resp[res + m];
                        }
                    } else {
                        for (m = 0; m < this.subvect_size; ++m) {
                            int n3 = offset + m;
                            this.t[n3] = this.t[n3] + resp[res + m];
                        }
                    }
                    err = odist[j];
                    for (m = offset; m < offset + this.subvect_size; ++m) {
                        err += this.t[m] * this.t[m];
                    }
                    if (!(err < ndist[N - 1]) && !(ndist[N - 1] < -0.5f)) continue;
                    for (m = offset + this.subvect_size; m < nsf; ++m) {
                        this.t[m] = ct[m];
                    }
                    for (m = 0; m < this.subvect_size; ++m) {
                        sign = 1.0f;
                        int rind2 = best_index[k];
                        if (rind2 >= this.shape_cb_size) {
                            sign = -1.0f;
                            rind2 -= this.shape_cb_size;
                        }
                        float g = sign * 0.03125f * (float)this.shape_cb[rind2 * this.subvect_size + m];
                        q = this.subvect_size - m;
                        n = offset + this.subvect_size;
                        while (n < nsf) {
                            int n4 = n++;
                            this.t[n4] = this.t[n4] - g * r[q];
                            ++q;
                        }
                    }
                    for (m = 0; m < N; ++m) {
                        if (!(err < ndist[m]) && !(ndist[m] < -0.5f)) continue;
                        for (n = N - 1; n > m; --n) {
                            for (q = offset + this.subvect_size; q < nsf; ++q) {
                                this.nt[n][q] = this.nt[n - 1][q];
                            }
                            for (q = 0; q < this.nb_subvect; ++q) {
                                this.nind[n][q] = this.nind[n - 1][q];
                            }
                            ndist[n] = ndist[n - 1];
                        }
                        for (q = offset + this.subvect_size; q < nsf; ++q) {
                            this.nt[m][q] = this.t[q];
                        }
                        for (q = 0; q < this.nb_subvect; ++q) {
                            this.nind[m][q] = this.oind[j][q];
                        }
                        this.nind[m][i] = best_index[k];
                        ndist[m] = err;
                        continue block12;
                    }
                }
                if (i == 0) break;
            }
            float[][] tmp2 = this.ot;
            this.ot = this.nt;
            this.nt = tmp2;
            for (j = 0; j < N; ++j) {
                for (m = 0; m < this.nb_subvect; ++m) {
                    this.oind[j][m] = this.nind[j][m];
                }
            }
            for (j = 0; j < N; ++j) {
                odist[j] = ndist[j];
            }
        }
        for (i = 0; i < this.nb_subvect; ++i) {
            this.ind[i] = this.nind[0][i];
            bits.pack(this.ind[i], this.shape_bits + this.have_sign);
        }
        for (i = 0; i < this.nb_subvect; ++i) {
            float sign = 1.0f;
            int rind = this.ind[i];
            if (rind >= this.shape_cb_size) {
                sign = -1.0f;
                rind -= this.shape_cb_size;
            }
            for (j = 0; j < this.subvect_size; ++j) {
                this.e[this.subvect_size * i + j] = sign * 0.03125f * (float)this.shape_cb[rind * this.subvect_size + j];
            }
        }
        for (j = 0; j < nsf; ++j) {
            int n = es + j;
            exc[n] = exc[n] + this.e[j];
        }
        Filters.syn_percep_zero(this.e, 0, ak, awk1, awk2, this.r2, nsf, p);
        for (j = 0; j < nsf; ++j) {
            int n = j;
            target[n] = target[n] - this.r2[j];
        }
    }

    @Override
    public final void unquant(float[] exc, int es, int nsf, Bits bits) {
        int i;
        for (i = 0; i < this.nb_subvect; ++i) {
            this.signs[i] = this.have_sign != 0 ? bits.unpack(1) : 0;
            this.ind[i] = bits.unpack(this.shape_bits);
        }
        for (i = 0; i < this.nb_subvect; ++i) {
            float s = 1.0f;
            if (this.signs[i] != 0) {
                s = -1.0f;
            }
            for (int j = 0; j < this.subvect_size; ++j) {
                int n = es + this.subvect_size * i + j;
                exc[n] = exc[n] + s * 0.03125f * (float)this.shape_cb[this.ind[i] * this.subvect_size + j];
            }
        }
    }
}

